/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.yql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;

public final class YqlOrderBy
implements YqlStatementPart<YqlOrderBy> {
    public static final String TYPE = "OrderBy";
    private final List<SortKey> keys;

    private YqlOrderBy(@NonNull List<SortKey> keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        YqlOrderBy.validateKeys(keys);
        this.keys = ImmutableList.copyOf(keys);
    }

    private static void validateKeys(@NonNull List<SortKey> keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        HashSet<String> uniqueFieldPaths = new HashSet<String>();
        for (SortKey key : keys) {
            String fieldPath = key.fieldPath;
            if (uniqueFieldPaths.add(fieldPath)) continue;
            throw new IllegalArgumentException(String.format("Field \"%s\" is mentioned multiple times in ORDER BY", fieldPath));
        }
    }

    public static YqlOrderBy orderBy(String fieldPath, String ... otherFieldPaths) {
        return new Builder().asc(fieldPath, otherFieldPaths).build();
    }

    public static YqlOrderBy orderBy(String fieldPath, SortOrder order) {
        return new Builder().by(fieldPath, order).build();
    }

    public static YqlOrderBy orderBy(SortKey key, SortKey ... otherKeys) {
        return new Builder().by(key, otherKeys).build();
    }

    public static YqlOrderBy orderBy(Collection<SortKey> keys) {
        return new Builder().by(keys).build();
    }

    public static Builder order() {
        return new Builder();
    }

    @Override
    public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        return this.keys.stream().map(k -> k.toYql(schema)).collect(Collectors.joining(", "));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getYqlPrefix() {
        return "ORDER BY ";
    }

    @Override
    public int getPriority() {
        return 100;
    }

    public String toString() {
        return String.format("order by %s", this.keys.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    @Generated
    public List<SortKey> getKeys() {
        return this.keys;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YqlOrderBy)) {
            return false;
        }
        YqlOrderBy other = (YqlOrderBy)o;
        List<SortKey> this$keys = this.getKeys();
        List<SortKey> other$keys = other.getKeys();
        return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SortKey> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        return result;
    }

    public static final class SortKey {
        private final String fieldPath;
        private final SortOrder order;

        private <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            return schema.getField(this.fieldPath).flatten().map(jf -> String.format("`%s` %s", new Object[]{jf.getName(), this.order})).collect(Collectors.joining(", "));
        }

        public String toString() {
            return String.format("%s %s", new Object[]{this.fieldPath, this.order});
        }

        @ConstructorProperties(value={"fieldPath", "order"})
        @Generated
        public SortKey(String fieldPath, SortOrder order) {
            this.fieldPath = fieldPath;
            this.order = order;
        }

        @Generated
        public String getFieldPath() {
            return this.fieldPath;
        }

        @Generated
        public SortOrder getOrder() {
            return this.order;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortKey)) {
                return false;
            }
            SortKey other = (SortKey)o;
            String this$fieldPath = this.getFieldPath();
            String other$fieldPath = other.getFieldPath();
            if (this$fieldPath == null ? other$fieldPath != null : !this$fieldPath.equals(other$fieldPath)) {
                return false;
            }
            SortOrder this$order = this.getOrder();
            SortOrder other$order = other.getOrder();
            return !(this$order == null ? other$order != null : !((Object)((Object)this$order)).equals((Object)other$order));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fieldPath = this.getFieldPath();
            result = result * 59 + ($fieldPath == null ? 43 : $fieldPath.hashCode());
            SortOrder $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : ((Object)((Object)$order)).hashCode());
            return result;
        }
    }

    public static final class Builder {
        private final ImmutableList.Builder<SortKey> keyBldr = ImmutableList.builder();

        private Builder() {
        }

        public Builder asc(String fieldPath, String ... otherFieldPaths) {
            Stream.concat(Stream.of(fieldPath), Arrays.stream(otherFieldPaths)).map(fp -> new SortKey((String)fp, SortOrder.ASC)).forEach(arg_0 -> this.keyBldr.add(arg_0));
            return this;
        }

        public Builder desc(String fieldPath, String ... otherFieldPaths) {
            Stream.concat(Stream.of(fieldPath), Arrays.stream(otherFieldPaths)).map(fp -> new SortKey((String)fp, SortOrder.DESC)).forEach(arg_0 -> this.keyBldr.add(arg_0));
            return this;
        }

        public Builder by(String fieldPath, SortOrder order) {
            return this.by(new SortKey(fieldPath, order), new SortKey[0]);
        }

        public Builder by(SortKey key, SortKey ... otherKeys) {
            this.keyBldr.add((Object)key);
            this.keyBldr.add((Object[])otherKeys);
            return this;
        }

        public Builder by(Collection<SortKey> keys) {
            this.keyBldr.addAll(keys);
            return this;
        }

        public YqlOrderBy build() {
            ImmutableList keys = this.keyBldr.build();
            Preconditions.checkState((!keys.isEmpty() ? 1 : 0) != 0, (Object)"ORDER BY must have at least one key to sort by");
            return new YqlOrderBy((List<SortKey>)keys);
        }
    }

    public static enum SortOrder {
        ASC("ASC"),
        DESC("DESC");

        private final String yql;

        private SortOrder(String yql) {
            this.yql = yql;
        }

        public String toString() {
            return this.yql;
        }
    }
}

