/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.yql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import tech.ydb.yoj.databind.expression.AndExpr;
import tech.ydb.yoj.databind.expression.FilterExpression;
import tech.ydb.yoj.databind.expression.LeafExpression;
import tech.ydb.yoj.databind.expression.ListExpr;
import tech.ydb.yoj.databind.expression.NotExpr;
import tech.ydb.yoj.databind.expression.NullExpr;
import tech.ydb.yoj.databind.expression.OrExpr;
import tech.ydb.yoj.databind.expression.OrderExpression;
import tech.ydb.yoj.databind.expression.ScalarExpr;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.ydb.yql.YqlOrderBy;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicate;

public final class YqlListingQuery {
    private static final FilterExpression.Visitor<?, String> FIELD_NAME_VISITOR = new FilterExpression.Visitor.Simple<Object, String>(){

        protected String visitLeaf(@NonNull LeafExpression<Object> leaf) {
            if (leaf == null) {
                throw new NullPointerException("leaf is marked non-null but is null");
            }
            return leaf.getFieldName();
        }

        protected String visitComposite(@NonNull FilterExpression<Object> composite) {
            if (composite == null) {
                throw new NullPointerException("composite is marked non-null but is null");
            }
            return null;
        }
    };
    private static final CharMatcher LIKE_PATTERN_CHARS = CharMatcher.anyOf((CharSequence)"%_").precomputed();
    private static final char LIKE_ESCAPE_CHAR = '^';

    private YqlListingQuery() {
    }

    @VisibleForTesting
    public static <T extends Entity<T>> YqlPredicate toYqlPredicate(@NonNull FilterExpression<T> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return (YqlPredicate)filter.visit(new FilterExpression.Visitor<T, YqlPredicate>(){

            public YqlPredicate visitScalarExpr(@NonNull ScalarExpr<T> scalarExpr) {
                if (scalarExpr == null) {
                    throw new NullPointerException("scalarExpr is marked non-null but is null");
                }
                String fieldPath = scalarExpr.getFieldPath();
                YqlPredicate.FieldPredicateBuilder pred = YqlPredicate.where(fieldPath);
                Object expected = scalarExpr.getValue().getRaw(scalarExpr.getField());
                return switch (scalarExpr.getOperator()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ScalarExpr.Operator.EQ -> pred.eq(expected);
                    case ScalarExpr.Operator.NEQ -> pred.neq(expected);
                    case ScalarExpr.Operator.LT -> pred.lt(expected);
                    case ScalarExpr.Operator.LTE -> pred.lte(expected);
                    case ScalarExpr.Operator.GT -> pred.gt(expected);
                    case ScalarExpr.Operator.GTE -> pred.gte(expected);
                    case ScalarExpr.Operator.CONTAINS -> pred.like(YqlListingQuery.likePatternForContains((String)expected), Character.valueOf('^'));
                    case ScalarExpr.Operator.NOT_CONTAINS -> pred.notLike(YqlListingQuery.likePatternForContains((String)expected), Character.valueOf('^'));
                    case ScalarExpr.Operator.STARTS_WITH -> pred.like(YqlListingQuery.likePatternForStartsWith((String)expected), Character.valueOf('^'));
                    case ScalarExpr.Operator.ENDS_WITH -> pred.like(YqlListingQuery.likePatternForEndsWith((String)expected), Character.valueOf('^'));
                };
            }

            public YqlPredicate visitNullExpr(@NonNull NullExpr<T> nullExpr) {
                if (nullExpr == null) {
                    throw new NullPointerException("nullExpr is marked non-null but is null");
                }
                String fieldPath = nullExpr.getFieldPath();
                YqlPredicate.FieldPredicateBuilder pred = YqlPredicate.where(fieldPath);
                return switch (nullExpr.getOperator()) {
                    default -> throw new IncompatibleClassChangeError();
                    case NullExpr.Operator.IS_NULL -> pred.isNull();
                    case NullExpr.Operator.IS_NOT_NULL -> pred.isNotNull();
                };
            }

            public YqlPredicate visitListExpr(@NonNull ListExpr<T> listExpr) {
                if (listExpr == null) {
                    throw new NullPointerException("listExpr is marked non-null but is null");
                }
                String fieldPath = listExpr.getFieldPath();
                Schema.JavaField field = listExpr.getField();
                List expected = listExpr.getValues().stream().map(v -> v.getRaw(field)).collect(Collectors.toList());
                return switch (listExpr.getOperator()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ListExpr.Operator.IN -> YqlPredicate.where(fieldPath).in(expected);
                    case ListExpr.Operator.NOT_IN -> YqlPredicate.where(fieldPath).notIn(expected);
                };
            }

            public YqlPredicate visitAndExpr(@NonNull AndExpr<T> andExpr) {
                if (andExpr == null) {
                    throw new NullPointerException("andExpr is marked non-null but is null");
                }
                return YqlPredicate.and(this.visitSubPredicates(YqlListingQuery.normalize(andExpr).stream()));
            }

            public YqlPredicate visitOrExpr(@NonNull OrExpr<T> orExpr) {
                if (orExpr == null) {
                    throw new NullPointerException("orExpr is marked non-null but is null");
                }
                return YqlPredicate.or(this.visitSubPredicates(YqlListingQuery.normalize(orExpr).stream()));
            }

            private Collection<YqlPredicate> visitSubPredicates(Stream<FilterExpression<T>> subfilters) {
                return subfilters.map(expr -> (YqlPredicate)expr.visit((FilterExpression.Visitor)this)).collect(Collectors.toList());
            }

            public YqlPredicate visitNotExpr(@NonNull NotExpr<T> notExpr) {
                if (notExpr == null) {
                    throw new NullPointerException("notExpr is marked non-null but is null");
                }
                return YqlPredicate.not((YqlPredicate)notExpr.getDelegate().visit((FilterExpression.Visitor)this));
            }
        });
    }

    @NonNull
    private static String likePatternForContains(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        StringBuilder sb = new StringBuilder(str.length() + 2);
        sb.append('%');
        if (LIKE_PATTERN_CHARS.matchesNoneOf((CharSequence)str)) {
            sb.append(str);
        } else {
            YqlListingQuery.escapeLikePatternToSb(str, sb);
        }
        sb.append('%');
        return sb.toString();
    }

    @NonNull
    private static String likePatternForStartsWith(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        StringBuilder sb = new StringBuilder(str.length() + 1);
        if (LIKE_PATTERN_CHARS.matchesNoneOf((CharSequence)str)) {
            sb.append(str);
        } else {
            YqlListingQuery.escapeLikePatternToSb(str, sb);
        }
        sb.append('%');
        return sb.toString();
    }

    @NonNull
    private static String likePatternForEndsWith(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        StringBuilder sb = new StringBuilder(str.length() + 1);
        sb.append('%');
        if (LIKE_PATTERN_CHARS.matchesNoneOf((CharSequence)str)) {
            sb.append(str);
        } else {
            YqlListingQuery.escapeLikePatternToSb(str, sb);
        }
        return sb.toString();
    }

    private static void escapeLikePatternToSb(@NonNull String str, StringBuilder sb) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '^' || LIKE_PATTERN_CHARS.matches(ch)) {
                sb.append('^');
            }
            sb.append(ch);
        }
    }

    public static <T extends Entity<T>> YqlOrderBy toYqlOrderBy(@NonNull OrderExpression<T> orderBy) {
        if (orderBy == null) {
            throw new NullPointerException("orderBy is marked non-null but is null");
        }
        return YqlOrderBy.orderBy(orderBy.getKeys().stream().map(YqlListingQuery::toSortKey).collect(Collectors.toList()));
    }

    private static YqlOrderBy.SortKey toSortKey(OrderExpression.SortKey k) {
        return new YqlOrderBy.SortKey(k.getFieldPath(), YqlListingQuery.toSortOrder(k));
    }

    private static YqlOrderBy.SortOrder toSortOrder(OrderExpression.SortKey key) {
        return key.getOrder() == OrderExpression.SortOrder.ASCENDING ? YqlOrderBy.SortOrder.ASC : YqlOrderBy.SortOrder.DESC;
    }

    @VisibleForTesting
    static <T extends Entity<T>, E extends FilterExpression<T>> E normalize(@NonNull E expr) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        return (E)YqlListingQuery.sortSubexpressions(expr);
    }

    private static <T extends Entity<T>> FilterExpression<T> sortSubexpressions(@NonNull FilterExpression<T> expr) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        return (FilterExpression)expr.visit((FilterExpression.Visitor)new FilterExpression.Visitor.Transforming<T>(){

            protected FilterExpression<T> transformLeaf(@NonNull LeafExpression<T> leaf) {
                if (leaf == null) {
                    throw new NullPointerException("leaf is marked non-null but is null");
                }
                return leaf;
            }

            protected List<FilterExpression<T>> transformComposite(@NonNull FilterExpression<T> composite) {
                if (composite == null) {
                    throw new NullPointerException("composite is marked non-null but is null");
                }
                return composite.stream().map(expr -> (FilterExpression)expr.visit((FilterExpression.Visitor)this)).sorted(YqlListingQuery::compareExpressions).collect(Collectors.toList());
            }
        });
    }

    private static <T extends Entity<T>> int compareExpressions(FilterExpression<T> e1, FilterExpression<T> e2) {
        List idFieldNames = EntityIdSchema.ofEntity((Class)e1.getSchema().getType()).flattenFieldNames();
        int idx1 = idFieldNames.indexOf(e1.visit(YqlListingQuery.fieldNameVisitor()));
        int idx2 = idFieldNames.indexOf(e2.visit(YqlListingQuery.fieldNameVisitor()));
        if (idx1 == -1 && idx2 == -1) {
            return 0;
        }
        if (idx1 == -1) {
            return 1;
        }
        if (idx2 == -1) {
            return -1;
        }
        return Integer.compare(idx1, idx2);
    }

    private static <T extends Entity<T>> FilterExpression.Visitor<T, String> fieldNameVisitor() {
        return FIELD_NAME_VISITOR;
    }
}

