/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.yql;

import com.google.common.base.Preconditions;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.DeprecationWarnings;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;

public final class YqlLimit
implements YqlStatementPart<YqlLimit> {
    public static final YqlLimit EMPTY = new YqlLimit(0L, 0L);
    private final long limit;
    private final long offset;

    private YqlLimit(long limit, long offset) {
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be >= 0");
        this.limit = limit;
        this.offset = offset;
    }

    public static YqlLimit range(long from, long to) {
        Preconditions.checkArgument((from >= 0L ? 1 : 0) != 0, (Object)"from must be >= 0");
        Preconditions.checkArgument((to >= 0L ? 1 : 0) != 0, (Object)"to must be >= 0");
        Preconditions.checkArgument((to >= from ? 1 : 0) != 0, (Object)"to must be >= from");
        return to == from ? EMPTY : new YqlLimit(to - from, from);
    }

    public static YqlLimit top(long n) {
        Preconditions.checkArgument((n >= 0L ? 1 : 0) != 0, (Object)"n must be >= 0");
        return n == 0L ? EMPTY : new YqlLimit(n, 0L);
    }

    public static YqlLimit empty() {
        return EMPTY;
    }

    @Deprecated(forRemoval=true)
    public long size() {
        DeprecationWarnings.warnOnce((String)"YqlLimit.size()", (String)"Please calculate range size using YqlLimit.getLimit() and YqlLimit.getOffset() instead of calling YqlLimit.size()", (Object[])new Object[0]);
        return this.limit;
    }

    public boolean isEmpty() {
        return this.limit == 0L;
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public String getType() {
        return "Limit";
    }

    @Override
    public String getYqlPrefix() {
        return "LIMIT ";
    }

    @Override
    public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        return this.limit + (String)(this.offset == 0L ? "" : " OFFSET " + this.offset);
    }

    public String toString() {
        return "limit " + this.limit + (String)(this.offset == 0L ? "" : " offset " + this.offset);
    }

    @Generated
    public long getLimit() {
        return this.limit;
    }

    @Generated
    public long getOffset() {
        return this.offset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YqlLimit)) {
            return false;
        }
        YqlLimit other = (YqlLimit)o;
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        return this.getOffset() == other.getOffset();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $limit = this.getLimit();
        result = result * 59 + (int)($limit >>> 32 ^ $limit);
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        return result;
    }

    @Generated
    public YqlLimit withLimit(long limit) {
        return this.limit == limit ? this : new YqlLimit(limit, this.offset);
    }

    @Generated
    public YqlLimit withOffset(long offset) {
        return this.offset == offset ? this : new YqlLimit(this.limit, offset);
    }
}

