/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.databind.expression.FilterExpression;
import tech.ydb.yoj.databind.expression.OrderExpression;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityExpressions;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Range;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.db.Tx;
import tech.ydb.yoj.repository.db.ViewSchema;
import tech.ydb.yoj.repository.db.bulk.BulkParams;
import tech.ydb.yoj.repository.db.cache.FirstLevelCache;
import tech.ydb.yoj.repository.db.cache.TransactionLocal;
import tech.ydb.yoj.repository.db.readtable.ReadTableParams;
import tech.ydb.yoj.repository.db.statement.Changeset;
import tech.ydb.yoj.repository.ydb.bulk.BulkMapper;
import tech.ydb.yoj.repository.ydb.bulk.BulkMapperImpl;
import tech.ydb.yoj.repository.ydb.readtable.EntityIdKeyMapper;
import tech.ydb.yoj.repository.ydb.readtable.ReadTableMapper;
import tech.ydb.yoj.repository.ydb.statement.Count;
import tech.ydb.yoj.repository.ydb.statement.CountAllStatement;
import tech.ydb.yoj.repository.ydb.statement.DeleteAllStatement;
import tech.ydb.yoj.repository.ydb.statement.DeleteByIdStatement;
import tech.ydb.yoj.repository.ydb.statement.FindAllYqlStatement;
import tech.ydb.yoj.repository.ydb.statement.FindInStatement;
import tech.ydb.yoj.repository.ydb.statement.FindRangeStatement;
import tech.ydb.yoj.repository.ydb.statement.FindStatement;
import tech.ydb.yoj.repository.ydb.statement.FindYqlStatement;
import tech.ydb.yoj.repository.ydb.statement.InsertYqlStatement;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.statement.UpdateByIdStatement;
import tech.ydb.yoj.repository.ydb.statement.UpdateInStatement;
import tech.ydb.yoj.repository.ydb.statement.UpdateModel;
import tech.ydb.yoj.repository.ydb.statement.UpsertYqlStatement;
import tech.ydb.yoj.repository.ydb.table.BatchFindSpliterator;
import tech.ydb.yoj.repository.ydb.yql.YqlLimit;
import tech.ydb.yoj.repository.ydb.yql.YqlListingQuery;
import tech.ydb.yoj.repository.ydb.yql.YqlOrderBy;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicate;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;
import tech.ydb.yoj.repository.ydb.yql.YqlView;

public class YdbTable<T extends Entity<T>>
implements Table<T> {
    private final Class<T> type;
    private final QueryExecutor executor;
    private final EntitySchema<T> schema;
    private final TableDescriptor<T> tableDescriptor;

    public YdbTable(Class<T> type, QueryExecutor executor) {
        this.type = type;
        this.executor = new CheckingQueryExecutor(executor);
        this.schema = EntitySchema.of(type);
        this.tableDescriptor = TableDescriptor.from(this.schema);
    }

    protected YdbTable(QueryExecutor executor) {
        this.type = this.resolveEntityType();
        this.executor = new CheckingQueryExecutor(executor);
        this.schema = EntitySchema.of(this.type);
        this.tableDescriptor = TableDescriptor.from(this.schema);
    }

    public YdbTable(TableDescriptor<T> tableDescriptor, QueryExecutor executor) {
        this.type = tableDescriptor.entityType();
        this.executor = new CheckingQueryExecutor(executor);
        this.schema = EntitySchema.of(this.type);
        this.tableDescriptor = tableDescriptor;
    }

    private Class<T> resolveEntityType() {
        return new TypeToken<T>(this.getClass()){}.getRawType();
    }

    @SafeVarargs
    private static <E> List<E> toList(E first, E ... rest) {
        return Stream.concat(Stream.of(first), Arrays.stream(rest)).collect(Collectors.toList());
    }

    public List<T> findAll() {
        FindAllYqlStatement statement = new FindAllYqlStatement(this.tableDescriptor, this.schema, this.schema);
        return this.postLoad(this.executor.execute(statement, null));
    }

    public Stream<T> streamAll(int batchSize) {
        return this.streamPartial(null, batchSize);
    }

    public <V extends Table.ViewId<T>> Stream<V> streamAll(Class<V> viewType, int batchSize) {
        return this.streamPartial(viewType, null, batchSize);
    }

    public <ID extends Entity.Id<T>> Stream<T> streamPartial(ID partial, int batchSize) {
        return this.streamPartial(partial, batchSize, Entity::getId, this::find);
    }

    public <ID extends Entity.Id<T>, V extends Table.ViewId<T>> Stream<V> streamPartial(Class<V> viewType, ID partial, int batchSize) {
        return this.streamPartial(partial, batchSize, Table.ViewId::getId, (part, parts) -> this.find(viewType, (YqlStatementPart<?>)part, (YqlStatementPart<?>)parts));
    }

    private <R> Stream<R> streamPartial(Entity.Id<T> partial, int batchSize, final Function<R, Entity.Id<T>> idMapper, final BiFunction<YqlStatementPart<?>, YqlStatementPart<?>[], List<R>> findMethod) {
        Preconditions.checkArgument((1 <= batchSize && batchSize <= 5000 ? 1 : 0) != 0, (String)"batchSize must be in range [1, 5000], got %s", (int)batchSize);
        return StreamSupport.stream(new BatchFindSpliterator<R, T, Entity.Id<T>>(this.type, partial, batchSize){

            @Override
            protected Entity.Id<T> getId(R r) {
                return (Entity.Id)idMapper.apply(r);
            }

            @Override
            protected List<R> find(YqlStatementPart<?> part, YqlStatementPart<?> ... otherParts) {
                return (List)findMethod.apply(part, otherParts);
            }
        }, false);
    }

    public <ID extends Entity.Id<T>> Stream<ID> streamAllIds(int batchSize) {
        return this.streamPartialIds(null, batchSize);
    }

    public <ID extends Entity.Id<T>> Stream<ID> streamPartialIds(ID partial, int batchSize) {
        Preconditions.checkArgument((1 <= batchSize && batchSize <= 10000 ? 1 : 0) != 0, (String)"batchSize must be in range [1, 10000], got %s", (int)batchSize);
        return StreamSupport.stream(new BatchFindSpliterator<ID, T, ID>(this.type, partial, batchSize){

            @Override
            protected ID getId(ID id) {
                return id;
            }

            @Override
            protected List<ID> find(YqlStatementPart<?> part, YqlStatementPart<?> ... otherParts) {
                return YdbTable.this.findIds(part, otherParts);
            }
        }, false);
    }

    public <V extends Table.View> List<V> findAll(Class<V> viewType) {
        ViewSchema viewSchema = ViewSchema.of(viewType);
        FindAllYqlStatement statement = new FindAllYqlStatement(this.tableDescriptor, this.schema, viewSchema);
        return this.executor.execute(statement, null);
    }

    public void deleteAll() {
        this.executor.pendingExecute(new DeleteAllStatement(this.tableDescriptor, this.schema), null);
    }

    public void bulkUpsert(List<T> input, BulkParams params) {
        BulkMapperImpl<T> mapper = new BulkMapperImpl<T>(this.tableDescriptor, this.schema);
        this.executor.bulkUpsert(mapper, input, params);
    }

    public <ID extends Entity.Id<T>> Stream<T> readTable(ReadTableParams<ID> params) {
        EntityIdKeyMapper mapper = new EntityIdKeyMapper(this.tableDescriptor, this.schema, this.schema);
        return this.readTableStream(mapper, params).map(Entity::postLoad);
    }

    public <ID extends Entity.Id<T>> Stream<ID> readTableIds(ReadTableParams<ID> params) {
        EntityIdSchema idSchema = this.schema.getIdSchema();
        EntityIdKeyMapper mapper = new EntityIdKeyMapper(this.tableDescriptor, this.schema, idSchema);
        return this.readTableStream(mapper, params);
    }

    public <V extends Table.ViewId<T>, ID extends Entity.Id<T>> Stream<V> readTable(Class<V> viewClass, ReadTableParams<ID> params) {
        ViewSchema viewSchema = ViewSchema.of(viewClass);
        EntityIdKeyMapper mapper = new EntityIdKeyMapper(this.tableDescriptor, this.schema, viewSchema);
        return this.readTableStream(mapper, params);
    }

    private <K, V> Stream<V> readTableStream(ReadTableMapper<K, V> mapper, ReadTableParams<K> params) {
        if (!(params.isOrdered() || params.getFromKey() == null && params.getToKey() == null)) {
            throw new IllegalArgumentException("using fromKey or toKey with unordered readTable does not make sense");
        }
        return this.executor.readTable(mapper, params);
    }

    public T find(Entity.Id<T> id) {
        if (id.isPartial()) {
            throw new IllegalArgumentException("Cannot use partial id in find method");
        }
        return (T)this.executor.getTransactionLocal().firstLevelCache().get(id, __ -> {
            FindYqlStatement statement = new FindYqlStatement(this.tableDescriptor, this.schema, this.schema);
            List res = this.postLoad(this.executor.execute(statement, id));
            return res.isEmpty() ? null : (Entity)res.get(0);
        });
    }

    public <V extends Table.View> V find(Class<V> viewType, Entity.Id<T> id) {
        ViewSchema viewSchema = ViewSchema.of(viewType);
        FindYqlStatement statement = new FindYqlStatement(this.tableDescriptor, this.schema, viewSchema);
        List res = this.executor.execute(statement, id);
        return (V)(res.isEmpty() ? null : (Table.View)res.get(0));
    }

    public <ID extends Entity.Id<T>> List<T> find(Range<ID> range) {
        FindRangeStatement<T, ID, T> statement = new FindRangeStatement<T, ID, T>(this.tableDescriptor, this.schema, this.schema, range);
        return this.postLoad(this.executor.execute(statement, range));
    }

    public <V extends Table.View, ID extends Entity.Id<T>> List<V> find(Class<V> viewType, Range<ID> range) {
        ViewSchema viewSchema = ViewSchema.of(viewType);
        FindRangeStatement statement = new FindRangeStatement(this.tableDescriptor, this.schema, viewSchema, range);
        return this.executor.execute(statement, range);
    }

    public <V extends Table.View, ID extends Entity.Id<T>> List<V> find(Class<V> viewType, Set<ID> ids) {
        return this.find(viewType, ids, null, EntityExpressions.defaultOrder(this.type), null);
    }

    public final List<T> find(YqlStatementPart<?> part, YqlStatementPart<?> ... otherParts) {
        return this.find(YdbTable.toList(part, otherParts));
    }

    public List<T> find(Collection<? extends YqlStatementPart<?>> parts) {
        FindStatement<T, T> statement = FindStatement.from(this.tableDescriptor, this.schema, this.schema, parts, false);
        return this.postLoad(this.executor.execute(statement, parts));
    }

    public long countAll() {
        return this.count(new YqlStatementPart[0]);
    }

    public long count(String indexName, FilterExpression<T> filter) {
        YqlPredicate yqlFilter = filter == null ? null : YqlListingQuery.toYqlPredicate(filter);
        YqlView yqlView = indexName == null ? null : YqlView.index(indexName);
        YqlStatementPart[] statementParts = (YqlStatementPart[])Stream.of(yqlView, yqlFilter).filter(Objects::nonNull).toArray(YqlStatementPart[]::new);
        return this.count(statementParts);
    }

    public List<T> find(@Nullable String indexName, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit, @Nullable Long offset) {
        List<YqlStatementPart<YqlStatementPart<?>>> statements = YdbTable.buildStatementParts(indexName, filter, orderBy, limit, offset);
        return this.find(statements);
    }

    public <ID extends Entity.Id<T>> List<ID> findIds(@Nullable String indexName, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit, @Nullable Long offset) {
        List<YqlStatementPart<YqlStatementPart<?>>> statements = YdbTable.buildStatementParts(indexName, filter, orderBy, limit, offset);
        return this.findIds(statements);
    }

    public <V extends Table.View> List<V> find(Class<V> viewType, @Nullable String indexName, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit, @Nullable Long offset, boolean distinct) {
        List<YqlStatementPart<YqlStatementPart<?>>> statements = YdbTable.buildStatementParts(indexName, filter, orderBy, limit, offset);
        return this.find(viewType, statements, distinct);
    }

    public <ID extends Entity.Id<T>> List<T> find(Set<ID> ids, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        if (ids.isEmpty()) {
            return List.of();
        }
        boolean isPartialIdMode = ((Entity.Id)ids.iterator().next()).isPartial();
        List<T> found = this.postLoad(this.findUncached(ids, filter, orderBy, limit));
        if (!isPartialIdMode && ids.size() > found.size()) {
            Set foundIds = found.stream().map(Entity::getId).collect(Collectors.toSet());
            Sets.difference(ids, foundIds).forEach(arg_0 -> ((FirstLevelCache)this.executor.getTransactionLocal().firstLevelCache()).putEmpty(arg_0));
        }
        return found;
    }

    public <ID extends Entity.Id<T>> List<T> findUncached(Set<ID> ids, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        if (ids.isEmpty()) {
            return List.of();
        }
        FindInStatement<Set<ID>, T, T> statement = FindInStatement.from(this.tableDescriptor, this.schema, this.schema, ids, filter, orderBy, limit);
        return this.executor.execute(statement, ids);
    }

    public <V extends Table.View, ID extends Entity.Id<T>> List<V> find(Class<V> viewType, Set<ID> ids, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        if (ids.isEmpty()) {
            return List.of();
        }
        ViewSchema viewSchema = ViewSchema.of(viewType);
        FindInStatement statement = FindInStatement.from(this.tableDescriptor, this.schema, viewSchema, ids, filter, orderBy, limit);
        return this.executor.execute(statement, ids);
    }

    public <K> List<T> find(String indexName, Set<K> keys, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        if (keys.isEmpty()) {
            return List.of();
        }
        FindInStatement<Set<K>, T, T> statement = FindInStatement.from(this.tableDescriptor, this.schema, this.schema, indexName, keys, filter, orderBy, limit);
        return this.postLoad(this.executor.execute(statement, keys));
    }

    public <V extends Table.View, K> List<V> find(Class<V> viewType, String indexName, Set<K> keys, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        if (keys.isEmpty()) {
            return List.of();
        }
        ViewSchema viewSchema = ViewSchema.of(viewType);
        FindInStatement statement = FindInStatement.from(this.tableDescriptor, this.schema, viewSchema, indexName, keys, filter, orderBy, limit);
        return this.executor.execute(statement, keys);
    }

    public static <T extends Entity<T>> List<YqlStatementPart<? extends YqlStatementPart<?>>> buildStatementParts(@Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit, @Nullable Long offset) {
        return YdbTable.buildStatementParts(null, filter, orderBy, limit, offset);
    }

    public static <T extends Entity<T>> List<YqlStatementPart<? extends YqlStatementPart<?>>> buildStatementParts(@Nullable String indexName, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit, @Nullable Long offset) {
        Optional<Integer> limitO = Optional.ofNullable(limit);
        Optional<Long> offsetO = Optional.ofNullable(offset);
        YqlPredicate yqlFilter = filter == null ? null : YqlListingQuery.toYqlPredicate(filter);
        YqlOrderBy yqlOrderBy = orderBy == null ? null : YqlListingQuery.toYqlOrderBy(orderBy);
        YqlLimit yqlLimit = null;
        if (offsetO.orElse(0L) != 0L || limit != null) {
            yqlLimit = YqlLimit.range(offsetO.orElse(0L), offsetO.orElse(0L) + (long)limitO.orElseThrow(() -> new IllegalArgumentException("offset > 0 with limit=null is not supported")).intValue());
        }
        YqlView yqlView = indexName == null ? null : YqlView.index(indexName);
        return Stream.of(yqlFilter, yqlView, yqlOrderBy, yqlLimit).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public long count(YqlStatementPart<?> ... parts) {
        List<YqlStatementPart<?>> partsList = Arrays.asList(parts);
        CountAllStatement<T> statement = new CountAllStatement<T>(this.tableDescriptor, this.schema, partsList);
        return ((Count)this.executor.execute(statement, partsList).get(0)).getCount();
    }

    public <V extends Table.View> List<V> find(Class<V> viewType, YqlStatementPart<?> part, YqlStatementPart<?> ... otherParts) {
        return this.find(viewType, YdbTable.toList(part, otherParts), false);
    }

    public <V extends Table.View> List<V> find(Class<V> viewType, Collection<? extends YqlStatementPart<?>> parts, boolean distinct) {
        ViewSchema viewSchema = ViewSchema.of(viewType);
        FindStatement statement = FindStatement.from(this.tableDescriptor, this.schema, viewSchema, parts, distinct);
        return this.executor.execute(statement, parts);
    }

    public <ID extends Entity.Id<T>> List<ID> findIds(YqlStatementPart<?> part, YqlStatementPart<?> ... otherParts) {
        return this.findIds(YdbTable.toList(part, otherParts));
    }

    private <ID extends Entity.Id<T>> List<ID> findIds(Collection<? extends YqlStatementPart<?>> parts) {
        EntityIdSchema idSchema = EntityIdSchema.ofEntity(this.type);
        FindStatement statement = FindStatement.from(this.tableDescriptor, this.schema, idSchema, parts, false);
        return this.executor.execute(statement, parts);
    }

    public <ID extends Entity.Id<T>> List<ID> findIds(Range<ID> range) {
        EntityIdSchema idSchema = EntityIdSchema.ofEntity(this.type);
        FindRangeStatement statement = new FindRangeStatement(this.tableDescriptor, this.schema, idSchema, range);
        return this.executor.execute(statement, range);
    }

    public <ID extends Entity.Id<T>> List<ID> findIds(Set<ID> partialIds) {
        if (partialIds.isEmpty()) {
            return List.of();
        }
        OrderExpression order = EntityExpressions.defaultOrder(this.type);
        EntityIdSchema idSchema = EntityIdSchema.ofEntity(this.type);
        FindInStatement statement = FindInStatement.from(this.tableDescriptor, this.schema, idSchema, partialIds, null, order, null);
        return this.executor.execute(statement, partialIds);
    }

    public void update(Entity.Id<T> id, Changeset changeset) {
        UpdateModel.ById<Entity.Id<T>> model = new UpdateModel.ById<Entity.Id<T>>(id, changeset.toMap());
        this.executor.pendingExecute(new UpdateByIdStatement<T, Entity.Id<T>>(this.tableDescriptor, this.schema, model), model);
    }

    public T insert(T t) {
        Entity entityToSave = t.preSave();
        this.executor.pendingExecute(new InsertYqlStatement(this.tableDescriptor, this.schema), entityToSave);
        this.executor.getTransactionLocal().firstLevelCache().put(entityToSave);
        this.executor.getTransactionLocal().projectionCache().save(entityToSave);
        return t;
    }

    public T save(T t) {
        Entity entityToSave = t.preSave();
        this.executor.pendingExecute(new UpsertYqlStatement(this.tableDescriptor, this.schema), entityToSave);
        this.executor.getTransactionLocal().firstLevelCache().put(entityToSave);
        this.executor.getTransactionLocal().projectionCache().save(entityToSave);
        return t;
    }

    public void delete(Entity.Id<T> id) {
        this.executor.pendingExecute(new DeleteByIdStatement(this.tableDescriptor, this.schema), id);
        this.executor.getTransactionLocal().firstLevelCache().putEmpty(id);
        this.executor.getTransactionLocal().projectionCache().delete(id);
    }

    public <ID extends Entity.Id<T>> void migrate(ID id) {
        FindYqlStatement statement = new FindYqlStatement(this.tableDescriptor, this.schema, this.schema);
        List foundRaw = this.executor.execute(statement, id);
        if (foundRaw.isEmpty()) {
            return;
        }
        Entity rawEntity = (Entity)foundRaw.get(0);
        Entity entityToSave = rawEntity.postLoad().preSave();
        this.executor.pendingExecute(new UpsertYqlStatement(this.tableDescriptor, this.schema), entityToSave);
        this.executor.getTransactionLocal().projectionCache().save(entityToSave);
    }

    public FirstLevelCache getFirstLevelCache() {
        return this.executor.getTransactionLocal().firstLevelCache();
    }

    @NonNull
    public T postLoad(T e) {
        Entity e1 = e.postLoad();
        if (e1 != e) {
            this.executor.getTransactionLocal().log().debug("    postLoad(%s) has diff", new Object[]{e1.getId()});
        }
        this.executor.getTransactionLocal().firstLevelCache().put(e1);
        this.executor.getTransactionLocal().projectionCache().load(e1);
        return (T)e1;
    }

    public <ID extends Entity.Id<T>> void updateIn(Collection<ID> ids, Changeset changeset) {
        UpdateInStatement.UpdateInStatementInput params = new UpdateInStatement.UpdateInStatementInput(ids, changeset.toMap());
        this.executor.pendingExecute(new UpdateInStatement<T, T>(this.tableDescriptor, this.schema, this.schema, params), params);
    }

    @Generated
    public Class<T> getType() {
        return this.type;
    }

    public static class CheckingQueryExecutor
    implements QueryExecutor {
        private final QueryExecutor delegate;
        private final Tx originTx;

        public CheckingQueryExecutor(QueryExecutor delegate) {
            this.delegate = delegate;
            this.originTx = Tx.Current.exists() ? Tx.Current.get() : null;
        }

        private void check() {
            Tx.checkSameTx((Tx)this.originTx);
        }

        @Override
        public <PARAMS, RESULT> List<RESULT> execute(Statement<PARAMS, RESULT> statement, PARAMS params) {
            this.check();
            return this.delegate.execute(statement, params);
        }

        @Override
        public <PARAMS, RESULT> Stream<RESULT> executeScanQuery(Statement<PARAMS, RESULT> statement, PARAMS params) {
            return this.delegate.executeScanQuery(statement, params);
        }

        @Override
        public <PARAMS> void pendingExecute(Statement<PARAMS, ?> statement, PARAMS value) {
            this.check();
            this.delegate.pendingExecute(statement, value);
        }

        @Override
        public <IN> void bulkUpsert(BulkMapper<IN> mapper, List<IN> input, BulkParams params) {
            this.check();
            this.delegate.bulkUpsert(mapper, input, params);
        }

        @Override
        public <IN, OUT> Stream<OUT> readTable(ReadTableMapper<IN, OUT> mapper, ReadTableParams<IN> params) {
            this.check();
            return this.delegate.readTable(mapper, params);
        }

        @Override
        public TransactionLocal getTransactionLocal() {
            this.check();
            return this.delegate.getTransactionLocal();
        }
    }

    public static interface QueryExecutor {
        public <PARAMS, RESULT> List<RESULT> execute(Statement<PARAMS, RESULT> var1, PARAMS var2);

        public <PARAMS, RESULT> Stream<RESULT> executeScanQuery(Statement<PARAMS, RESULT> var1, PARAMS var2);

        public <PARAMS> void pendingExecute(Statement<PARAMS, ?> var1, PARAMS var2);

        default public <IN> void bulkUpsert(BulkMapper<IN> mapper, List<IN> input, BulkParams params) {
            throw new UnsupportedOperationException();
        }

        public <IN, OUT> Stream<OUT> readTable(ReadTableMapper<IN, OUT> var1, ReadTableParams<IN> var2);

        public TransactionLocal getTransactionLocal();
    }
}

