/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import com.google.common.base.Preconditions;
import com.google.protobuf.NullValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import tech.ydb.proto.ValueProtos;
import tech.ydb.yoj.DeprecationWarnings;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.db.cache.RepositoryCache;
import tech.ydb.yoj.repository.ydb.statement.ResultSetReader;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatementParam;
import tech.ydb.yoj.repository.ydb.yql.YqlOrderBy;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public abstract class YqlStatement<PARAMS, ENTITY extends Entity<ENTITY>, RESULT>
implements Statement<PARAMS, RESULT> {
    protected static final Collector<ValueProtos.Value.Builder, ValueProtos.Value.Builder, ValueProtos.Value.Builder> itemsCollector = Collector.of(ValueProtos.Value::newBuilder, ValueProtos.Value.Builder::addItems, (b, b2) -> b.addAllItems((Iterable)b2.getItemsList()), new Collector.Characteristics[0]);
    protected static final YqlOrderBy ORDER_BY_ID_ASCENDING = YqlOrderBy.orderBy("id", new String[0]);
    protected final EntitySchema<ENTITY> schema;
    protected final Schema<RESULT> resultSchema;
    protected final ResultSetReader<RESULT> resultSetReader;
    protected final TableDescriptor<ENTITY> tableDescriptor;

    @Deprecated(forRemoval=true)
    public YqlStatement(EntitySchema<ENTITY> schema, Schema<RESULT> resultSchema) {
        this(TableDescriptor.from(schema), schema, resultSchema);
    }

    public YqlStatement(TableDescriptor<ENTITY> tableDescriptor, EntitySchema<ENTITY> schema, Schema<RESULT> resultSchema) {
        this.schema = schema;
        this.resultSchema = resultSchema;
        this.resultSetReader = new ResultSetReader<RESULT>(resultSchema);
        this.tableDescriptor = tableDescriptor;
    }

    @Override
    public void storeToCache(PARAMS params, List<RESULT> result, RepositoryCache cache) {
        if (result == null) {
            return;
        }
        for (RESULT o : result) {
            if (!(o instanceof Entity)) break;
            Entity e = (Entity)o;
            cache.put(new RepositoryCache.Key(e.getClass(), (Object)e.getId()), (Object)e);
        }
    }

    public String getDeclaration(String name, String type) {
        return String.format("DECLARE %s AS %s;\n", name, type);
    }

    @Deprecated(forRemoval=true)
    protected static Stream<? extends YqlStatementPart<?>> mergeParts(Stream<? extends YqlStatementPart<?>> origParts) {
        DeprecationWarnings.warnOnce((String)"YqlStatement.mergeParts(Stream)", (String)"YqlStatement.mergeParts(Stream) is deprecated and will be removed in YOJ 3.0.0. Use YqlStatement.mergeParts(Collection) instead", (Object[])new Object[0]);
        return origParts.collect(Collectors.groupingBy(YqlStatementPart::getType)).values().stream().flatMap(items -> YqlStatement.combine(items).stream());
    }

    protected static Stream<? extends YqlStatementPart<?>> mergeParts(Collection<? extends YqlStatementPart<?>> origParts) {
        return origParts.stream().collect(Collectors.groupingBy(YqlStatementPart::getType)).values().stream().flatMap(items -> YqlStatement.combine(items).stream());
    }

    private static List<? extends YqlStatementPart<?>> combine(List<? extends YqlStatementPart<?>> items) {
        if (items.size() < 2) {
            return items;
        }
        YqlStatementPart<?> first = items.iterator().next();
        return first.combine(items.subList(1, items.size()));
    }

    @Override
    public boolean isPreparable() {
        return true;
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toQueryParameters(PARAMS params) {
        Map values = params.getClass().isAssignableFrom(this.schema.getType()) ? this.schema.flatten((Object)((Entity)params)) : this.schema.flattenId((Entity.Id)params);
        return this.getParams().stream().filter(p -> values.containsKey(p.getName())).collect(Collectors.toMap(YqlStatementParam::getVar, p -> this.createTQueryParameter(p.getType(), values.get(p.getName()), p.isOptional())));
    }

    protected ValueProtos.TypedValue createTQueryParameter(YqlType type, Object o, boolean optional) {
        return ValueProtos.TypedValue.newBuilder().setType(this.getYqlType(type, optional)).setValue(this.getYqlValue(type, o)).build();
    }

    protected ValueProtos.Type.Builder getYqlType(YqlType yqlType, boolean optional) {
        ValueProtos.Type.Builder ttype = yqlType.getYqlTypeBuilder();
        return !optional ? ttype : ValueProtos.Type.newBuilder().setOptionalType(ValueProtos.OptionalType.newBuilder().setItem(ttype));
    }

    protected ValueProtos.Value.Builder getYqlValue(YqlType type, Object value) {
        return value == null ? ValueProtos.Value.newBuilder().setNullFlagValue(NullValue.NULL_VALUE) : type.toYql(value);
    }

    @Override
    public RESULT readResult(List<ValueProtos.Column> columns, ValueProtos.Value value) {
        return this.resultSetReader.readResult(columns, value);
    }

    public String toString() {
        return this.getQuery("");
    }

    public boolean equals(Object o) {
        return o == this || o instanceof YqlStatement && ((YqlStatement)o).getQuery("").equals(this.getQuery(""));
    }

    public int hashCode() {
        return this.getQuery("").hashCode();
    }

    public Class<ENTITY> getInSchemaType() {
        return this.schema.getType();
    }

    protected Collection<YqlStatementParam> getParams() {
        return Collections.emptyList();
    }

    protected String declarations() {
        return this.getParams().stream().map(p -> this.getDeclaration(p.getVar(), p.getType().getYqlTypeName() + (p.isOptional() ? "?" : ""))).collect(Collectors.joining());
    }

    protected String outNames() {
        return this.resultSchema.flattenFields().stream().map(Schema.JavaField::getName).map(this::escape).collect(Collectors.joining(", "));
    }

    protected String nameEqVars() {
        return this.getParams().stream().map(p -> this.escape(p.getName()) + " = " + p.getVar()).collect(Collectors.joining(" AND "));
    }

    protected String table(String tablespace) {
        return this.escape(tablespace + this.tableDescriptor.tableName());
    }

    protected String escape(String value) {
        return "`" + value + "`";
    }

    protected String resolveParamNames(String yql) {
        StringBuilder newYql = new StringBuilder();
        Spliterator<YqlStatementParam> paramSpliter = this.getParams().spliterator();
        int paramCount = 0;
        boolean inFieldPlaceholder = false;
        StringBuilder fieldPlaceholder = new StringBuilder();
        block10: for (int i = 0; i < yql.length(); ++i) {
            char ch = yql.charAt(i);
            if (inFieldPlaceholder) {
                switch (ch) {
                    case '{': {
                        throw new IllegalStateException("Nested field placeholders are prohibited");
                    }
                    case '}': {
                        String fieldPath = fieldPlaceholder.toString();
                        Schema.JavaField field = this.schema.getField(fieldPath);
                        Preconditions.checkState((boolean)field.isSimple(), (String)"%s: only simple fields can be referenced using {field.subfield} syntax", (Object)fieldPath);
                        newYql.append(field.getName());
                        fieldPlaceholder.setLength(0);
                        inFieldPlaceholder = false;
                        break;
                    }
                    case '?': {
                        throw new IllegalStateException("Parameter substitution inside field placeholders is prohibited");
                    }
                    default: {
                        fieldPlaceholder.append(ch);
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '{': {
                    inFieldPlaceholder = true;
                    continue block10;
                }
                case '}': {
                    throw new IllegalStateException("Dangling closing curly brace } at <yql>:" + (i + 1));
                }
                case '?': {
                    ++paramCount;
                    if (paramSpliter.tryAdvance(param -> newYql.append(param.getVar()))) continue block10;
                    throw new IllegalStateException(String.format("Parameter list is too small: expected at least %d parameters, but got: %d", paramCount, paramCount - 1));
                }
                default: {
                    newYql.append(ch);
                }
            }
        }
        return newYql.toString();
    }

    @Generated
    public TableDescriptor<ENTITY> getTableDescriptor() {
        return this.tableDescriptor;
    }
}

