/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.statement.Changeset;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicate;

public abstract class UpdateModel {
    private final Map<String, ?> newValues;

    private UpdateModel(@NonNull Map<String, ?> newValues) {
        if (newValues == null) {
            throw new NullPointerException("newValues is marked non-null but is null");
        }
        Preconditions.checkState((!newValues.isEmpty() ? 1 : 0) != 0, (Object)"update must contain a change to at least one entity field");
        this.newValues = newValues;
    }

    public static <T> Changeset set(String fieldPath, T value) {
        return new Changeset().set(fieldPath, value);
    }

    public static Changeset setAll(Map<String, ?> changes) {
        return new Changeset().setAll(changes);
    }

    public static Changeset setAll(Changeset changeset) {
        return new Changeset().setAll(changeset);
    }

    public boolean isEmpty() {
        return this.newValues.isEmpty();
    }

    @Nullable
    public Object getFieldValue(@NonNull String fieldPath) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        return this.newValues.get(fieldPath);
    }

    @Generated
    public Map<String, ?> getNewValues() {
        return this.newValues;
    }

    @Generated
    public String toString() {
        return "UpdateModel(newValues=" + String.valueOf(this.getNewValues()) + ")";
    }

    public static final class ById<ID extends Entity.Id<?>>
    extends UpdateModel {
        private final ID id;

        public ById(@NonNull ID id, @NonNull Map<String, ?> newValues) {
            super(newValues);
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (newValues == null) {
                throw new NullPointerException("newValues is marked non-null but is null");
            }
            this.id = id;
        }

        @Generated
        public ID getId() {
            return this.id;
        }
    }

    public static final class ByPredicate
    extends UpdateModel {
        private final YqlPredicate predicate;

        ByPredicate(@NonNull YqlPredicate predicate, @NonNull Map<String, ?> newValues) {
            super(newValues);
            if (predicate == null) {
                throw new NullPointerException("predicate is marked non-null but is null");
            }
            if (newValues == null) {
                throw new NullPointerException("newValues is marked non-null but is null");
            }
            this.predicate = predicate;
        }

        @Generated
        public YqlPredicate getPredicate() {
            return this.predicate;
        }
    }
}

