/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import tech.ydb.proto.ValueProtos;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatementParam;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public class UpdateInStatement<T extends Entity<T>, RESULT>
extends YqlStatement<UpdateInStatementInput<T>, T, RESULT> {
    public static final String keysParam = "$input_ids";
    private final Map<Schema.JavaField, Object> values;
    private final Set<String> keyFields;

    public UpdateInStatement(TableDescriptor<T> tableDescriptor, EntitySchema<T> schema, Schema<RESULT> resultSchema, UpdateInStatementInput<T> in) {
        super(tableDescriptor, schema, resultSchema);
        this.keyFields = this.collectKeyFields(in.ids);
        this.values = new HashMap<Schema.JavaField, Object>(in.values.size());
        for (Map.Entry<String, ?> entry : in.values.entrySet()) {
            this.values.put(schema.getField(entry.getKey()), entry.getValue());
        }
    }

    private Set<String> collectKeyFields(Collection<? extends Entity.Id<T>> ids) {
        Preconditions.checkNotNull(ids, (Object)"ids should be non null");
        Preconditions.checkArgument((!Iterables.isEmpty(ids) ? 1 : 0) != 0, (Object)"ids should be non empty");
        Set nonNullFieldsSet = ids.stream().map(this::nonNullFieldNames).collect(Collectors.toUnmodifiableSet());
        Preconditions.checkArgument((nonNullFieldsSet.size() != 0 ? 1 : 0) != 0, (Object)"ids should have at least one non-null field");
        Preconditions.checkArgument((nonNullFieldsSet.size() == 1 ? 1 : 0) != 0, (Object)"ids should have nulls in the same fields");
        return (Set)Iterables.getOnlyElement(nonNullFieldsSet);
    }

    @Override
    protected String declarations() {
        String valuesDeclaration = this.values.keySet().stream().map(e -> this.getDeclaration("$" + e.getPath(), YqlType.of(e).getYqlTypeName())).collect(Collectors.joining());
        String keysDeclaration = this.getKeyParams().stream().map(p -> String.format("%s%s", p.getType().getYqlTypeName(), p.isOptional() ? "?" : "")).collect(Collectors.joining(",", "DECLARE $input_ids AS List<Tuple<", ">>;\n"));
        return keysDeclaration + valuesDeclaration;
    }

    @Override
    public Statement.QueryType getQueryType() {
        return Statement.QueryType.UPDATE;
    }

    @Override
    public String getQuery(String tablespace) {
        List<YqlStatementParam> keyParams = this.getKeyParams();
        String keys = keyParams.stream().map(p -> this.escape(p.getName())).collect(Collectors.joining(",", "", keyParams.size() == 1 ? "," : ""));
        String setSection = this.values.keySet().stream().map(x -> x.getName() + "=$" + x.getPath()).collect(Collectors.joining(", "));
        return String.format("%sUPDATE%s\nSET %s\nWHERE (%s) IN %s", this.declarations(), this.table(tablespace), setSection, keys, keysParam);
    }

    public List<YqlStatementParam> getParams() {
        List<YqlStatementParam> params = this.getValuesParams();
        params.addAll(this.getKeyParams());
        return params;
    }

    private List<YqlStatementParam> getValuesParams() {
        return this.values.keySet().stream().map(x -> new YqlStatementParam(YqlType.of(x), x.getPath(), false)).collect(Collectors.toList());
    }

    private List<YqlStatementParam> getKeyParams() {
        return this.schema.flattenId().stream().filter(c -> this.keyFields.contains(c.getName())).map(c -> YqlStatementParam.required(YqlType.of(c), c.getName())).collect(Collectors.toList());
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toQueryParameters(UpdateInStatementInput<T> params) {
        ValueProtos.TypedValue idsParam = this.getIdsQueryParameters(params);
        Map<String, ValueProtos.TypedValue> valuesParams = this.getValuesParams().stream().collect(Collectors.toMap(YqlStatementParam::getVar, p -> this.createTQueryParameter(p.getType(), params.values.get(p.getName()), p.isOptional())));
        valuesParams.put(keysParam, idsParam);
        return valuesParams;
    }

    private ValueProtos.TypedValue getIdsQueryParameters(UpdateInStatementInput<T> params) {
        List<YqlStatementParam> keyParams = this.getKeyParams();
        ValueProtos.TupleType.Builder tupleBuilder = ValueProtos.TupleType.newBuilder();
        keyParams.forEach(param -> tupleBuilder.addElements(this.getYqlType(param.getType(), param.isOptional())));
        ValueProtos.Value.Builder ids = (ValueProtos.Value.Builder)params.ids.stream().map(arg_0 -> ((EntitySchema)this.schema).flattenId(arg_0)).map(fieldValues -> (ValueProtos.Value.Builder)keyParams.stream().map(p -> this.getYqlValue(p.getType(), fieldValues.get(p.getName()))).collect(itemsCollector)).collect(itemsCollector);
        ValueProtos.ListType tupleListType = ValueProtos.ListType.newBuilder().setItem(ValueProtos.Type.newBuilder().setTupleType(tupleBuilder.build())).build();
        return ValueProtos.TypedValue.newBuilder().setType(ValueProtos.Type.newBuilder().setListType(tupleListType).build()).setValue(ids).build();
    }

    @Override
    protected String outNames() {
        return this.resultSchema.flattenFields().stream().map(this::getEscapedName).collect(Collectors.joining(", "));
    }

    private String getEscapedName(Schema.JavaField field) {
        return this.escape(field.getName());
    }

    @Override
    public String toDebugString(UpdateInStatementInput<T> in) {
        return String.format("updateIn(%s)", in);
    }

    private Set<String> nonNullFieldNames(Entity.Id<T> id) {
        return this.schema.flattenId(id).keySet();
    }

    public static final class UpdateInStatementInput<T extends Entity<T>> {
        private final Collection<? extends Entity.Id<T>> ids;
        private final Map<String, ?> values;

        @ConstructorProperties(value={"ids", "values"})
        @Generated
        public UpdateInStatementInput(Collection<? extends Entity.Id<T>> ids, Map<String, ?> values) {
            this.ids = ids;
            this.values = values;
        }

        @Generated
        public Collection<? extends Entity.Id<T>> getIds() {
            return this.ids;
        }

        @Generated
        public Map<String, ?> getValues() {
            return this.values;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateInStatementInput)) {
                return false;
            }
            UpdateInStatementInput other = (UpdateInStatementInput)o;
            Collection<Entity.Id<T>> this$ids = this.getIds();
            Collection<Entity.Id<T>> other$ids = other.getIds();
            if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
                return false;
            }
            Map<String, ?> this$values = this.getValues();
            Map<String, ?> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<Entity.Id<T>> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            Map<String, ?> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UpdateInStatement.UpdateInStatementInput(ids=" + String.valueOf(this.getIds()) + ", values=" + String.valueOf(this.getValues()) + ")";
        }
    }
}

