/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.ydb.proto.ValueProtos;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.statement.UpdateModel;
import tech.ydb.yoj.repository.ydb.statement.UpdateSetParam;
import tech.ydb.yoj.repository.ydb.statement.YqlStatement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatementParam;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public final class UpdateByIdStatement<ENTITY extends Entity<ENTITY>, ID extends Entity.Id<ENTITY>>
extends YqlStatement<UpdateModel.ById<ID>, ENTITY, ENTITY> {
    private final Map<String, UpdateSetParam> setParams;
    private final Set<YqlStatementParam> idParams;

    public UpdateByIdStatement(TableDescriptor<ENTITY> tableDescriptor, EntitySchema<ENTITY> schema, UpdateModel.ById<ID> model) {
        super(tableDescriptor, schema, schema);
        this.idParams = schema.flattenId().stream().map(c -> YqlStatementParam.required(YqlType.of(c), c.getName())).collect(Collectors.toUnmodifiableSet());
        this.setParams = UpdateSetParam.setParamsFromModel(schema, model).collect(Collectors.toMap(YqlStatementParam::getName, p -> p));
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toQueryParameters(UpdateModel.ById<ID> parameters) {
        LinkedHashMap queryParams = new LinkedHashMap();
        Map idValues = this.schema.flattenId(parameters.getId());
        this.idParams().filter(p -> idValues.containsKey(p.getName())).forEach(p -> queryParams.put(p.getVar(), this.createTQueryParameter(p.getType(), idValues.get(p.getName()), p.isOptional())));
        this.setParams.forEach((name, param) -> queryParams.put(param.getVar(), this.createTQueryParameter(param.getType(), param.getFieldValue(parameters), param.isOptional())));
        return Collections.unmodifiableMap(queryParams);
    }

    @Override
    public Statement.QueryType getQueryType() {
        return Statement.QueryType.UPDATE;
    }

    @Override
    public String toDebugString(UpdateModel.ById<ID> idById) {
        return "updateById(" + String.valueOf(idById.getId()) + ")";
    }

    @Override
    protected Collection<YqlStatementParam> getParams() {
        return Stream.concat(this.idParams(), this.setParams()).collect(Collectors.toList());
    }

    @Override
    public String getQuery(String tablespace) {
        return this.declarations() + "UPDATE " + this.table(tablespace) + " " + this.on() + " " + this.values();
    }

    private String on() {
        return "ON (" + Stream.concat(this.idParams().map(YqlStatementParam::getName), this.setParams().map(UpdateSetParam::getFieldName)).collect(Collectors.joining(", ")) + ")";
    }

    private Stream<UpdateSetParam> setParams() {
        return this.setParams.values().stream();
    }

    private Stream<YqlStatementParam> idParams() {
        return this.idParams.stream();
    }

    private String values() {
        return "VALUES (" + Stream.concat(this.idParams(), this.setParams()).map(YqlStatementParam::getVar).collect(Collectors.joining(", ")) + ")";
    }
}

