/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import tech.ydb.proto.ValueProtos;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.ydb.statement.YqlStatement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatementParam;
import tech.ydb.yoj.repository.ydb.yql.YqlCompositeType;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicate;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicateParam;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public abstract class PredicateStatement<PARAMS, ENTITY extends Entity<ENTITY>, RESULT>
extends YqlStatement<PARAMS, ENTITY, RESULT> {
    private final Function<PARAMS, YqlPredicate> getPredicate;
    private final Map<String, PredParam> predParams;

    @Deprecated(forRemoval=true)
    public PredicateStatement(@NonNull EntitySchema<ENTITY> schema, @NonNull Schema<RESULT> outSchema, @NonNull PARAMS params, @NonNull Function<PARAMS, YqlPredicate> getPredicate) {
        this(TableDescriptor.from(schema), schema, outSchema, params, getPredicate);
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (outSchema == null) {
            throw new NullPointerException("outSchema is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (getPredicate == null) {
            throw new NullPointerException("getPredicate is marked non-null but is null");
        }
    }

    public PredicateStatement(@NonNull TableDescriptor<ENTITY> tableDescriptor, @NonNull EntitySchema<ENTITY> schema, @NonNull Schema<RESULT> outSchema, @NonNull PARAMS params, @NonNull Function<PARAMS, YqlPredicate> getPredicate) {
        super(tableDescriptor, schema, outSchema);
        if (tableDescriptor == null) {
            throw new NullPointerException("tableDescriptor is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (outSchema == null) {
            throw new NullPointerException("outSchema is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (getPredicate == null) {
            throw new NullPointerException("getPredicate is marked non-null but is null");
        }
        this.getPredicate = getPredicate;
        YqlPredicate pred = getPredicate.apply(params);
        ImmutableMap.Builder bldr = ImmutableMap.builder();
        int index = 0;
        for (YqlPredicateParam<?> p : pred.paramList()) {
            Schema.JavaField rootField = schema.getField(p.getFieldPath());
            int fIndex = index++;
            if (p.getComplexField() == ComplexField.FLATTEN || p.getComplexField() == ComplexField.TUPLE && rootField.isFlat()) {
                rootField.flatten().map(jf -> new PredParam(this.wrapCollectionType(YqlType.of(jf), p.getCollectionKind()), jf.getName(), fIndex, p.isOptional(), false, rootField)).forEach(pp -> bldr.put((Object)pp.getName(), pp));
                continue;
            }
            if (p.getComplexField() == ComplexField.TUPLE) {
                PredParam param = new PredParam(this.wrapCollectionType(YqlCompositeType.tuple(rootField), p.getCollectionKind()), rootField.getName(), fIndex, p.isOptional(), true, rootField);
                bldr.put((Object)param.getName(), (Object)param);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported complex field kind: " + String.valueOf((Object)p.getComplexField()));
        }
        this.predParams = bldr.build();
    }

    private YqlType wrapCollectionType(YqlType itemType, CollectionKind collectionKind) {
        return switch (collectionKind) {
            default -> throw new IncompatibleClassChangeError();
            case CollectionKind.DICT_SET -> YqlCompositeType.dictSet(itemType);
            case CollectionKind.LIST -> YqlCompositeType.list(itemType);
            case CollectionKind.SINGLE -> itemType;
        };
    }

    @Override
    protected Collection<YqlStatementParam> getParams() {
        return new ArrayList<YqlStatementParam>(this.getYqlStatementParams());
    }

    private YqlPredicate getPredicate(PARAMS params) {
        return this.getPredicate.apply(params);
    }

    @Override
    protected String declarations() {
        return this.getYqlStatementParams().stream().map(p -> this.getDeclaration(p.getVar(), p.getYqlTypeName())).collect(Collectors.joining());
    }

    private Collection<? extends Param> getYqlStatementParams() {
        return this.predParams.values();
    }

    @Override
    protected ValueProtos.TypedValue createTQueryParameter(YqlType yqlType, Object o, boolean optional) {
        return ValueProtos.TypedValue.newBuilder().setType(this.getYqlTypeForValue(yqlType, o, optional)).setValue(this.getYqlValue(yqlType, o)).build();
    }

    private ValueProtos.Type.Builder getYqlTypeForValue(YqlType type, Object o, boolean optional) {
        ValueProtos.Type.Builder yqlType = this.getYqlType(type, optional);
        if (optional) {
            return ValueProtos.Type.newBuilder().setOptionalType(ValueProtos.OptionalType.newBuilder().setItem(yqlType));
        }
        return yqlType;
    }

    @Override
    protected ValueProtos.Type.Builder getYqlType(YqlType yqlType, boolean optional) {
        return yqlType.getYqlTypeBuilder();
    }

    @Override
    protected ValueProtos.Value.Builder getYqlValue(YqlType type, Object value) {
        return type.toYql(value);
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toQueryParameters(PARAMS params) {
        return this.getYqlStatementParams().stream().collect(Collectors.toMap(YqlStatementParam::getVar, param -> this.createTQueryParameter(param.getType(), this.getParamValue(params, (Param)param), param.isOptional())));
    }

    private Object getParamValue(PARAMS params, Param param) {
        PredParam predParam = this.predParams.get(param.getName());
        if (predParam == null) {
            throw new IllegalStateException("Unknown parameter: " + String.valueOf(param));
        }
        return predParam.getValue(this.getPredicate(params));
    }

    public static enum ComplexField {
        FLATTEN,
        TUPLE;

    }

    private static final class PredParam
    extends Param {
        private static final String NAME_FORMAT = "pred_%d_%s";
        private final int index;
        private final String fieldName;
        private final boolean compositeYqlType;
        private final Schema.JavaField rootField;

        private PredParam(YqlType fieldType, String fieldName, int index, boolean optional, boolean compositeYqlType, Schema.JavaField rootField) {
            super(fieldType, String.format(NAME_FORMAT, index, PredParam.underscoreIllegalSymbols(fieldName)), optional);
            this.compositeYqlType = compositeYqlType;
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index must be >= 0");
            this.fieldName = fieldName;
            this.index = index;
            this.rootField = rootField;
        }

        public Object getValue(YqlPredicate predicate) {
            return this.getParamValue(this.rootField, this.fieldName, this.compositeYqlType, predicate.paramAt(this.index).getValue());
        }
    }

    public static enum CollectionKind {
        SINGLE,
        DICT_SET,
        LIST;

    }

    static class Param
    extends YqlStatementParam {
        private static final Pattern ILLEGAL_SYMBOL_PATTERN = Pattern.compile("[^\\w]");

        Param(YqlType type, String name, boolean optional) {
            super(type, name, optional);
        }

        String getYqlTypeName() {
            return this.getType().getYqlTypeName();
        }

        Object getParamValue(Schema.JavaField rootField, String fieldName, boolean compositeYqlType, Object paramValue) {
            if (paramValue instanceof Iterable) {
                return Streams.stream((Iterable)((Iterable)paramValue)).map(v -> this.getValueForField(rootField, fieldName, compositeYqlType, v)).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return this.getValueForField(rootField, fieldName, compositeYqlType, paramValue);
        }

        private Object getValueForField(Schema.JavaField rootField, String fieldName, boolean compositeYqlType, Object paramValue) {
            if (!compositeYqlType) {
                if (rootField.getValueType().isComposite() && paramValue.getClass().equals(rootField.getRawType())) {
                    LinkedHashMap m = new LinkedHashMap();
                    rootField.collectValueTo(paramValue, m);
                    return m.get(fieldName);
                }
                return paramValue;
            }
            return fieldName.equals(rootField.getName()) ? paramValue : null;
        }

        protected static String underscoreIllegalSymbols(String value) {
            return ILLEGAL_SYMBOL_PATTERN.matcher(value).replaceAll("_");
        }
    }
}

