/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.db.cache.RepositoryCache;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatementParam;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public class FindYqlStatement<PARAMS, ENTITY extends Entity<ENTITY>, RESULT>
extends YqlStatement<PARAMS, ENTITY, RESULT> {
    public FindYqlStatement(TableDescriptor<ENTITY> tableDescriptor, EntitySchema<ENTITY> schema, Schema<RESULT> resultSchema) {
        super(tableDescriptor, schema, resultSchema);
    }

    public List<YqlStatementParam> getParams() {
        return this.schema.flattenId().stream().map(c -> YqlStatementParam.required(YqlType.of(c), c.getName())).collect(Collectors.toList());
    }

    @Override
    public String getQuery(String tablespace) {
        return this.declarations() + "SELECT " + this.outNames() + " FROM " + this.table(tablespace) + " WHERE " + this.nameEqVars();
    }

    @Override
    public List<RESULT> readFromCache(PARAMS params, RepositoryCache cache) {
        RepositoryCache.Key key = new RepositoryCache.Key(this.resultSchema.getType(), params);
        if (!cache.contains(key)) {
            return null;
        }
        return cache.get(key).map(o -> Collections.singletonList(o)).orElse(Collections.emptyList());
    }

    @Override
    public void storeToCache(PARAMS params, List<RESULT> result, RepositoryCache cache) {
        RepositoryCache.Key key = new RepositoryCache.Key(this.resultSchema.getType(), params);
        cache.put(key, result.stream().findFirst().orElse(null));
    }

    @Override
    public Statement.QueryType getQueryType() {
        return Statement.QueryType.SELECT;
    }

    @Override
    public String toDebugString(PARAMS params) {
        return "find(" + String.valueOf(params) + ")";
    }
}

