/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.ydb.statement.PredicateStatement;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicate;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;

public class FindStatement<ENTITY extends Entity<ENTITY>, RESULT>
extends PredicateStatement<Collection<? extends YqlStatementPart<?>>, ENTITY, RESULT> {
    private final boolean distinct;
    private final List<YqlStatementPart<?>> parts;

    public static <E extends Entity<E>, R> FindStatement<E, R> from(@NonNull TableDescriptor<E> tableDescriptor, @NonNull EntitySchema<E> schema, @NonNull Schema<R> outSchema, @NonNull Collection<? extends YqlStatementPart<?>> parts, boolean distinct) {
        if (tableDescriptor == null) {
            throw new NullPointerException("tableDescriptor is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (outSchema == null) {
            throw new NullPointerException("outSchema is marked non-null but is null");
        }
        if (parts == null) {
            throw new NullPointerException("parts is marked non-null but is null");
        }
        ArrayList partsList = new ArrayList(parts);
        if (!distinct && parts.stream().noneMatch(s -> s.getType().equals("OrderBy"))) {
            partsList.add(ORDER_BY_ID_ASCENDING);
        }
        return new FindStatement<E, R>(tableDescriptor, schema, outSchema, partsList, distinct);
    }

    private FindStatement(@NonNull TableDescriptor<ENTITY> tableDescriptor, @NonNull EntitySchema<ENTITY> schema, @NonNull Schema<RESULT> outSchema, @NonNull List<YqlStatementPart<?>> parts, boolean distinct) {
        super(tableDescriptor, schema, outSchema, parts, YqlPredicate::from);
        if (tableDescriptor == null) {
            throw new NullPointerException("tableDescriptor is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (outSchema == null) {
            throw new NullPointerException("outSchema is marked non-null but is null");
        }
        if (parts == null) {
            throw new NullPointerException("parts is marked non-null but is null");
        }
        this.distinct = distinct;
        this.parts = parts;
    }

    @Override
    public String getQuery(String tablespace) {
        return this.declarations() + "SELECT " + (this.distinct ? "DISTINCT " : "") + this.outNames() + " FROM " + this.table(tablespace) + " " + FindStatement.mergeParts(this.parts).sorted(Comparator.comparing(YqlStatementPart::getPriority)).map(sp -> sp.toFullYql(this.schema)).map(this::resolveParamNames).collect(Collectors.joining(" "));
    }

    @Override
    public Statement.QueryType getQueryType() {
        return Statement.QueryType.SELECT;
    }

    @Override
    public String toDebugString(Collection<? extends YqlStatementPart<?>> yqlStatementParts) {
        return "find(" + String.valueOf(yqlStatementParts) + ")";
    }
}

