/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import tech.ydb.proto.ValueProtos;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Range;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatementParam;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public class FindRangeStatement<ENTITY extends Entity<ENTITY>, ID extends Entity.Id<ENTITY>, RESULT>
extends YqlStatement<Range<ID>, ENTITY, RESULT> {
    private final List<YqlStatementParam> params = Stream.of(RangeBound.values()).flatMap(b -> this.toParams(b.map(range).keySet(), (RangeBound)((Object)b))).collect(Collectors.toList());

    public FindRangeStatement(TableDescriptor<ENTITY> tableDescriptor, EntitySchema<ENTITY> schema, Schema<RESULT> outSchema, Range<ID> range) {
        super(tableDescriptor, schema, outSchema);
    }

    private Stream<YqlStatementRangeParam> toParams(Set<String> names, RangeBound rangeBound) {
        return this.schema.flattenId().stream().filter(f -> names.contains(f.getName())).map(c -> new YqlStatementRangeParam((YqlType)YqlType.of(c), c.getName(), rangeBound));
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toQueryParameters(Range<ID> parameters) {
        return this.getParams().stream().map(YqlStatementRangeParam.class::cast).collect(Collectors.toMap(YqlStatementParam::getVar, p -> this.createTQueryParameter(p.getType(), p.rangeBound.map(parameters).get(p.rangeName), p.isOptional())));
    }

    @Override
    public Statement.QueryType getQueryType() {
        return Statement.QueryType.SELECT;
    }

    @Override
    public String toDebugString(Range<ID> idRange) {
        return "find(" + String.valueOf(idRange) + ")";
    }

    @Override
    public String getQuery(String tablespace) {
        String where = this.predicationVars();
        return this.declarations() + "SELECT " + this.outNames() + " FROM " + this.table(tablespace) + (String)(where.isEmpty() ? "" : " WHERE " + where) + " " + ORDER_BY_ID_ASCENDING.toFullYql(this.schema);
    }

    private String predicationVars() {
        return this.getParams().stream().map(YqlStatementRangeParam.class::cast).map(p -> "(" + this.escape(p.rangeName) + p.rangeBound.op + p.getVar() + ")").collect(Collectors.joining(" AND "));
    }

    @Generated
    public List<YqlStatementParam> getParams() {
        return this.params;
    }

    static enum RangeBound {
        EQ("=", Range::getEqMap),
        MAX("<=", Range::getMaxMap),
        MIN(">=", Range::getMinMap);

        String op;
        Function<Range, Map<String, Object>> mapper;

        public Map<String, Object> map(Range range) {
            return this.mapper.apply(range);
        }

        @ConstructorProperties(value={"op", "mapper"})
        @Generated
        private RangeBound(String op, Function<Range, Map<String, Object>> mapper) {
            this.op = op;
            this.mapper = mapper;
        }
    }

    static class YqlStatementRangeParam
    extends YqlStatementParam {
        private final RangeBound rangeBound;
        private final String rangeName;

        YqlStatementRangeParam(YqlType type, String name, RangeBound rangeBound) {
            super(type, rangeBound.name() + "_" + name, true);
            this.rangeBound = rangeBound;
            this.rangeName = name;
        }
    }
}

