/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import tech.ydb.yoj.databind.schema.ObjectSchema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.ydb.statement.Count;
import tech.ydb.yoj.repository.ydb.statement.PredicateStatement;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicate;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;

public class CountAllStatement<ENTITY extends Entity<ENTITY>>
extends PredicateStatement<Collection<? extends YqlStatementPart<?>>, ENTITY, Count> {
    private final List<YqlStatementPart<?>> parts;

    public CountAllStatement(TableDescriptor<ENTITY> tableDescriptor, EntitySchema<ENTITY> schema, List<YqlStatementPart<?>> parts) {
        super(tableDescriptor, schema, ObjectSchema.of(Count.class), parts, YqlPredicate::from);
        this.parts = parts;
    }

    @Override
    public String getQuery(String tablespace) {
        return this.declarations() + "SELECT COUNT(*) AS count FROM " + this.table(tablespace) + " " + CountAllStatement.mergeParts(this.parts).sorted(Comparator.comparing(YqlStatementPart::getPriority)).map(sp -> sp.toFullYql(this.schema)).map(this::resolveParamNames).collect(Collectors.joining(" "));
    }

    @Override
    public Statement.QueryType getQueryType() {
        return Statement.QueryType.SELECT;
    }

    @Override
    public String toDebugString(Collection<? extends YqlStatementPart<?>> yqlStatementParts) {
        return "count(" + String.valueOf(this.parts) + ")";
    }
}

