/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.merge;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.db.cache.RepositoryCache;
import tech.ydb.yoj.repository.db.exception.EntityAlreadyExistsException;
import tech.ydb.yoj.repository.ydb.YdbRepository;
import tech.ydb.yoj.repository.ydb.exception.YdbRepositoryException;
import tech.ydb.yoj.repository.ydb.merge.YqlQueriesMerger;
import tech.ydb.yoj.repository.ydb.statement.DeleteByIdStatement;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.statement.UpsertYqlStatement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatement;

public class ByEntityYqlQueriesMerger
implements YqlQueriesMerger {
    private static final Logger log = LoggerFactory.getLogger(ByEntityYqlQueriesMerger.class);
    private static final Set<Statement.QueryType> SUPPORTED_QUERY_TYPES = new HashSet<Statement.QueryType>(Arrays.asList(Statement.QueryType.INSERT, Statement.QueryType.DELETE, Statement.QueryType.UPSERT, Statement.QueryType.UPDATE, Statement.QueryType.DELETE_ALL));
    private static final Map<TransitionKey, MergingState> transitionMap = ByEntityYqlQueriesMerger.createTransitionMap();
    private final Map<TableDescriptor<?>, TableState> states = new HashMap();
    private final RepositoryCache cache;

    ByEntityYqlQueriesMerger(RepositoryCache cache) {
        this.cache = cache;
    }

    @Override
    public void onNext(YdbRepository.Query<?> query) {
        EntityState state;
        Statement.QueryType queryType = query.getStatement().getQueryType();
        ByEntityYqlQueriesMerger.check(SUPPORTED_QUERY_TYPES.contains((Object)queryType), "Unsupported query type: " + String.valueOf((Object)queryType));
        TableDescriptor tableDescriptor = ByEntityYqlQueriesMerger.convertQueryToYqlStatement(query).getTableDescriptor();
        TableState tableState = this.states.computeIfAbsent(tableDescriptor, __ -> new TableState());
        if (queryType == Statement.QueryType.DELETE_ALL) {
            tableState.entityStates.clear();
            tableState.deleteAll = query;
            return;
        }
        if (queryType == Statement.QueryType.UPDATE) {
            ByEntityYqlQueriesMerger.check(tableState.isEmpty(), "Update operation couldn't be after other modifications");
            tableState.update = query;
            return;
        }
        ByEntityYqlQueriesMerger.check(tableState.deleteAll == null && tableState.update == null, "Modifications after delete_all or update aren't allowed");
        Entity.Id id = ByEntityYqlQueriesMerger.getEntityId(query);
        if (tableState.entityStates.containsKey(id)) {
            state = tableState.entityStates.get(id);
            MergingState oldMergingState = state.getState();
            if ((state = state.withState(this.doTransition(oldMergingState, queryType, query))).getState() != MergingState.INS_DEL) {
                YdbRepository.Query replaceWith = query;
                if (oldMergingState == MergingState.DELETE && queryType == Statement.QueryType.INSERT) {
                    replaceWith = ByEntityYqlQueriesMerger.convertInsertToUpsert(query);
                }
                state = state.withQuery(replaceWith);
            }
        } else {
            state = new EntityState(query, this.doTransition(MergingState.INITIAL, queryType, query));
        }
        tableState.entityStates.put(id, state);
    }

    @Override
    public List<YdbRepository.Query<?>> getQueries() {
        HashMap<MergingState, List> queries = new HashMap<MergingState, List>();
        ArrayList specificQueries = new ArrayList();
        for (TableState tableState : this.states.values()) {
            if (tableState.deleteAll != null) {
                specificQueries.add(tableState.deleteAll);
                continue;
            }
            if (tableState.update != null) {
                specificQueries.add(tableState.update);
                continue;
            }
            HashMap curQueries = new HashMap();
            for (EntityState entityState : tableState.entityStates.values()) {
                MergingState curState = entityState.state;
                if (curState == MergingState.INS_DEL) {
                    this.updateCurQueries(curQueries, ByEntityYqlQueriesMerger.convertInsertToDelete(entityState.query), MergingState.DELETE);
                    curState = MergingState.INSERT;
                } else if (this.needIgnoreQuery(entityState)) {
                    log.trace("Ignoring query: [{}]", entityState.query.getStatement());
                    continue;
                }
                this.updateCurQueries(curQueries, entityState.query, curState);
            }
            for (Map.Entry entry : curQueries.entrySet()) {
                queries.computeIfAbsent((MergingState)((Object)entry.getKey()), __ -> new ArrayList()).add((YdbRepository.Query)entry.getValue());
            }
        }
        ArrayList result = new ArrayList();
        this.addAllIfNonNull(result, (List)queries.get((Object)MergingState.INSERT));
        this.addAllIfNonNull(result, (List)queries.get((Object)MergingState.UPSERT));
        this.addAllIfNonNull(result, (List)queries.get((Object)MergingState.DELETE));
        result.addAll(specificQueries);
        return result;
    }

    private boolean needIgnoreQuery(EntityState entityState) {
        if (entityState.state == MergingState.UPSERT || entityState.state == MergingState.INSERT) {
            Class clazz = ByEntityYqlQueriesMerger.getEntityClass(entityState.query);
            Entity.Id entityId = ByEntityYqlQueriesMerger.getEntityId(entityState.query);
            RepositoryCache.Key key = new RepositoryCache.Key(clazz, (Object)entityId);
            if (entityState.state == MergingState.UPSERT) {
                boolean newValueEqualsCached = this.cache.get(key).map(entity -> entity.equals(entityState.query.getValues().get(0))).orElse(false);
                if (newValueEqualsCached) {
                    log.trace("New value {} is equal to cached value", entityState.query.getValues().get(0));
                }
                return newValueEqualsCached;
            }
            if (this.cache.contains(key) && this.cache.get(key).isPresent()) {
                throw new EntityAlreadyExistsException("Entity " + String.valueOf(entityId) + " already exists");
            }
        }
        return false;
    }

    private void addAllIfNonNull(List<YdbRepository.Query<?>> result, List<YdbRepository.Query<?>> additional) {
        if (additional != null) {
            result.addAll(additional);
        }
    }

    private void updateCurQueries(Map<MergingState, YdbRepository.Query<?>> curQueries, YdbRepository.Query<?> newQuery, MergingState curState) {
        curQueries.computeIfPresent(curState, (__, q) -> q.merge(newQuery));
        curQueries.putIfAbsent(curState, newQuery);
    }

    private MergingState doTransition(MergingState state, Statement.QueryType nextQueryType, YdbRepository.Query<?> query) {
        if (state == MergingState.INSERT && nextQueryType == Statement.QueryType.INSERT) {
            throw new EntityAlreadyExistsException("Entity " + String.valueOf(ByEntityYqlQueriesMerger.getEntityId(query)) + " already exists");
        }
        MergingState nextState = transitionMap.get(new TransitionKey(state, nextQueryType));
        ByEntityYqlQueriesMerger.check(nextState != null, "Incorrect transition, from " + String.valueOf((Object)state) + " by " + String.valueOf((Object)nextQueryType));
        return nextState;
    }

    private static YdbRepository.Query convertInsertToUpsert(YdbRepository.Query<?> query) {
        Class type = ByEntityYqlQueriesMerger.getEntityClass(query);
        EntitySchema schema = EntitySchema.of((Class)type);
        TableDescriptor tableDescriptor = ByEntityYqlQueriesMerger.convertQueryToYqlStatement(query).getTableDescriptor();
        UpsertYqlStatement statement = new UpsertYqlStatement(tableDescriptor, schema);
        return new YdbRepository.Query(statement, query.getValues().get(0));
    }

    private static YdbRepository.Query convertInsertToDelete(YdbRepository.Query<?> query) {
        Class type = ByEntityYqlQueriesMerger.getEntityClass(query);
        EntitySchema schema = EntitySchema.of((Class)type);
        TableDescriptor tableDescriptor = ByEntityYqlQueriesMerger.convertQueryToYqlStatement(query).getTableDescriptor();
        DeleteByIdStatement statement = new DeleteByIdStatement(tableDescriptor, schema);
        return new YdbRepository.Query<Entity.Id>(statement, ByEntityYqlQueriesMerger.getEntityId(query));
    }

    private static Entity.Id getEntityId(YdbRepository.Query<?> query) {
        ByEntityYqlQueriesMerger.check(query.getValues().size() == 1, "Unsupported query");
        Object value = query.getValues().get(0);
        if (query.getStatement().getQueryType() == Statement.QueryType.DELETE) {
            return (Entity.Id)value;
        }
        return ((Entity)value).getId();
    }

    private static Class getEntityClass(YdbRepository.Query query) {
        return ByEntityYqlQueriesMerger.convertQueryToYqlStatement(query).getInSchemaType();
    }

    private static YqlStatement convertQueryToYqlStatement(YdbRepository.Query query) {
        return (YqlStatement)query.getStatement();
    }

    private static void check(boolean condition, String message) {
        if (!condition) {
            throw new YdbRepositoryException(message);
        }
    }

    private static Map<TransitionKey, MergingState> createTransitionMap() {
        HashMap<TransitionKey, MergingState> table = new HashMap<TransitionKey, MergingState>();
        table.put(new TransitionKey(MergingState.INITIAL, Statement.QueryType.INSERT), MergingState.INSERT);
        table.put(new TransitionKey(MergingState.INITIAL, Statement.QueryType.UPSERT), MergingState.UPSERT);
        table.put(new TransitionKey(MergingState.INITIAL, Statement.QueryType.DELETE), MergingState.DELETE);
        table.put(new TransitionKey(MergingState.INSERT, Statement.QueryType.INSERT), MergingState.INSERT);
        table.put(new TransitionKey(MergingState.INSERT, Statement.QueryType.UPSERT), MergingState.INSERT);
        table.put(new TransitionKey(MergingState.INSERT, Statement.QueryType.DELETE), MergingState.INS_DEL);
        table.put(new TransitionKey(MergingState.INS_DEL, Statement.QueryType.INSERT), MergingState.INSERT);
        table.put(new TransitionKey(MergingState.INS_DEL, Statement.QueryType.UPSERT), MergingState.INSERT);
        table.put(new TransitionKey(MergingState.INS_DEL, Statement.QueryType.DELETE), MergingState.INS_DEL);
        table.put(new TransitionKey(MergingState.UPSERT, Statement.QueryType.INSERT), MergingState.INSERT);
        table.put(new TransitionKey(MergingState.UPSERT, Statement.QueryType.UPSERT), MergingState.UPSERT);
        table.put(new TransitionKey(MergingState.UPSERT, Statement.QueryType.DELETE), MergingState.DELETE);
        table.put(new TransitionKey(MergingState.DELETE, Statement.QueryType.INSERT), MergingState.UPSERT);
        table.put(new TransitionKey(MergingState.DELETE, Statement.QueryType.UPSERT), MergingState.UPSERT);
        table.put(new TransitionKey(MergingState.DELETE, Statement.QueryType.DELETE), MergingState.DELETE);
        return table;
    }

    private class TableState {
        private Map<Entity.Id, EntityState> entityStates = new HashMap<Entity.Id, EntityState>();
        private YdbRepository.Query<?> deleteAll;
        private YdbRepository.Query<?> update;

        private TableState() {
        }

        public boolean isEmpty() {
            return this.entityStates.isEmpty() && this.update == null && this.deleteAll == null;
        }
    }

    private final class EntityState {
        private final YdbRepository.Query<?> query;
        private final MergingState state;

        @ConstructorProperties(value={"query", "state"})
        @Generated
        public EntityState(YdbRepository.Query<?> query, MergingState state) {
            this.query = query;
            this.state = state;
        }

        @Generated
        public YdbRepository.Query<?> getQuery() {
            return this.query;
        }

        @Generated
        public MergingState getState() {
            return this.state;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityState)) {
                return false;
            }
            EntityState other = (EntityState)o;
            YdbRepository.Query<?> this$query = this.getQuery();
            YdbRepository.Query<?> other$query = other.getQuery();
            if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
                return false;
            }
            MergingState this$state = this.getState();
            MergingState other$state = other.getState();
            return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            YdbRepository.Query<?> $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
            MergingState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ByEntityYqlQueriesMerger.EntityState(query=" + String.valueOf(this.getQuery()) + ", state=" + String.valueOf((Object)this.getState()) + ")";
        }

        @Generated
        public EntityState withQuery(YdbRepository.Query<?> query) {
            return this.query == query ? this : new EntityState(query, this.state);
        }

        @Generated
        public EntityState withState(MergingState state) {
            return this.state == state ? this : new EntityState(this.query, state);
        }
    }

    private static enum MergingState {
        INITIAL,
        INSERT,
        INS_DEL,
        UPSERT,
        DELETE;

    }

    private static final class TransitionKey {
        private final MergingState state;
        private final Statement.QueryType nextQueryType;

        @ConstructorProperties(value={"state", "nextQueryType"})
        @Generated
        public TransitionKey(MergingState state, Statement.QueryType nextQueryType) {
            this.state = state;
            this.nextQueryType = nextQueryType;
        }

        @Generated
        public MergingState getState() {
            return this.state;
        }

        @Generated
        public Statement.QueryType getNextQueryType() {
            return this.nextQueryType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransitionKey)) {
                return false;
            }
            TransitionKey other = (TransitionKey)o;
            MergingState this$state = this.getState();
            MergingState other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            Statement.QueryType this$nextQueryType = this.getNextQueryType();
            Statement.QueryType other$nextQueryType = other.getNextQueryType();
            return !(this$nextQueryType == null ? other$nextQueryType != null : !((Object)((Object)this$nextQueryType)).equals((Object)other$nextQueryType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MergingState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            Statement.QueryType $nextQueryType = this.getNextQueryType();
            result = result * 59 + ($nextQueryType == null ? 43 : ((Object)((Object)$nextQueryType)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ByEntityYqlQueriesMerger.TransitionKey(state=" + String.valueOf((Object)this.getState()) + ", nextQueryType=" + String.valueOf((Object)this.getNextQueryType()) + ")";
        }
    }
}

