/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.compatibility;

import com.google.common.base.Stopwatch;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.Repository;
import tech.ydb.yoj.repository.db.RepositoryTransaction;
import tech.ydb.yoj.repository.db.StdTxManager;
import tech.ydb.yoj.repository.db.Tx;
import tech.ydb.yoj.repository.db.TxManager;
import tech.ydb.yoj.repository.db.readtable.ReadTableParams;
import tech.ydb.yoj.repository.ydb.YdbRepository;
import tech.ydb.yoj.repository.ydb.compatibility.YdbSchemaCompatibilityChecker;
import tech.ydb.yoj.repository.ydb.exception.YdbSchemaException;

public final class YdbDataCompatibilityChecker {
    private static final Logger log = LoggerFactory.getLogger(YdbSchemaCompatibilityChecker.class);
    private final YdbRepository repository;
    private final List<Class<? extends Entity>> entities;
    private final Config config;

    public YdbDataCompatibilityChecker(List<Class<? extends Entity>> entities, YdbRepository repository, Config config) {
        this.entities = entities;
        this.repository = repository;
        this.config = config;
    }

    public void run() {
        ReadTableParams.ReadTableParamsBuilder paramsBuilder = ReadTableParams.builder();
        if (this.config.rowLimit > 0) {
            paramsBuilder.rowLimit(this.config.rowLimit);
            paramsBuilder.ordered();
        }
        ReadTableParams params = paramsBuilder.timeout(this.config.timeout).build();
        StdTxManager txManager = new StdTxManager((Repository)this.repository);
        Stopwatch totalTime = Stopwatch.createStarted();
        Stream stream = this.entities.stream();
        if (this.config.parallel) {
            stream = (Stream)stream.parallel();
        }
        stream.forEach(arg_0 -> this.lambda$run$1((TxManager)txManager, params, arg_0));
        log.info(String.format("[%s] Data compatibility checked successfully", totalTime));
    }

    private /* synthetic */ void lambda$run$1(TxManager txManager, ReadTableParams params, Class ec) {
        log.info(String.format("Checking entities of %s", ec.getSimpleName()));
        Stopwatch sw = Stopwatch.createStarted();
        try {
            txManager.readOnly().noFirstLevelCache().run(() -> {
                RepositoryTransaction tx = Tx.Current.get().getRepositoryTransaction();
                long checkedCount = tx.table(ec).readTable(params).count();
                log.info(String.format("[%s] Checked %d entities of %s", sw, checkedCount, ec.getSimpleName()));
            });
        }
        catch (Exception e) {
            String message = String.format("[%s] Got exception while checking entities of %s: ", sw, ec.getSimpleName());
            if (this.config.skipSchemaErrors && e instanceof YdbSchemaException) {
                log.warn(message);
            }
            log.error(message);
            throw e;
        }
    }

    public static final class Config {
        public static final Config DEFAULT = Config.builder().build();
        private final int rowLimit;
        private final Duration timeout;
        private final boolean parallel;
        private final boolean skipSchemaErrors;

        @Generated
        private static int $default$rowLimit() {
            return 5000;
        }

        @Generated
        private static Duration $default$timeout() {
            return Duration.ofMinutes(1L);
        }

        @Generated
        private static boolean $default$parallel() {
            return true;
        }

        @Generated
        private static boolean $default$skipSchemaErrors() {
            return false;
        }

        @Generated
        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        @Generated
        public int getRowLimit() {
            return this.rowLimit;
        }

        @Generated
        public Duration getTimeout() {
            return this.timeout;
        }

        @Generated
        public boolean isParallel() {
            return this.parallel;
        }

        @Generated
        public boolean isSkipSchemaErrors() {
            return this.skipSchemaErrors;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (this.getRowLimit() != other.getRowLimit()) {
                return false;
            }
            if (this.isParallel() != other.isParallel()) {
                return false;
            }
            if (this.isSkipSchemaErrors() != other.isSkipSchemaErrors()) {
                return false;
            }
            Duration this$timeout = this.getTimeout();
            Duration other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRowLimit();
            result = result * 59 + (this.isParallel() ? 79 : 97);
            result = result * 59 + (this.isSkipSchemaErrors() ? 79 : 97);
            Duration $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YdbDataCompatibilityChecker.Config(rowLimit=" + this.getRowLimit() + ", timeout=" + String.valueOf(this.getTimeout()) + ", parallel=" + this.isParallel() + ", skipSchemaErrors=" + this.isSkipSchemaErrors() + ")";
        }

        @Generated
        public Config withRowLimit(int rowLimit) {
            return this.rowLimit == rowLimit ? this : new Config(rowLimit, this.timeout, this.parallel, this.skipSchemaErrors);
        }

        @Generated
        public Config withTimeout(Duration timeout) {
            return this.timeout == timeout ? this : new Config(this.rowLimit, timeout, this.parallel, this.skipSchemaErrors);
        }

        @Generated
        public Config withParallel(boolean parallel) {
            return this.parallel == parallel ? this : new Config(this.rowLimit, this.timeout, parallel, this.skipSchemaErrors);
        }

        @Generated
        public Config withSkipSchemaErrors(boolean skipSchemaErrors) {
            return this.skipSchemaErrors == skipSchemaErrors ? this : new Config(this.rowLimit, this.timeout, this.parallel, skipSchemaErrors);
        }

        @ConstructorProperties(value={"rowLimit", "timeout", "parallel", "skipSchemaErrors"})
        @Generated
        private Config(int rowLimit, Duration timeout, boolean parallel, boolean skipSchemaErrors) {
            this.rowLimit = rowLimit;
            this.timeout = timeout;
            this.parallel = parallel;
            this.skipSchemaErrors = skipSchemaErrors;
        }

        @Generated
        public static class ConfigBuilder {
            @Generated
            private boolean rowLimit$set;
            @Generated
            private int rowLimit$value;
            @Generated
            private boolean timeout$set;
            @Generated
            private Duration timeout$value;
            @Generated
            private boolean parallel$set;
            @Generated
            private boolean parallel$value;
            @Generated
            private boolean skipSchemaErrors$set;
            @Generated
            private boolean skipSchemaErrors$value;

            @Generated
            ConfigBuilder() {
            }

            @Generated
            public ConfigBuilder rowLimit(int rowLimit) {
                this.rowLimit$value = rowLimit;
                this.rowLimit$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder timeout(Duration timeout) {
                this.timeout$value = timeout;
                this.timeout$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder parallel(boolean parallel) {
                this.parallel$value = parallel;
                this.parallel$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder skipSchemaErrors(boolean skipSchemaErrors) {
                this.skipSchemaErrors$value = skipSchemaErrors;
                this.skipSchemaErrors$set = true;
                return this;
            }

            @Generated
            public Config build() {
                int rowLimit$value = this.rowLimit$value;
                if (!this.rowLimit$set) {
                    rowLimit$value = Config.$default$rowLimit();
                }
                Duration timeout$value = this.timeout$value;
                if (!this.timeout$set) {
                    timeout$value = Config.$default$timeout();
                }
                boolean parallel$value = this.parallel$value;
                if (!this.parallel$set) {
                    parallel$value = Config.$default$parallel();
                }
                boolean skipSchemaErrors$value = this.skipSchemaErrors$value;
                if (!this.skipSchemaErrors$set) {
                    skipSchemaErrors$value = Config.$default$skipSchemaErrors();
                }
                return new Config(rowLimit$value, timeout$value, parallel$value, skipSchemaErrors$value);
            }

            @Generated
            public String toString() {
                return "YdbDataCompatibilityChecker.Config.ConfigBuilder(rowLimit$value=" + this.rowLimit$value + ", timeout$value=" + String.valueOf(this.timeout$value) + ", parallel$value=" + this.parallel$value + ", skipSchemaErrors$value=" + this.skipSchemaErrors$value + ")";
            }
        }
    }
}

