/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client;

import com.google.common.base.Preconditions;

public final class YdbPaths {
    private YdbPaths() {
    }

    public static String canonicalTablespace(String tablespace) {
        Preconditions.checkArgument((boolean)tablespace.startsWith("/"), (String)"tablespace must be an absolute path, but got: '%s'", (Object)tablespace);
        return tablespace.endsWith("/") ? tablespace : tablespace + "/";
    }

    public static String canonicalRootDir(String tablespace) {
        Preconditions.checkArgument((boolean)tablespace.startsWith("/"), (String)"tablespace must be an absolute path, but got: '%s'", (Object)tablespace);
        return tablespace.endsWith("/") ? tablespace.substring(0, tablespace.length() - 1) : tablespace;
    }

    public static String canonicalDatabase(String database) {
        Preconditions.checkArgument((boolean)database.startsWith("/"), (String)"database path must be absolute, but got: '%s'", (Object)database);
        return database.endsWith("/") ? database.substring(0, database.length() - 1) : database;
    }

    public static String join(String parent, String child) {
        return parent.isEmpty() ? child : (String)(parent.endsWith("/") ? parent : parent + "/") + child;
    }

    public static String tableDirectory(String tablePath) {
        if (!tablePath.contains("/")) {
            return null;
        }
        return tablePath.substring(0, tablePath.lastIndexOf("/"));
    }
}

