/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import tech.ydb.yoj.repository.db.exception.InternalRepositoryException;
import tech.ydb.yoj.repository.db.exception.QueryInterruptedException;
import tech.ydb.yoj.repository.db.exception.RepositoryException;
import tech.ydb.yoj.repository.db.exception.UnavailableException;
import tech.ydb.yoj.repository.ydb.client.YdbValidator;
import tech.ydb.yoj.repository.ydb.exception.YdbRepositoryException;
import tech.ydb.yoj.util.lang.Interrupts;

public final class YdbOperations {
    private YdbOperations() {
    }

    public static <T> T safeJoin(CompletableFuture<T> future) {
        return YdbOperations.safeJoin(future, Duration.ofMinutes(5L));
    }

    public static <T> T safeJoin(CompletableFuture<T> future, Duration timeout) {
        try {
            return future.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw YdbOperations.convertToRepositoryException(e);
        }
    }

    private static RepositoryException convertToUnavailable(Throwable ex) {
        if (Interrupts.isThreadInterrupted((Throwable)ex)) {
            Thread.currentThread().interrupt();
            return new QueryInterruptedException("DB query interrupted", ex);
        }
        YdbValidator.checkGrpcContextStatus(ex.getMessage(), ex);
        return new UnavailableException("DB is unavailable", ex);
    }

    public static RepositoryException convertToRepositoryException(Throwable ex) {
        if (ex instanceof CancellationException) {
            return YdbOperations.convertToUnavailable(ex);
        }
        if (ex instanceof CompletionException) {
            return YdbOperations.convertToUnavailable(ex);
        }
        if (ex instanceof InterruptedException) {
            return YdbOperations.convertToUnavailable(ex);
        }
        if (ex instanceof TimeoutException) {
            return YdbOperations.convertToUnavailable(ex);
        }
        if (ex instanceof ExecutionException) {
            return new YdbRepositoryException("ExecutionException was caught", ex.getCause());
        }
        if (ex instanceof RepositoryException) {
            return (RepositoryException)ex;
        }
        return new InternalRepositoryException(ex);
    }
}

