/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb;

import io.grpc.MethodDescriptor;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import lombok.Generated;
import tech.ydb.core.Result;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.yoj.util.function.MoreSuppliers;

final class LazyGrpcTransport
implements GrpcTransport {
    private final String database;
    private final MoreSuppliers.CloseableMemoizer<GrpcTransport> transport;

    LazyGrpcTransport(GrpcTransportBuilder builder, Function<GrpcTransportBuilder, GrpcTransport> init) {
        this.database = builder.getDatabase();
        this.transport = MoreSuppliers.memoizeCloseable(() -> (GrpcTransport)init.apply(builder));
    }

    public <ReqT, RespT> CompletableFuture<Result<RespT>> unaryCall(MethodDescriptor<ReqT, RespT> method, GrpcRequestSettings settings, ReqT request) {
        return ((GrpcTransport)this.transport.get()).unaryCall(method, settings, request);
    }

    public <ReqT, RespT> GrpcReadStream<RespT> readStreamCall(MethodDescriptor<ReqT, RespT> method, GrpcRequestSettings settings, ReqT request) {
        return ((GrpcTransport)this.transport.get()).readStreamCall(method, settings, request);
    }

    public <ReqT, RespT> GrpcReadWriteStream<RespT, ReqT> readWriteStreamCall(MethodDescriptor<ReqT, RespT> method, GrpcRequestSettings settings) {
        return ((GrpcTransport)this.transport.get()).readWriteStreamCall(method, settings);
    }

    public ScheduledExecutorService getScheduler() {
        return ((GrpcTransport)this.transport.get()).getScheduler();
    }

    public void close() {
        this.transport.close();
    }

    public String toString() {
        return "LazyGrpcTransport[transport created: " + this.transport.isInitialized() + "]";
    }

    @ConstructorProperties(value={"database", "transport"})
    @Generated
    public LazyGrpcTransport(String database, MoreSuppliers.CloseableMemoizer<GrpcTransport> transport) {
        this.database = database;
        this.transport = transport;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }
}

