/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.Range;
import tech.ydb.yoj.repository.ydb.yql.YqlLimit;
import tech.ydb.yoj.repository.ydb.yql.YqlOrderBy;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicate;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;

abstract class BatchFindSpliterator<R, T extends Entity<T>, ID extends Entity.Id<T>>
implements Spliterator<R> {
    private final YqlOrderBy orderById;
    private final YqlLimit top;
    private final int batchSize;
    private final EntityIdSchema<ID> idSchema;
    private List<YqlPredicate> initialPartialPredicates = List.of();
    private List<Schema.JavaFieldValue> lastPartialId = List.of();
    private List<R> remainingItems = List.of();
    private boolean finished = false;

    protected abstract ID getId(R var1);

    protected abstract List<R> find(YqlStatementPart<?> var1, YqlStatementPart<?> ... var2);

    BatchFindSpliterator(Class<T> entityType, int batchSize) {
        this(entityType, null, batchSize);
    }

    BatchFindSpliterator(Class<T> entityType, ID partial, int batchSize) {
        this.batchSize = batchSize;
        this.idSchema = EntityIdSchema.ofEntity(entityType);
        this.orderById = YqlOrderBy.orderBy(this.idSchema.flattenFields().stream().map(s -> new YqlOrderBy.SortKey(s.getPath(), YqlOrderBy.SortOrder.ASC)).collect(Collectors.toList()));
        this.top = YqlLimit.top(batchSize);
        if (partial != null) {
            Range range = new Range(partial);
            Map eqMap = range.getEqMap();
            this.initialPartialPredicates = this.idSchema.flattenFields().stream().filter(f -> eqMap.containsKey(f.getName())).map(f -> YqlPredicate.eq(f.getPath(), eqMap.get(f.getName()))).collect(Collectors.toList());
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action) {
        boolean foundSomething;
        List<R> result = this.remainingItems;
        while (result.isEmpty() && !this.finished) {
            result = this.next();
            if (!result.isEmpty()) {
                R lastResult = result.get(result.size() - 1);
                this.lastPartialId = this.idSchema.flattenToList(this.getId(lastResult));
            }
            if (result.size() < this.batchSize && !this.lastPartialId.isEmpty()) {
                this.lastPartialId.remove(this.lastPartialId.size() - 1);
            }
            this.finished = this.lastPartialId.size() <= this.initialPartialPredicates.size();
        }
        boolean bl = foundSomething = !result.isEmpty();
        if (foundSomething) {
            action.accept(result.get(0));
        }
        this.remainingItems = foundSomething ? result.subList(1, result.size()) : List.of();
        return foundSomething;
    }

    private List<R> next() {
        if (this.lastPartialId.size() != 0 && this.lastPartialId.size() <= this.initialPartialPredicates.size()) {
            return List.of();
        }
        ArrayList<YqlPredicate> predicates = new ArrayList<YqlPredicate>(this.initialPartialPredicates);
        for (int i = 0; i < this.lastPartialId.size(); ++i) {
            Schema.JavaFieldValue e = this.lastPartialId.get(i);
            predicates.add(i == this.lastPartialId.size() - 1 ? YqlPredicate.gt(e.getFieldPath(), e.getValue()) : YqlPredicate.eq(e.getFieldPath(), e.getValue()));
        }
        return this.find(YqlPredicate.and(predicates), this.orderById, this.top);
    }

    @Override
    public Spliterator<R> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 272;
    }
}

