/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import com.google.common.base.Preconditions;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.ydb.statement.PredicateStatement;
import tech.ydb.yoj.repository.ydb.statement.UpdateModel;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public final class UpdateSetParam
extends PredicateStatement.Param {
    private static final String PREFIX = "set_";
    private final Schema.JavaField field;
    private final Schema.JavaField rootField;
    private final String rootFieldPath;

    private UpdateSetParam(@NonNull Schema.JavaField field, @NonNull Schema.JavaField rootField, @NonNull String rootFieldPath) {
        super(YqlType.of(field), PREFIX + UpdateSetParam.underscoreIllegalSymbols(field.getName()), true);
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (rootField == null) {
            throw new NullPointerException("rootField is marked non-null but is null");
        }
        if (rootFieldPath == null) {
            throw new NullPointerException("rootFieldPath is marked non-null but is null");
        }
        Preconditions.checkState((boolean)field.isFlat(), (Object)"Can only create update statements for flat fields");
        this.field = field;
        this.rootField = rootField;
        this.rootFieldPath = rootFieldPath;
    }

    static Stream<UpdateSetParam> setParamsFromModel(@NonNull EntitySchema<?> schema, @NonNull UpdateModel model) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return model.getNewValues().keySet().stream().flatMap(rootFieldPath -> {
            Schema.JavaField rootField = schema.getField(rootFieldPath);
            return rootField.flatten().map(jf -> new UpdateSetParam((Schema.JavaField)jf, rootField, (String)rootFieldPath));
        });
    }

    String getFieldName() {
        return this.field.getName();
    }

    public Object getFieldValue(@NonNull UpdateModel model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return this.getParamValue(this.rootField, this.getFieldName(), false, model.getNewValues().get(this.rootFieldPath));
    }

    @Generated
    public Schema.JavaField getField() {
        return this.field;
    }

    @Generated
    public Schema.JavaField getRootField() {
        return this.rootField;
    }

    @Generated
    public String getRootFieldPath() {
        return this.rootFieldPath;
    }
}

