/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import com.google.common.base.Preconditions;
import com.google.protobuf.NullValue;
import com.yandex.ydb.ValueProtos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import tech.ydb.yoj.databind.expression.FilterExpression;
import tech.ydb.yoj.databind.expression.OrderExpression;
import tech.ydb.yoj.databind.schema.ObjectSchema;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Range;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.db.ViewSchema;
import tech.ydb.yoj.repository.db.cache.RepositoryCache;
import tech.ydb.yoj.repository.ydb.statement.Count;
import tech.ydb.yoj.repository.ydb.statement.DeleteByIdStatement;
import tech.ydb.yoj.repository.ydb.statement.FindAllYqlStatement;
import tech.ydb.yoj.repository.ydb.statement.FindInStatement;
import tech.ydb.yoj.repository.ydb.statement.FindRangeStatement;
import tech.ydb.yoj.repository.ydb.statement.InsertYqlStatement;
import tech.ydb.yoj.repository.ydb.statement.PredicateStatement;
import tech.ydb.yoj.repository.ydb.statement.ResultSetReader;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.repository.ydb.statement.UpdateByIdStatement;
import tech.ydb.yoj.repository.ydb.statement.UpdateModel;
import tech.ydb.yoj.repository.ydb.statement.UpsertYqlStatement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatementParam;
import tech.ydb.yoj.repository.ydb.yql.YqlOrderBy;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicate;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public abstract class YqlStatement<PARAMS, ENTITY extends Entity<ENTITY>, RESULT>
implements Statement<PARAMS, RESULT> {
    protected static final Collector<ValueProtos.Value.Builder, ValueProtos.Value.Builder, ValueProtos.Value.Builder> itemsCollector = Collector.of(ValueProtos.Value::newBuilder, ValueProtos.Value.Builder::addItems, (b, b2) -> b.addAllItems((Iterable)b2.getItemsList()), new Collector.Characteristics[0]);
    protected static final YqlOrderBy ORDER_BY_ID_ASCENDING = YqlOrderBy.orderBy("id", new String[0]);
    protected final EntitySchema<ENTITY> schema;
    protected final Schema<RESULT> resultSchema;
    protected final ResultSetReader<RESULT> resultSetReader;
    protected final String tableName;

    public YqlStatement(@NonNull EntitySchema<ENTITY> schema, @NonNull Schema<RESULT> resultSchema) {
        this(schema, resultSchema, schema.getName());
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (resultSchema == null) {
            throw new NullPointerException("resultSchema is marked non-null but is null");
        }
    }

    public YqlStatement(@NonNull EntitySchema<ENTITY> schema, @NonNull Schema<RESULT> resultSchema, @NonNull String tableName) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (resultSchema == null) {
            throw new NullPointerException("resultSchema is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.schema = schema;
        this.resultSchema = resultSchema;
        this.resultSetReader = new ResultSetReader<RESULT>(resultSchema);
        this.tableName = tableName;
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>> Statement<PARAMS, ENTITY> insert(Class<ENTITY> type) {
        return new InsertYqlStatement(type);
    }

    public static <ENTITY extends Entity<ENTITY>, ID extends Entity.Id<ENTITY>> Statement<UpdateModel.ById<ID>, ?> update(Class<ENTITY> type, UpdateModel.ById<ID> model) {
        return new UpdateByIdStatement<ENTITY, ID>(type, model);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>> Statement<PARAMS, ENTITY> save(Class<ENTITY> type) {
        return new UpsertYqlStatement(type);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>> Statement<PARAMS, ENTITY> find(Class<ENTITY> type) {
        EntitySchema schema = EntitySchema.of(type);
        return YqlStatement.find(schema, schema);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>, VIEW extends Table.View> Statement<PARAMS, VIEW> find(Class<ENTITY> type, Class<VIEW> viewType) {
        return YqlStatement.find(EntitySchema.of(type), ViewSchema.of(viewType));
    }

    private static <PARAMS, ENTITY extends Entity<ENTITY>, RESULT> Statement<PARAMS, RESULT> find(EntitySchema<ENTITY> schema, Schema<RESULT> resultSchema) {
        return new YqlStatement<PARAMS, ENTITY, RESULT>((EntitySchema)schema, (Schema)resultSchema){

            public List<YqlStatementParam> getParams() {
                return this.schema.flattenId().stream().map(c -> YqlStatementParam.required(YqlType.of(c), c.getName())).collect(Collectors.toList());
            }

            @Override
            public String getQuery(String tablespace) {
                return this.declarations() + "SELECT " + this.outNames() + " FROM " + this.table(tablespace) + " WHERE " + this.nameEqVars();
            }

            @Override
            public List<RESULT> readFromCache(PARAMS params, RepositoryCache cache) {
                RepositoryCache.Key key = new RepositoryCache.Key(this.resultSchema.getType(), params);
                if (!cache.contains(key)) {
                    return null;
                }
                return cache.get(key).map(o -> Collections.singletonList(o)).orElse(Collections.emptyList());
            }

            @Override
            public void storeToCache(PARAMS params, List<RESULT> result, RepositoryCache cache) {
                RepositoryCache.Key key = new RepositoryCache.Key(this.resultSchema.getType(), params);
                cache.put(key, result.stream().findFirst().orElse(null));
            }

            @Override
            public Statement.QueryType getQueryType() {
                return Statement.QueryType.SELECT;
            }

            @Override
            public String toDebugString(PARAMS params) {
                return "find(" + params + ")";
            }
        };
    }

    public static <ENTITY extends Entity<ENTITY>, ID extends Entity.Id<ENTITY>> Statement<Range<ID>, ENTITY> findRange(Class<ENTITY> type, Range<ID> range) {
        EntitySchema schema = EntitySchema.of(type);
        return new FindRangeStatement(schema, schema, range);
    }

    public static <ENTITY extends Entity<ENTITY>, VIEW extends Table.View, ID extends Entity.Id<ENTITY>> Statement<Range<ID>, VIEW> findRange(Class<ENTITY> type, Class<VIEW> viewType, Range<ID> range) {
        return new FindRangeStatement(EntitySchema.of(type), ViewSchema.of(viewType), range);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>, ID extends Entity.Id<ENTITY>> Statement<PARAMS, ID> findIdsIn(Class<ENTITY> type, Iterable<ID> ids, FilterExpression<ENTITY> filter, OrderExpression<ENTITY> orderBy, Integer limit) {
        return new FindInStatement(EntitySchema.of(type), EntityIdSchema.ofEntity(type), ids, filter, orderBy, limit);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>> Statement<PARAMS, ENTITY> findIn(Class<ENTITY> type, Iterable<? extends Entity.Id<ENTITY>> ids, FilterExpression<ENTITY> filter, OrderExpression<ENTITY> orderBy, Integer limit) {
        return new FindInStatement(EntitySchema.of(type), EntitySchema.of(type), ids, filter, orderBy, limit);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>, VIEW extends Table.View> Statement<PARAMS, VIEW> findIn(Class<ENTITY> type, Class<VIEW> viewType, Iterable<? extends Entity.Id<ENTITY>> ids, FilterExpression<ENTITY> filter, OrderExpression<ENTITY> orderBy, Integer limit) {
        return new FindInStatement(EntitySchema.of(type), ViewSchema.of(viewType), ids, filter, orderBy, limit);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>, K> Statement<PARAMS, ENTITY> findIn(Class<ENTITY> type, String indexName, Iterable<K> keys, FilterExpression<ENTITY> filter, OrderExpression<ENTITY> orderBy, Integer limit) {
        return new FindInStatement(EntitySchema.of(type), EntitySchema.of(type), indexName, keys, filter, orderBy, limit);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>, VIEW extends Table.View, K> Statement<PARAMS, VIEW> findIn(Class<ENTITY> type, Class<VIEW> viewType, String indexName, Iterable<K> keys, FilterExpression<ENTITY> filter, OrderExpression<ENTITY> orderBy, Integer limit) {
        return new FindInStatement(EntitySchema.of(type), ViewSchema.of(viewType), indexName, keys, filter, orderBy, limit);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>> Statement<PARAMS, ENTITY> findAll(Class<ENTITY> type) {
        EntitySchema schema = EntitySchema.of(type);
        return YqlStatement.findAll(schema, schema);
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>, VIEW extends Table.View> Statement<PARAMS, VIEW> findAll(Class<ENTITY> type, Class<VIEW> viewType) {
        return YqlStatement.findAll(EntitySchema.of(type), ViewSchema.of(viewType));
    }

    private static <PARAMS, ENTITY extends Entity<ENTITY>, RESULT> Statement<PARAMS, RESULT> findAll(EntitySchema<ENTITY> schema, Schema<RESULT> outSchema) {
        return new FindAllYqlStatement(schema, outSchema);
    }

    public static <ENTITY extends Entity<ENTITY>> Statement<Collection<? extends YqlStatementPart<?>>, ENTITY> find(Class<ENTITY> type, Collection<? extends YqlStatementPart<?>> parts) {
        EntitySchema schema = EntitySchema.of(type);
        return YqlStatement.find(schema, schema, false, parts);
    }

    public static <ENTITY extends Entity<ENTITY>, VIEW extends Table.View> Statement<Collection<? extends YqlStatementPart<?>>, VIEW> find(Class<ENTITY> type, Class<VIEW> viewType, Collection<? extends YqlStatementPart<?>> parts) {
        return YqlStatement.find(type, viewType, false, parts);
    }

    public static <ENTITY extends Entity<ENTITY>, VIEW extends Table.View> Statement<Collection<? extends YqlStatementPart<?>>, VIEW> find(Class<ENTITY> type, Class<VIEW> viewType, boolean distinct, Collection<? extends YqlStatementPart<?>> parts) {
        return YqlStatement.find(EntitySchema.of(type), ViewSchema.of(viewType), distinct, parts);
    }

    public static <ENTITY extends Entity<ENTITY>, ID extends Entity.Id<ENTITY>> Statement<Collection<? extends YqlStatementPart<?>>, ID> findIds(Class<ENTITY> type, Collection<? extends YqlStatementPart<?>> parts) {
        return YqlStatement.find(EntitySchema.of(type), EntityIdSchema.ofEntity(type), false, parts);
    }

    public static <ENTITY extends Entity<ENTITY>, ID extends Entity.Id<ENTITY>> Statement<Range<ID>, ID> findIds(Class<ENTITY> type, Range<ID> range) {
        return new FindRangeStatement(EntitySchema.of(type), EntityIdSchema.ofEntity(type), range);
    }

    @Override
    public void storeToCache(PARAMS params, List<RESULT> result, RepositoryCache cache) {
        if (result == null) {
            return;
        }
        for (RESULT o : result) {
            if (!(o instanceof Entity)) break;
            Entity e = (Entity)o;
            cache.put(new RepositoryCache.Key(e.getClass(), (Object)e.getId()), (Object)e);
        }
    }

    public String getDeclaration(String name, String type) {
        return String.format("DECLARE %s AS %s;\n", name, type);
    }

    private static <ENTITY extends Entity<ENTITY>, RESULT> Statement<Collection<? extends YqlStatementPart<?>>, RESULT> find(EntitySchema<ENTITY> schema, Schema<RESULT> resultSchema, final boolean distinct, Collection<? extends YqlStatementPart<?>> parts) {
        final ArrayList partList = new ArrayList(parts);
        if (!distinct && parts.stream().noneMatch(s -> s.getType().equals("OrderBy"))) {
            partList.add(ORDER_BY_ID_ASCENDING);
        }
        return new PredicateStatement<Collection<? extends YqlStatementPart<?>>, ENTITY, RESULT>(schema, resultSchema, parts, YqlStatement::predicateFrom){

            @Override
            public String getQuery(String tablespace) {
                return this.declarations() + "SELECT " + (distinct ? "DISTINCT " : "") + this.outNames() + " FROM " + this.table(tablespace) + " " + 2.mergeParts(partList.stream()).sorted(Comparator.comparing(YqlStatementPart::getPriority)).map(sp -> sp.toFullYql(this.schema)).map(this::resolveParamNames).collect(Collectors.joining(" "));
            }

            @Override
            public Statement.QueryType getQueryType() {
                return Statement.QueryType.SELECT;
            }

            @Override
            public String toDebugString(Collection<? extends YqlStatementPart<?>> yqlStatementParts) {
                return "find(" + yqlStatementParts + ")";
            }
        };
    }

    public static <ENTITY extends Entity<ENTITY>> Statement<Collection<? extends YqlStatementPart<?>>, Count> count(Class<ENTITY> entityType, Collection<? extends YqlStatementPart<?>> parts) {
        return YqlStatement.count(EntitySchema.of(entityType), parts);
    }

    private static <ENTITY extends Entity<ENTITY>> Statement<Collection<? extends YqlStatementPart<?>>, Count> count(EntitySchema<ENTITY> schema, final Collection<? extends YqlStatementPart<?>> parts) {
        return new PredicateStatement<Collection<? extends YqlStatementPart<?>>, ENTITY, Count>(schema, (Schema)ObjectSchema.of(Count.class), parts, YqlStatement::predicateFrom){

            @Override
            public String getQuery(String tablespace) {
                return this.declarations() + "SELECT COUNT(*) AS count FROM " + this.table(tablespace) + " " + 3.mergeParts(parts.stream()).sorted(Comparator.comparing(YqlStatementPart::getPriority)).map(sp -> sp.toFullYql(this.schema)).map(this::resolveParamNames).collect(Collectors.joining(" "));
            }

            @Override
            public Statement.QueryType getQueryType() {
                return Statement.QueryType.SELECT;
            }

            @Override
            public String toDebugString(Collection<? extends YqlStatementPart<?>> yqlStatementParts) {
                return "count(" + parts + ")";
            }
        };
    }

    protected static YqlPredicate predicateFrom(Collection<? extends YqlStatementPart<?>> parts) {
        return parts.stream().filter(p -> p instanceof YqlPredicate).map(YqlPredicate.class::cast).reduce(YqlPredicate.alwaysTrue(), (p1, p2) -> p1.and((YqlPredicate)p2));
    }

    protected static Stream<? extends YqlStatementPart<?>> mergeParts(Stream<? extends YqlStatementPart<?>> origParts) {
        return origParts.collect(Collectors.groupingBy(YqlStatementPart::getType)).values().stream().flatMap(items -> YqlStatement.combine(items).stream());
    }

    private static List<? extends YqlStatementPart<?>> combine(List<? extends YqlStatementPart<?>> items) {
        if (items.size() < 2) {
            return items;
        }
        YqlStatementPart<?> first = items.iterator().next();
        return first.combine(items.subList(1, items.size()));
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>> Statement<PARAMS, ENTITY> deleteAll(Class<ENTITY> type) {
        return new Simple<PARAMS, ENTITY>((Class)type){

            @Override
            public String getQuery(String tablespace) {
                return "DELETE FROM " + this.table(tablespace);
            }

            @Override
            public Statement.QueryType getQueryType() {
                return Statement.QueryType.DELETE_ALL;
            }

            @Override
            public String toDebugString(PARAMS params) {
                return "deleteAll(" + this.schema.getName() + ")";
            }
        };
    }

    public static <PARAMS, ENTITY extends Entity<ENTITY>> Statement<PARAMS, ENTITY> delete(Class<ENTITY> type) {
        return new DeleteByIdStatement(type);
    }

    @Override
    public boolean isPreparable() {
        return true;
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toQueryParameters(PARAMS params) {
        Map values = params.getClass().isAssignableFrom(this.schema.getType()) ? this.schema.flatten((Object)((Entity)params)) : this.schema.flattenId((Entity.Id)params);
        return this.getParams().stream().filter(p -> values.containsKey(p.getName())).collect(Collectors.toMap(YqlStatementParam::getVar, p -> this.createTQueryParameter(p.getType(), values.get(p.getName()), p.isOptional())));
    }

    protected ValueProtos.TypedValue createTQueryParameter(YqlType type, Object o, boolean optional) {
        return ValueProtos.TypedValue.newBuilder().setType(this.getYqlType(type, optional)).setValue(this.getYqlValue(type, o)).build();
    }

    protected ValueProtos.Type.Builder getYqlType(YqlType yqlType, boolean optional) {
        ValueProtos.Type.Builder ttype = yqlType.getYqlTypeBuilder();
        return !optional ? ttype : ValueProtos.Type.newBuilder().setOptionalType(ValueProtos.OptionalType.newBuilder().setItem(ttype));
    }

    protected ValueProtos.Value.Builder getYqlValue(YqlType type, Object value) {
        return value == null ? ValueProtos.Value.newBuilder().setNullFlagValue(NullValue.NULL_VALUE) : type.toYql(value);
    }

    @Override
    public RESULT readResult(List<ValueProtos.Column> columns, ValueProtos.Value value) {
        return this.resultSetReader.readResult(columns, value);
    }

    public String toString() {
        return this.getQuery("");
    }

    public boolean equals(Object o) {
        return o == this || o instanceof YqlStatement && ((YqlStatement)o).getQuery("").equals(this.getQuery(""));
    }

    public int hashCode() {
        return this.getQuery("").hashCode();
    }

    public Class<ENTITY> getInSchemaType() {
        return this.schema.getType();
    }

    @NonNull
    public String getTableName() {
        return this.tableName;
    }

    protected Collection<YqlStatementParam> getParams() {
        return Collections.emptyList();
    }

    protected String declarations() {
        return this.getParams().stream().map(p -> this.getDeclaration(p.getVar(), p.getType().getYqlTypeName() + (p.isOptional() ? "?" : ""))).collect(Collectors.joining());
    }

    protected String outNames() {
        return this.resultSchema.flattenFields().stream().map(Schema.JavaField::getName).map(this::escape).collect(Collectors.joining(", "));
    }

    protected String nameEqVars() {
        return this.getParams().stream().map(p -> this.escape(p.getName()) + " = " + p.getVar()).collect(Collectors.joining(" AND "));
    }

    protected String table(String tablespace) {
        return this.escape(tablespace + this.tableName);
    }

    protected String escape(String value) {
        return "`" + value + "`";
    }

    protected String resolveParamNames(String yql) {
        StringBuilder newYql = new StringBuilder();
        Spliterator<YqlStatementParam> paramSpliter = this.getParams().spliterator();
        int paramCount = 0;
        boolean inFieldPlaceholder = false;
        StringBuilder fieldPlaceholder = new StringBuilder();
        block10: for (int i = 0; i < yql.length(); ++i) {
            char ch = yql.charAt(i);
            if (inFieldPlaceholder) {
                switch (ch) {
                    case '{': {
                        throw new IllegalStateException("Nested field placeholders are prohibited");
                    }
                    case '}': {
                        String fieldPath = fieldPlaceholder.toString();
                        Schema.JavaField field = this.schema.getField(fieldPath);
                        Preconditions.checkState((boolean)field.isSimple(), (String)"%s: only simple fields can be referenced using {field.subfield} syntax", (Object)fieldPath);
                        newYql.append(field.getName());
                        fieldPlaceholder.setLength(0);
                        inFieldPlaceholder = false;
                        break;
                    }
                    case '?': {
                        throw new IllegalStateException("Parameter substitution inside field placeholders is prohibited");
                    }
                    default: {
                        fieldPlaceholder.append(ch);
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '{': {
                    inFieldPlaceholder = true;
                    continue block10;
                }
                case '}': {
                    throw new IllegalStateException("Dangling closing curly brace } at <yql>:" + (i + 1));
                }
                case '?': {
                    ++paramCount;
                    if (paramSpliter.tryAdvance(param -> newYql.append(param.getVar()))) continue block10;
                    throw new IllegalStateException(String.format("Parameter list is too small: expected at least %d parameters, but got: %d", paramCount, paramCount - 1));
                }
                default: {
                    newYql.append(ch);
                }
            }
        }
        return newYql.toString();
    }

    protected static abstract class Simple<PARAMS, ENTITY extends Entity<ENTITY>>
    extends YqlStatement<PARAMS, ENTITY, ENTITY> {
        public Simple(@NonNull Class<ENTITY> type) {
            super(EntitySchema.of(type), EntitySchema.of(type));
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
        }
    }
}

