/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import com.yandex.ydb.ValueProtos;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.exception.ConversionException;
import tech.ydb.yoj.repository.ydb.yql.YqlType;
import tech.ydb.yoj.util.lang.BetterCollectors;

public class ResultSetReader<RESULT> {
    private final Map<String, YqlType> fields;
    protected final Schema<RESULT> resultSchema;

    public ResultSetReader(@NonNull Schema<RESULT> resultSchema) {
        if (resultSchema == null) {
            throw new NullPointerException("resultSchema is marked non-null but is null");
        }
        this.fields = resultSchema.flattenFields().stream().collect(Collectors.toMap(Schema.JavaField::getName, YqlType::of));
        this.resultSchema = resultSchema;
    }

    public RESULT readResult(List<ValueProtos.Column> columnList, ValueProtos.Value value) {
        List row = value.getItemsList();
        Map cells = (Map)IntStream.range(0, row.size()).boxed().collect(BetterCollectors.toMapNullFriendly(i -> ((ValueProtos.Column)columnList.get((int)i)).getName(), i -> this.fields.get(((ValueProtos.Column)columnList.get((int)i)).getName()).fromYql((ValueProtos.Value)row.get((int)i))));
        try {
            return (RESULT)this.resultSchema.newInstance(cells);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Could not convert %s%s: %s", this.resultSchema.getName(), ResultSetReader.id(cells), e.getMessage()), (Throwable)e);
        }
    }

    private static String id(Map<String, Object> cells) {
        return cells.entrySet().stream().filter(e -> EntityIdSchema.isIdFieldName((String)((String)e.getKey()))).map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(",", "{", "}"));
    }
}

