/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.statement;

import com.yandex.ydb.ValueProtos;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.NonNull;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.ydb.statement.YqlStatement;
import tech.ydb.yoj.repository.ydb.statement.YqlStatementParam;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public abstract class MultipleVarsYqlStatement<PARAMS, ENTITY extends Entity<ENTITY>, RESULT>
extends YqlStatement<PARAMS, ENTITY, RESULT> {
    public static final String listName = "$Input";

    public MultipleVarsYqlStatement(EntitySchema<ENTITY> schema, Schema<RESULT> resultSchema) {
        super(schema, resultSchema);
    }

    public MultipleVarsYqlStatement(EntitySchema<ENTITY> schema, Schema<RESULT> resultSchema, String tableName) {
        super(schema, resultSchema, tableName);
    }

    @Override
    protected String declarations() {
        String fieldPattern = this.escape("%s") + ":%s%s";
        String struct = this.getParams().stream().map(p -> String.format(fieldPattern, p.getName(), p.getType().getYqlTypeName(), p.isOptional() ? "?" : "")).collect(Collectors.joining(","));
        return this.getDeclaration(listName, "List<Struct<" + struct + ">>");
    }

    public List<YqlStatementParam> getParams() {
        return this.schema.flattenFields().stream().map(c -> new YqlStatementParam(YqlType.of(c), c.getName(), MultipleVarsYqlStatement.isOptional(c))).collect(Collectors.toList());
    }

    private static boolean isOptional(Schema.JavaField f) {
        return !EntityIdSchema.isIdField((Schema.JavaField)f);
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toQueryParameters(PARAMS params) {
        Collection yqlParams = this.getParams();
        ValueProtos.StructType.Builder structTypeBuilder = yqlParams.stream().map(p -> ValueProtos.StructMember.newBuilder().setName(p.getName()).setType(this.getYqlType(p.getType(), p.isOptional()))).collect(Collector.of(ValueProtos.StructType::newBuilder, ValueProtos.StructType.Builder::addMembers, (b1, b2) -> b1.addAllMembers((Iterable)b2.getMembersList()), new Collector.Characteristics[0]));
        ValueProtos.Value.Builder structBuilder = (ValueProtos.Value.Builder)(params instanceof Collection ? (Set<PARAMS>)params : Collections.singleton(params)).stream().map(this.flattenInputVariables()).map(arg_0 -> this.lambda$toQueryParameters$5((List)yqlParams, arg_0)).collect(itemsCollector);
        return Collections.singletonMap(listName, ValueProtos.TypedValue.newBuilder().setType(ValueProtos.Type.newBuilder().setListType(ValueProtos.ListType.newBuilder().setItem(ValueProtos.Type.newBuilder().setStructType(structTypeBuilder)).build()).build()).setValue(structBuilder).build());
    }

    protected abstract Function<PARAMS, Map<String, Object>> flattenInputVariables();

    protected String toDebugParams(PARAMS params) {
        if (params instanceof Collection) {
            Collection c = (Collection)params;
            return switch (c.size()) {
                case 0 -> "[]";
                case 1 -> "[" + c.iterator().next() + "]";
                default -> "[" + c.iterator().next() + ",...](" + c.size() + ")";
            };
        }
        return String.valueOf(params);
    }

    private /* synthetic */ ValueProtos.Value.Builder lambda$toQueryParameters$5(List yqlParams, Map fieldValues) {
        return (ValueProtos.Value.Builder)yqlParams.stream().map(p -> this.getYqlValue(p.getType(), fieldValues.get(p.getName()))).collect(itemsCollector);
    }

    public static abstract class Simple<PARAMS, ENTITY extends Entity<ENTITY>>
    extends MultipleVarsYqlStatement<PARAMS, ENTITY, ENTITY> {
        public Simple(@NonNull Class<ENTITY> type) {
            super(EntitySchema.of(type), EntitySchema.of(type));
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
        }

        public Simple(@NonNull Class<ENTITY> type, String tableName) {
            super(EntitySchema.of(type), EntitySchema.of(type), tableName);
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
        }
    }
}

