/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.readtable;

import com.google.protobuf.NullValue;
import com.yandex.ydb.ValueProtos;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.ydb.readtable.ReadTableMapper;
import tech.ydb.yoj.repository.ydb.statement.ResultSetReader;
import tech.ydb.yoj.repository.ydb.yql.YqlPrimitiveType;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public final class EntityIdKeyMapper<E extends Entity<E>, ID extends Entity.Id<E>, RESULT>
implements ReadTableMapper<ID, RESULT> {
    private final EntitySchema<E> srcSchema;
    private final Schema<RESULT> dstSchema;
    private final ResultSetReader<RESULT> resultSetReader;

    public EntityIdKeyMapper(EntitySchema<E> srcSchema, Schema<RESULT> dstSchema) {
        this.srcSchema = srcSchema;
        this.dstSchema = dstSchema;
        this.resultSetReader = new ResultSetReader<RESULT>(dstSchema);
    }

    @Override
    public List<ValueProtos.TypedValue> mapKey(ID id) {
        EntityIdSchema idSchema = this.srcSchema.getIdSchema();
        Map idComponents = idSchema.flatten(id);
        ArrayList<ValueProtos.TypedValue> idAsList = new ArrayList<ValueProtos.TypedValue>();
        for (Schema.JavaField idField : idSchema.flattenFields()) {
            Object idFieldValue = idComponents.get(idField.getName());
            idAsList.add(this.toTypedValue(new Schema.JavaFieldValue(idField, idFieldValue), true));
        }
        return idAsList;
    }

    @Override
    public List<String> getColumns() {
        return this.dstSchema.flattenFieldNames();
    }

    @Override
    public String getTableName(String tableSpace) {
        return tableSpace + this.srcSchema.getName();
    }

    @Override
    public RESULT mapResult(List<ValueProtos.Column> columnList, ValueProtos.Value value) {
        return this.resultSetReader.readResult(columnList, value);
    }

    private ValueProtos.TypedValue toTypedValue(Schema.JavaFieldValue value, boolean optional) {
        YqlPrimitiveType type = YqlType.of(value.getField());
        return ValueProtos.TypedValue.newBuilder().setType(this.getYqlType(type, optional)).setValue(this.getYqlValue(type, value.getValue())).build();
    }

    private ValueProtos.Type.Builder getYqlType(YqlType yqlType, boolean optional) {
        ValueProtos.Type.Builder ttype = yqlType.getYqlTypeBuilder();
        return !optional ? ttype : ValueProtos.Type.newBuilder().setOptionalType(ValueProtos.OptionalType.newBuilder().setItem(ttype));
    }

    private ValueProtos.Value.Builder getYqlValue(YqlType type, Object value) {
        return value == null ? ValueProtos.Value.newBuilder().setNullFlagValue(NullValue.NULL_VALUE) : type.toYql(value);
    }
}

