/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.rpc.grpc.GrpcTableRpc;
import com.yandex.ydb.table.stats.SessionPoolStats;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.exception.QueryInterruptedException;
import tech.ydb.yoj.repository.db.exception.RetryableException;
import tech.ydb.yoj.repository.db.exception.UnavailableException;
import tech.ydb.yoj.repository.ydb.YdbConfig;
import tech.ydb.yoj.repository.ydb.client.SessionManager;
import tech.ydb.yoj.repository.ydb.client.YdbValidator;
import tech.ydb.yoj.repository.ydb.metrics.GaugeSupplierCollector;
import tech.ydb.yoj.util.lang.Interrupts;

public class YdbSessionManager
implements SessionManager {
    private static final GaugeSupplierCollector sessionStatCollector = (GaugeSupplierCollector)((GaugeSupplierCollector.Builder)((GaugeSupplierCollector.Builder)((GaugeSupplierCollector.Builder)((GaugeSupplierCollector.Builder)((GaugeSupplierCollector.Builder)GaugeSupplierCollector.build().namespace("ydb")).subsystem("session_manager")).name("pool_stats")).help("Session pool statistics")).labelNames(new String[]{"type"})).register();
    private final YdbConfig config;
    private final GrpcTableRpc tableRpc;
    private TableClient tableClient;

    public YdbSessionManager(@NonNull YdbConfig config, GrpcTransport transport) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.tableRpc = GrpcTableRpc.useTransport((RpcTransport)transport);
        this.tableClient = this.createClient();
        ((GaugeSupplierCollector.Child)((GaugeSupplierCollector.Child)((GaugeSupplierCollector.Child)((GaugeSupplierCollector.Child)sessionStatCollector.labels(new String[]{"pending_acquire_count"})).supplier(() -> this.tableClient.getSessionPoolStats().getPendingAcquireCount()).labels(new String[]{"acquired_count"})).supplier(() -> this.tableClient.getSessionPoolStats().getAcquiredCount()).labels(new String[]{"idle_count"})).supplier(() -> this.tableClient.getSessionPoolStats().getIdleCount()).labels(new String[]{"disconnected_count"})).supplier(() -> this.tableClient.getSessionPoolStats().getDisconnectedCount());
    }

    private TableClient createClient() {
        return TableClient.newClient((TableRpc)this.tableRpc).keepQueryText(false).queryCacheSize(0).sessionCreationMaxRetries(this.config.getSessionCreationMaxRetries().intValue()).sessionKeepAliveTime(this.config.getSessionKeepAliveTime()).sessionMaxIdleTime(this.config.getSessionMaxIdleTime()).sessionPoolSize(this.config.getSessionPoolMin().intValue(), this.config.getSessionPoolMax().intValue()).build();
    }

    @Override
    public Session getSession() {
        CompletableFuture future = this.tableClient.getOrCreateSession(this.getSessionTimeout());
        try {
            Result result = (Result)future.get();
            YdbValidator.validate("session create", result.getCode(), result.toString());
            return (Session)result.expect("Can't get session");
        }
        catch (InterruptedException | CancellationException | CompletionException | ExecutionException e) {
            future.cancel(false);
            if (Interrupts.isThreadInterrupted((Throwable)e)) {
                Thread.currentThread().interrupt();
                throw new QueryInterruptedException("get session interrupted", (Throwable)e);
            }
            YdbValidator.checkGrpcContextStatus(e.getMessage(), e);
            throw new UnavailableException("DB is unavailable", (Throwable)e);
        }
    }

    private Duration getSessionTimeout() {
        Duration max = Duration.ofMinutes(5L);
        Duration configTimeout = this.config.getSessionCreationTimeout();
        return Duration.ZERO.equals(configTimeout) || configTimeout.compareTo(max) > 0 ? max : configTimeout;
    }

    @Override
    public void release(Session session) {
        session.release();
    }

    @Override
    public void warmup() {
        Session session = null;
        int maxRetrySessionCreateCount = 10;
        for (int i = 0; i < maxRetrySessionCreateCount; ++i) {
            try {
                session = this.getSession();
                break;
            }
            catch (RetryableException ex) {
                if (i != maxRetrySessionCreateCount - 1) continue;
                throw ex;
            }
        }
        if (session != null) {
            this.release(session);
        }
    }

    @Override
    public synchronized void invalidateAllSessions() {
        this.shutdown();
        this.tableClient = this.createClient();
    }

    @Override
    public void shutdown() {
        this.tableClient.close();
    }

    @Override
    public boolean healthCheck() {
        SessionPoolStats sessionPoolStats = this.tableClient.getSessionPoolStats();
        return sessionPoolStats.getIdleCount() > 0 || sessionPoolStats.getPendingAcquireCount() <= sessionPoolStats.getMaxSize();
    }

    @Generated
    public TableClient getTableClient() {
        return this.tableClient;
    }
}

