/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import com.google.protobuf.UnsafeByteOperations;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.values.DictType;
import com.yandex.ydb.table.values.ListType;
import com.yandex.ydb.table.values.OptionalType;
import com.yandex.ydb.table.values.PrimitiveType;
import com.yandex.ydb.table.values.StructType;
import com.yandex.ydb.table.values.TupleType;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.VoidType;
import com.yandex.ydb.table.values.VoidValue;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class YdbConverter {
    public static Value toSDK(ValueProtos.TypedValue typedValue) {
        return YdbConverter.toSDK(typedValue.getType(), typedValue.getValue());
    }

    public static Value toSDK(ValueProtos.Type type, ValueProtos.Value value) {
        return ProtoValue.fromPb((Type)YdbConverter.typeToSDK(type), (ValueProtos.Value)YdbConverter.toValueSDK(type, value));
    }

    private static ValueProtos.Value toValueSDK(ValueProtos.Type type, ValueProtos.Value value) {
        if (type.hasListType()) {
            return YdbConverter.convertProtoListValueToSDK(type, value.getItemsList());
        }
        if (type.hasStructType()) {
            return YdbConverter.convertProtoStructValueToSDK(type, value.getItemsList());
        }
        if (type.hasTupleType()) {
            return YdbConverter.convertProtoTupleValueToSDK(type, value.getItemsList());
        }
        if (type.hasOptionalType()) {
            return YdbConverter.convertOptionalProtoValueToSDK(type, value);
        }
        if (type.hasDictType()) {
            return YdbConverter.convertProtoDictValueToSDK(type, value);
        }
        if (type.getTypeCase() == ValueProtos.Type.TypeCase.VOID_TYPE) {
            return VoidValue.of().toPb();
        }
        return YdbConverter.convertProtoPrimitiveValueToSDK(type, value);
    }

    private static Type typeToSDK(ValueProtos.Type type) {
        if (type.hasListType()) {
            return YdbConverter.convertProtoListTypeToSDK(type);
        }
        if (type.hasStructType()) {
            return YdbConverter.convertProtoStructTypeToSDK(type);
        }
        if (type.hasTupleType()) {
            return YdbConverter.convertProtoTupleTypeToSDK(type);
        }
        if (type.hasOptionalType()) {
            return YdbConverter.convertOptionalProtoTypeToSDK(type);
        }
        if (type.hasDictType()) {
            return YdbConverter.convertProtoDictTypeToSDK(type);
        }
        if (type.getTypeCase() == ValueProtos.Type.TypeCase.VOID_TYPE) {
            return VoidType.of();
        }
        return YdbConverter.convertProtoPrimitiveTypeToSDK(type);
    }

    private static PrimitiveType convertProtoPrimitiveTypeToSDK(ValueProtos.Type type) {
        return switch (type.getTypeId()) {
            case ValueProtos.Type.PrimitiveTypeId.JSON -> PrimitiveType.json();
            case ValueProtos.Type.PrimitiveTypeId.JSON_DOCUMENT -> PrimitiveType.jsonDocument();
            case ValueProtos.Type.PrimitiveTypeId.BOOL -> PrimitiveType.bool();
            case ValueProtos.Type.PrimitiveTypeId.INT8 -> PrimitiveType.int8();
            case ValueProtos.Type.PrimitiveTypeId.UINT8 -> PrimitiveType.uint8();
            case ValueProtos.Type.PrimitiveTypeId.INT32 -> PrimitiveType.int32();
            case ValueProtos.Type.PrimitiveTypeId.UINT32 -> PrimitiveType.uint32();
            case ValueProtos.Type.PrimitiveTypeId.INT64 -> PrimitiveType.int64();
            case ValueProtos.Type.PrimitiveTypeId.UINT64 -> PrimitiveType.uint64();
            case ValueProtos.Type.PrimitiveTypeId.FLOAT -> PrimitiveType.float32();
            case ValueProtos.Type.PrimitiveTypeId.DOUBLE -> PrimitiveType.float64();
            case ValueProtos.Type.PrimitiveTypeId.STRING -> PrimitiveType.string();
            case ValueProtos.Type.PrimitiveTypeId.UTF8 -> PrimitiveType.utf8();
            case ValueProtos.Type.PrimitiveTypeId.TIMESTAMP -> PrimitiveType.timestamp();
            case ValueProtos.Type.PrimitiveTypeId.INTERVAL -> PrimitiveType.interval();
            default -> throw new IllegalArgumentException(type.getTypeId().name());
        };
    }

    private static ValueProtos.Value convertProtoPrimitiveValueToSDK(ValueProtos.Type type, ValueProtos.Value value) {
        return switch (type.getTypeId()) {
            case ValueProtos.Type.PrimitiveTypeId.JSON -> ProtoValue.json((String)value.getTextValue());
            case ValueProtos.Type.PrimitiveTypeId.JSON_DOCUMENT -> ProtoValue.jsonDocument((String)value.getTextValue());
            case ValueProtos.Type.PrimitiveTypeId.BOOL -> ProtoValue.bool((boolean)value.getBoolValue());
            case ValueProtos.Type.PrimitiveTypeId.INT8 -> ProtoValue.int8((byte)((byte)value.getInt32Value()));
            case ValueProtos.Type.PrimitiveTypeId.UINT8 -> ProtoValue.uint8((byte)((byte)value.getUint32Value()));
            case ValueProtos.Type.PrimitiveTypeId.INT32 -> ProtoValue.int32((int)value.getInt32Value());
            case ValueProtos.Type.PrimitiveTypeId.UINT32 -> ProtoValue.uint32((int)value.getUint32Value());
            case ValueProtos.Type.PrimitiveTypeId.INT64 -> ProtoValue.int64((long)value.getInt64Value());
            case ValueProtos.Type.PrimitiveTypeId.UINT64 -> ProtoValue.uint64((long)value.getUint64Value());
            case ValueProtos.Type.PrimitiveTypeId.FLOAT -> ProtoValue.float32((float)value.getFloatValue());
            case ValueProtos.Type.PrimitiveTypeId.DOUBLE -> ProtoValue.float64((double)value.getDoubleValue());
            case ValueProtos.Type.PrimitiveTypeId.STRING -> {
                if (value.getValueCase() == ValueProtos.Value.ValueCase.BYTES_VALUE) {
                    yield ProtoValue.bytes((ByteString)value.getBytesValue());
                }
                yield ProtoValue.string((String)value.getTextValue(), (Charset)StandardCharsets.UTF_8);
            }
            case ValueProtos.Type.PrimitiveTypeId.UTF8 -> ProtoValue.text((String)value.getTextValue());
            case ValueProtos.Type.PrimitiveTypeId.TIMESTAMP -> ProtoValue.timestamp((long)value.getUint64Value());
            case ValueProtos.Type.PrimitiveTypeId.INTERVAL -> ProtoValue.interval((long)value.getInt64Value());
            default -> throw new IllegalArgumentException(type.getTypeId() + ": " + value.toString());
        };
    }

    private static ValueProtos.Value convertProtoDictValueToSDK(ValueProtos.Type type, ValueProtos.Value value) {
        DictType dictType = YdbConverter.convertProtoDictTypeToSDK(type);
        if (value.getPairsList().isEmpty()) {
            return dictType.emptyValue().toPb();
        }
        Map<Value, Value> values = value.getPairsList().stream().collect(Collectors.toMap(pair -> YdbConverter.toSDK(type.getDictType().getKey(), pair.getKey()), pair -> YdbConverter.toSDK(type.getDictType().getPayload(), pair.getPayload())));
        return dictType.newValueOwn(values).toPb();
    }

    private static DictType convertProtoDictTypeToSDK(ValueProtos.Type type) {
        return DictType.of((Type)YdbConverter.typeToSDK(type.getDictType().getKey()), (Type)YdbConverter.typeToSDK(type.getDictType().getPayload()));
    }

    private static ValueProtos.Value convertOptionalProtoValueToSDK(ValueProtos.Type type, ValueProtos.Value value) {
        ValueProtos.Type itemType = type.getOptionalType().getItem();
        OptionalType optionalType = YdbConverter.convertOptionalProtoTypeToSDK(type);
        return value.getValueCase() == ValueProtos.Value.ValueCase.NULL_FLAG_VALUE ? optionalType.emptyValue().toPb() : optionalType.newValue(YdbConverter.toSDK(itemType, value)).toPb();
    }

    private static OptionalType convertOptionalProtoTypeToSDK(ValueProtos.Type type) {
        return OptionalType.of((Type)YdbConverter.typeToSDK(type.getOptionalType().getItem()));
    }

    private static ValueProtos.Value convertProtoStructValueToSDK(ValueProtos.Type type, List<ValueProtos.Value> items) {
        List members = type.getStructType().getMembersList();
        LinkedHashMap<String, Value> values = new LinkedHashMap<String, Value>();
        for (int i = 0; i < items.size(); ++i) {
            ValueProtos.StructMember member = (ValueProtos.StructMember)members.get(i);
            values.put(member.getName(), YdbConverter.toSDK(member.getType(), items.get(i)));
        }
        StructType structType = YdbConverter.convertProtoStructTypeToSDK(type);
        return structType.newValue(values).toPb();
    }

    private static StructType convertProtoStructTypeToSDK(ValueProtos.Type type) {
        LinkedHashMap<String, Type> types = new LinkedHashMap<String, Type>();
        for (ValueProtos.StructMember member : type.getStructType().getMembersList()) {
            types.put(member.getName(), YdbConverter.typeToSDK(member.getType()));
        }
        return StructType.of(types);
    }

    private static ValueProtos.Value convertProtoTupleValueToSDK(ValueProtos.Type type, List<ValueProtos.Value> items) {
        List members = type.getTupleType().getElementsList();
        ArrayList<Value> values = new ArrayList<Value>();
        for (int i = 0; i < items.size(); ++i) {
            values.add(YdbConverter.toSDK((ValueProtos.Type)members.get(i), items.get(i)));
        }
        return YdbConverter.convertProtoTupleTypeToSDK(type).newValue(values).toPb();
    }

    private static TupleType convertProtoTupleTypeToSDK(ValueProtos.Type type) {
        return TupleType.of(type.getTupleType().getElementsList().stream().map(YdbConverter::typeToSDK).collect(Collectors.toList()));
    }

    private static ValueProtos.Value convertProtoListValueToSDK(ValueProtos.Type type, List<ValueProtos.Value> items) {
        ListType listType = YdbConverter.convertProtoListTypeToSDK(type);
        if (items.isEmpty()) {
            return listType.emptyValue().toPb();
        }
        List values = items.stream().map(v -> YdbConverter.toSDK(type.getListType().getItem(), v)).collect(Collectors.toList());
        return listType.newValue(values).toPb();
    }

    private static ListType convertProtoListTypeToSDK(ValueProtos.Type type) {
        return ListType.of((Type)YdbConverter.typeToSDK(type.getListType().getItem()));
    }

    public static ValueProtos.Value.Builder convertValueToProto(ValueReader column) {
        ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
        ValueProtos.Type type = column.getType().toPb();
        if (type.hasOptionalType()) {
            if (!column.isOptionalItemPresent()) {
                return builder.setNullFlagValue(NullValue.NULL_VALUE);
            }
            type = type.getOptionalType().getItem();
        }
        if (type.hasListType()) {
            for (int i = 0; i < column.getListItemsCount(); ++i) {
                builder.addItems(YdbConverter.convertValueToProto(column.getListItem(i)));
            }
            return builder;
        }
        if (type.hasDictType()) {
            for (int i = 0; i < column.getDictItemsCount(); ++i) {
                builder.addPairs(ValueProtos.ValuePair.newBuilder().setKey(YdbConverter.convertValueToProto(column.getDictKey(i))).setPayload(YdbConverter.convertValueToProto(column.getDictValue(i))));
            }
            return builder;
        }
        return switch (type.getTypeId()) {
            case ValueProtos.Type.PrimitiveTypeId.JSON -> builder.setTextValue(column.getJson());
            case ValueProtos.Type.PrimitiveTypeId.JSON_DOCUMENT -> builder.setTextValue(column.getJsonDocument());
            case ValueProtos.Type.PrimitiveTypeId.BOOL -> builder.setBoolValue(column.getBool());
            case ValueProtos.Type.PrimitiveTypeId.INT8, ValueProtos.Type.PrimitiveTypeId.INT32, ValueProtos.Type.PrimitiveTypeId.INT16 -> builder.setInt32Value(column.getInt32());
            case ValueProtos.Type.PrimitiveTypeId.UINT8 -> builder.setUint32Value(column.getUint8());
            case ValueProtos.Type.PrimitiveTypeId.UINT16 -> builder.setUint32Value(column.getUint16());
            case ValueProtos.Type.PrimitiveTypeId.UINT32 -> builder.setUint32Value((int)column.getUint32());
            case ValueProtos.Type.PrimitiveTypeId.INT64 -> builder.setInt64Value(column.getInt64());
            case ValueProtos.Type.PrimitiveTypeId.UINT64 -> builder.setUint64Value(column.getUint64());
            case ValueProtos.Type.PrimitiveTypeId.FLOAT -> builder.setFloatValue(column.getFloat32());
            case ValueProtos.Type.PrimitiveTypeId.DOUBLE -> builder.setDoubleValue(column.getFloat64());
            case ValueProtos.Type.PrimitiveTypeId.STRING -> builder.setBytesValue(UnsafeByteOperations.unsafeWrap((byte[])column.getString()));
            case ValueProtos.Type.PrimitiveTypeId.UTF8 -> builder.setTextValue(column.getUtf8());
            case ValueProtos.Type.PrimitiveTypeId.TIMESTAMP -> builder.setUint64Value(column.getValue().toPb().getUint64Value());
            case ValueProtos.Type.PrimitiveTypeId.INTERVAL -> builder.setInt64Value(column.getValue().toPb().getInt64Value());
            default -> throw new IllegalArgumentException(column.getType().toPb().getTypeId() + ": " + column);
        };
    }

    public static Params convertToParams(Map<String, ValueProtos.TypedValue> queryParameters) {
        if (queryParameters.isEmpty()) {
            return Params.empty();
        }
        Map<String, Value> values = queryParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, o -> YdbConverter.toSDK(((ValueProtos.TypedValue)o.getValue()).getType(), ((ValueProtos.TypedValue)o.getValue()).getValue())));
        return Params.copyOf(values);
    }
}

