/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.result.ResultSetReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import tech.ydb.yoj.repository.ydb.client.YdbConverter;

public class ResultSetConverter {
    private final ResultSetReader resultSet;
    private List<ValueProtos.Column> columns = new ArrayList<ValueProtos.Column>();

    public ResultSetConverter(ResultSetReader resultSet) {
        this.resultSet = resultSet;
        if (resultSet.getRowCount() > 0) {
            this.columns = ResultSetConverter.getColumns(resultSet);
        }
    }

    public <RESULT> Stream<RESULT> stream(BiFunction<List<ValueProtos.Column>, ValueProtos.Value, RESULT> mapper) {
        return IntStream.range(0, this.resultSet.getRowCount()).mapToObj(this::buildValue).map(value -> mapper.apply(this.columns, (ValueProtos.Value)value));
    }

    private ValueProtos.Value buildValue(int rowIndex) {
        this.resultSet.setRowIndex(rowIndex);
        ValueProtos.Value.Builder value = ValueProtos.Value.newBuilder();
        for (int col = 0; col < this.columns.size(); ++col) {
            value.addItems(YdbConverter.convertValueToProto(this.resultSet.getColumn(col)));
        }
        return value.build();
    }

    private static List<ValueProtos.Column> getColumns(ResultSetReader resultSet) {
        resultSet.setRowIndex(0);
        ArrayList<ValueProtos.Column> result = new ArrayList<ValueProtos.Column>();
        for (int i = 0; i < resultSet.getColumnCount(); ++i) {
            result.add(ValueProtos.Column.newBuilder().setName(resultSet.getColumnName(i)).build());
        }
        return result;
    }
}

