/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.yql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.ydb.statement.PredicateStatement;
import tech.ydb.yoj.repository.ydb.yql.YqlPredicateParam;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;

public abstract class YqlPredicate
implements YqlStatementPart<YqlPredicate> {
    public static final String TYPE = "Predicate";
    private static final AtomicBoolean useLegacyIn = new AtomicBoolean(false);
    private static final AtomicBoolean useLegacyRel = new AtomicBoolean(false);

    public static void setUseLegacyIn(boolean useLegacyIn) {
        YqlPredicate.useLegacyIn.set(useLegacyIn);
    }

    public static void setUseLegacyRel(boolean useLegacyRel) {
        YqlPredicate.useLegacyRel.set(useLegacyRel);
    }

    public static FieldPredicateBuilder where(@NonNull String fieldPath) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        return new FieldPredicateBuilder(fieldPath, UnaryOperator.identity());
    }

    public static YqlPredicate not(@NonNull YqlPredicate pred) {
        if (pred == null) {
            throw new NullPointerException("pred is marked non-null but is null");
        }
        return pred.negate();
    }

    public static YqlPredicate and(@NonNull YqlPredicate first, YqlPredicate ... rest) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (rest == null) {
            throw new NullPointerException("rest is marked non-null but is null");
        }
        return YqlPredicate.and((Collection<YqlPredicate>)ImmutableList.builder().add((Object)first).add((Object[])rest).build());
    }

    public static YqlPredicate and(@NonNull Collection<YqlPredicate> predicates) {
        if (predicates == null) {
            throw new NullPointerException("predicates is marked non-null but is null");
        }
        return predicates.isEmpty() ? YqlPredicate.alwaysTrue() : new AndPredicate(predicates);
    }

    public static YqlPredicate or(@NonNull YqlPredicate first, YqlPredicate ... rest) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (rest == null) {
            throw new NullPointerException("rest is marked non-null but is null");
        }
        return YqlPredicate.or((Collection<YqlPredicate>)ImmutableList.builder().add((Object)first).add((Object[])rest).build());
    }

    public static YqlPredicate or(@NonNull Collection<YqlPredicate> predicates) {
        if (predicates == null) {
            throw new NullPointerException("predicates is marked non-null but is null");
        }
        return new OrPredicate(predicates);
    }

    private static YqlPredicate isNull(String fieldPath) {
        return new IsNullPredicate(fieldPath, IsNullPredicate.IsNullType.IS_NULL);
    }

    private static YqlPredicate isNotNull(String fieldPath) {
        return new IsNullPredicate(fieldPath, IsNullPredicate.IsNullType.IS_NOT_NULL);
    }

    @SafeVarargs
    public static <T> YqlPredicate in(@NonNull String fieldPath, @NonNull T possibleValue, T ... restOfPossibleValues) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (possibleValue == null) {
            throw new NullPointerException("possibleValue is marked non-null but is null");
        }
        if (restOfPossibleValues == null) {
            throw new NullPointerException("restOfPossibleValues is marked non-null but is null");
        }
        return YqlPredicate.in(fieldPath, ImmutableList.builder().add(possibleValue).add((Object[])restOfPossibleValues).build());
    }

    public static <T> YqlPredicate in(@NonNull String fieldPath, @NonNull @NonNull Collection<@NonNull ? extends T> values) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return values.isEmpty() ? YqlPredicate.alwaysFalse() : YqlPredicate.inPredicate(fieldPath, ImmutableList.copyOf(values), InType.IN);
    }

    @SafeVarargs
    private static <T> YqlPredicate notIn(@NonNull String fieldPath, @NonNull T possibleValue, T ... restOfPossibleValues) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (possibleValue == null) {
            throw new NullPointerException("possibleValue is marked non-null but is null");
        }
        if (restOfPossibleValues == null) {
            throw new NullPointerException("restOfPossibleValues is marked non-null but is null");
        }
        return YqlPredicate.notIn(fieldPath, ImmutableList.builder().add(possibleValue).add((Object[])restOfPossibleValues).build());
    }

    private static <T> YqlPredicate notIn(@NonNull String fieldPath, @NonNull @NonNull Collection<@NonNull ? extends T> values) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return values.isEmpty() ? YqlPredicate.alwaysTrue() : YqlPredicate.inPredicate(fieldPath, ImmutableList.copyOf(values), InType.NOT_IN);
    }

    public static <T> YqlPredicate eq(@NonNull String fieldPath, @Nullable T value) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        return value == null ? YqlPredicate.isNull(fieldPath) : YqlPredicate.relPredicate(Rel.EQ, fieldPath, value);
    }

    private static <T> YqlPredicate inPredicate(@NonNull String fieldPath, @NonNull Collection<T> values, @NonNull InType inType) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (inType == null) {
            throw new NullPointerException("inType is marked non-null but is null");
        }
        return useLegacyIn.get() ? new InLegacyPredicate<T>(fieldPath, values, inType) : new InPredicate<T>(fieldPath, values, inType);
    }

    public static <T> YqlPredicate neq(@NonNull String fieldPath, @Nullable T value) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        return value == null ? YqlPredicate.isNotNull(fieldPath) : YqlPredicate.relPredicate(Rel.NEQ, fieldPath, value);
    }

    public static <T> YqlPredicate lt(@NonNull String fieldPath, @NonNull T value) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return YqlPredicate.relPredicate(Rel.LT, fieldPath, value);
    }

    public static <T> YqlPredicate lte(@NonNull String fieldPath, @NonNull T value) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return YqlPredicate.relPredicate(Rel.LTE, fieldPath, value);
    }

    public static <T> YqlPredicate gt(@NonNull String fieldPath, @NonNull T value) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return YqlPredicate.relPredicate(Rel.GT, fieldPath, value);
    }

    public static <T> YqlPredicate gte(@NonNull String fieldPath, @NonNull T value) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return YqlPredicate.relPredicate(Rel.GTE, fieldPath, value);
    }

    @NonNull
    private static <T> YqlPredicate relPredicate(Rel rel, @NonNull String fieldPath, @NonNull T value) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return useLegacyRel.get() ? new LegacyRelPredicate<T>(rel, fieldPath, value) : new RelPredicate<T>(rel, fieldPath, value);
    }

    public static YqlPredicate like(@NonNull String fieldPath, @NonNull String value) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return YqlPredicate.like(fieldPath, value, null);
    }

    public static YqlPredicate like(@NonNull String fieldPath, @NonNull String value, @Nullable Character escape) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new LikePredicate<String>(LikePredicate.Type.LIKE, fieldPath, value, escape);
    }

    public static YqlPredicate notLike(@NonNull String fieldPath, @NonNull String value) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return YqlPredicate.notLike(fieldPath, value, null);
    }

    public static YqlPredicate notLike(@NonNull String fieldPath, @NonNull String value, @Nullable Character escape) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new LikePredicate<String>(LikePredicate.Type.NOT_LIKE, fieldPath, value, escape);
    }

    public static YqlPredicate alwaysTrue() {
        return TruePredicate.INSTANCE;
    }

    public static YqlPredicate alwaysFalse() {
        return FalsePredicate.INSTANCE;
    }

    @Override
    public abstract <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> var1);

    @Override
    public final String getType() {
        return TYPE;
    }

    @Override
    public final String getYqlPrefix() {
        return "WHERE ";
    }

    @Override
    public final int getPriority() {
        return 50;
    }

    @Override
    public final List<? extends YqlStatementPart<?>> combine(@NonNull List<? extends YqlPredicate> others) {
        if (others == null) {
            throw new NullPointerException("others is marked non-null but is null");
        }
        ImmutableList andPredicates = ImmutableList.builder().add((Object)this).addAll(others).build();
        return ImmutableList.of((Object)YqlPredicate.and((Collection<YqlPredicate>)andPredicates));
    }

    public Stream<YqlPredicateParam<?>> paramStream() {
        return Stream.empty();
    }

    public YqlPredicateParam<?> paramAt(int index) {
        return this.paramList().get(index);
    }

    public List<YqlPredicateParam<?>> paramList() {
        Spliterator sp = this.paramStream().spliterator();
        if (sp.getExactSizeIfKnown() == 0L) {
            return Collections.emptyList();
        }
        return this.paramStream().collect(Collectors.toList());
    }

    public YqlPredicate negate() {
        return new NotPredicate(this);
    }

    public YqlPredicate and(@NonNull YqlPredicate other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return new AndPredicate((Collection<YqlPredicate>)ImmutableList.of((Object)this, (Object)other));
    }

    public YqlPredicate or(@NonNull YqlPredicate other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return new OrPredicate((Collection<YqlPredicate>)ImmutableList.of((Object)this, (Object)other));
    }

    public FieldPredicateBuilder and(@NonNull String fieldPath) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        return new FieldPredicateBuilder(fieldPath, this::and);
    }

    public FieldPredicateBuilder or(@NonNull String fieldPath) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        return new FieldPredicateBuilder(fieldPath, this::or);
    }

    public static final class FieldPredicateBuilder {
        private final String fieldPath;
        private final UnaryOperator<YqlPredicate> finisher;

        @SafeVarargs
        public final <T> YqlPredicate in(@NonNull T possibleValue, T ... restOfPossibleValues) {
            if (possibleValue == null) {
                throw new NullPointerException("possibleValue is marked non-null but is null");
            }
            if (restOfPossibleValues == null) {
                throw new NullPointerException("restOfPossibleValues is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.in(this.fieldPath, possibleValue, restOfPossibleValues));
        }

        public <T> YqlPredicate in(@NonNull @NonNull Collection<@NonNull ? extends T> values) {
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.in(this.fieldPath, values));
        }

        @SafeVarargs
        public final <T> YqlPredicate notIn(@NonNull T possibleValue, T ... restOfPossibleValues) {
            if (possibleValue == null) {
                throw new NullPointerException("possibleValue is marked non-null but is null");
            }
            if (restOfPossibleValues == null) {
                throw new NullPointerException("restOfPossibleValues is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.notIn(this.fieldPath, possibleValue, restOfPossibleValues));
        }

        public <T> YqlPredicate notIn(@NonNull @NonNull Collection<@NonNull ? extends T> values) {
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.notIn(this.fieldPath, values));
        }

        public <T> YqlPredicate eq(@Nullable T value) {
            return (YqlPredicate)this.finisher.apply(YqlPredicate.eq(this.fieldPath, value));
        }

        public <T> YqlPredicate neq(@Nullable T value) {
            return (YqlPredicate)this.finisher.apply(YqlPredicate.neq(this.fieldPath, value));
        }

        public <T> YqlPredicate lt(@NonNull T value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.lt(this.fieldPath, value));
        }

        public <T> YqlPredicate lte(@NonNull T value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.lte(this.fieldPath, value));
        }

        public <T> YqlPredicate gt(@NonNull T value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.gt(this.fieldPath, value));
        }

        public <T> YqlPredicate gte(@NonNull T value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.gte(this.fieldPath, value));
        }

        public YqlPredicate like(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return this.like(value, null);
        }

        public YqlPredicate like(@NonNull String value, @Nullable Character escape) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.like(this.fieldPath, value, escape));
        }

        public YqlPredicate notLike(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return this.notLike(value, null);
        }

        public YqlPredicate notLike(@NonNull String value, @Nullable Character escape) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return (YqlPredicate)this.finisher.apply(YqlPredicate.notLike(this.fieldPath, value, escape));
        }

        public YqlPredicate isNull() {
            return (YqlPredicate)this.finisher.apply(YqlPredicate.isNull(this.fieldPath));
        }

        public YqlPredicate isNotNull() {
            return (YqlPredicate)this.finisher.apply(YqlPredicate.isNotNull(this.fieldPath));
        }

        @ConstructorProperties(value={"fieldPath", "finisher"})
        @Generated
        private FieldPredicateBuilder(String fieldPath, UnaryOperator<YqlPredicate> finisher) {
            this.fieldPath = fieldPath;
            this.finisher = finisher;
        }
    }

    private static final class AndPredicate
    extends YqlPredicate {
        private final List<YqlPredicate> predicates;

        private AndPredicate(Collection<YqlPredicate> predicates) {
            Preconditions.checkArgument((!predicates.isEmpty() ? 1 : 0) != 0, (Object)"Empty AND clause is disallowed");
            this.predicates = ImmutableList.copyOf(predicates);
        }

        @Override
        public Stream<YqlPredicateParam<?>> paramStream() {
            return this.predicates.stream().flatMap(YqlPredicate::paramStream);
        }

        @Override
        public YqlPredicate and(@NonNull YqlPredicate other) {
            if (other == null) {
                throw new NullPointerException("other is marked non-null but is null");
            }
            if (other instanceof AndPredicate) {
                return new AndPredicate((Collection<YqlPredicate>)ImmutableList.builder().addAll(this.predicates).addAll(((AndPredicate)other).predicates).build());
            }
            return new AndPredicate((Collection<YqlPredicate>)ImmutableList.builder().addAll(this.predicates).add((Object)other).build());
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            if (this.predicates.size() == 1) {
                return this.predicates.get(0).toYql(schema);
            }
            return this.predicates.stream().map(p -> String.format("(%s)", p.toYql(schema))).collect(Collectors.joining(" AND "));
        }

        public String toString() {
            return this.predicates.stream().map(p -> String.format("(%s)", p)).collect(Collectors.joining(" && "));
        }
    }

    private static final class OrPredicate
    extends YqlPredicate {
        private final List<YqlPredicate> predicates;

        private OrPredicate(Collection<YqlPredicate> predicates) {
            Preconditions.checkArgument((!predicates.isEmpty() ? 1 : 0) != 0, (Object)"Empty OR clause is disallowed");
            this.predicates = ImmutableList.copyOf(predicates);
        }

        @Override
        public Stream<YqlPredicateParam<?>> paramStream() {
            return this.predicates.stream().flatMap(YqlPredicate::paramStream);
        }

        @Override
        public YqlPredicate or(@NonNull YqlPredicate other) {
            if (other == null) {
                throw new NullPointerException("other is marked non-null but is null");
            }
            if (other instanceof OrPredicate) {
                return new OrPredicate((Collection<YqlPredicate>)ImmutableList.builder().addAll(this.predicates).addAll(((OrPredicate)other).predicates).build());
            }
            return new OrPredicate((Collection<YqlPredicate>)ImmutableList.builder().addAll(this.predicates).add((Object)other).build());
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            if (this.predicates.size() == 1) {
                return this.predicates.get(0).toYql(schema);
            }
            return this.predicates.stream().map(p -> String.format("(%s)", p.toYql(schema))).collect(Collectors.joining(" OR "));
        }

        public String toString() {
            return this.predicates.stream().map(p -> String.format("(%s)", p)).collect(Collectors.joining(" || "));
        }
    }

    static final class IsNullPredicate
    extends YqlPredicate {
        private final String fieldPath;
        private final IsNullType type;

        private IsNullPredicate(@NonNull String fieldPath, @NonNull IsNullType type) {
            if (fieldPath == null) {
                throw new NullPointerException("fieldPath is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.fieldPath = fieldPath;
            this.type = type;
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            return schema.getField(this.fieldPath).flatten().map(dbField -> String.format("`%s` %s", dbField.getName(), this.type.yql)).reduce(this.type::combine).orElseThrow(() -> new IllegalStateException("No DB fields found for " + this.fieldPath + " in " + schema.getName()));
        }

        @Override
        public YqlPredicate negate() {
            switch (this.type) {
                case IS_NULL: {
                    return new IsNullPredicate(this.fieldPath, IsNullType.IS_NOT_NULL);
                }
                case IS_NOT_NULL: {
                    return new IsNullPredicate(this.fieldPath, IsNullType.IS_NULL);
                }
            }
            throw new UnsupportedOperationException("This should never happen");
        }

        public String toString() {
            return String.format("%s %s", new Object[]{this.fieldPath, this.type});
        }

        static enum IsNullType {
            IS_NULL("IS NULL", (e1, e2) -> e1 + " AND " + e2),
            IS_NOT_NULL("IS NOT NULL", (e1, e2) -> e1 + " OR " + e2);

            private final String yql;
            private final BiFunction<String, String, String> exprCombiner;

            private IsNullType(String yql, BiFunction<String, String, String> exprCombiner) {
                this.yql = yql;
                this.exprCombiner = exprCombiner;
            }

            public final String combine(String result, String element) {
                return result == null ? element : this.exprCombiner.apply(result, element);
            }
        }
    }

    static enum InType {
        IN("DictContains", "IN"),
        NOT_IN("NOT DictContains", "NOT IN");

        private final String legacyYql;
        private final String yql;

        private InType(String legacyYql, String yql) {
            this.legacyYql = legacyYql;
            this.yql = yql;
        }
    }

    static enum Rel {
        EQ("=", "NEQ", (e1, e2) -> e1 + " AND " + e2),
        NEQ("<>", "EQ", (e1, e2) -> e1 + " OR " + e2),
        LT("<", "GTE"),
        GT(">", "LTE"),
        LTE("<=", "GT"),
        GTE(">=", "LT");

        private final String yql;
        private final String negation;
        private final BiFunction<String, String, String> exprCombiner;

        private Rel(String yql, String negation) {
            this(yql, negation, (_1, _2) -> {
                throw new UnsupportedOperationException(yql + " relation is not supported for complex fields");
            });
        }

        private Rel(String yql, String negation, BiFunction<String, String, String> exprCombiner) {
            this.yql = yql;
            this.negation = negation;
            this.exprCombiner = exprCombiner;
        }

        public final Rel negate() {
            return Rel.valueOf(this.negation);
        }

        @Deprecated
        public final String combine(String result, String element) {
            return result == null ? element : this.exprCombiner.apply(result, element);
        }
    }

    @Deprecated
    static final class InLegacyPredicate<V>
    extends YqlPredicate {
        private final YqlPredicateParam<Collection<V>> param;
        private final String fieldPath;
        private final InType inType;

        private InLegacyPredicate(@NonNull String fieldPath, @NonNull Collection<V> values, @NonNull InType inType) {
            this(YqlPredicateParam.of(fieldPath, values), fieldPath, inType);
            if (fieldPath == null) {
                throw new NullPointerException("fieldPath is marked non-null but is null");
            }
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            if (inType == null) {
                throw new NullPointerException("inType is marked non-null but is null");
            }
        }

        @Override
        public Stream<YqlPredicateParam<?>> paramStream() {
            return this.isEmpty() ? Stream.empty() : Stream.of(this.param);
        }

        @Override
        public List<YqlPredicateParam<?>> paramList() {
            return this.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.param);
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            if (this.isEmpty()) {
                return InLegacyPredicate.alwaysFalse().toString();
            }
            Schema.JavaField field = schema.getField(this.fieldPath);
            Preconditions.checkArgument((boolean)field.isFlat(), (Object)"Only flat fields are supported for IN/NOT IN queries");
            return String.format("%s(?, `%s`)", this.inType.legacyYql, field.getName());
        }

        @Override
        public YqlPredicate negate() {
            switch (this.inType) {
                case IN: {
                    return new InLegacyPredicate<V>(this.param, this.fieldPath, InType.NOT_IN);
                }
                case NOT_IN: {
                    return new InLegacyPredicate<V>(this.param, this.fieldPath, InType.IN);
                }
            }
            throw new UnsupportedOperationException("This should never happen");
        }

        private boolean isEmpty() {
            return this.param.getValue().isEmpty();
        }

        public String toString() {
            return String.format("%s %s (%s)", new Object[]{this.fieldPath, this.inType, this.param.getValue()});
        }

        @ConstructorProperties(value={"param", "fieldPath", "inType"})
        @Generated
        private InLegacyPredicate(YqlPredicateParam<Collection<V>> param, String fieldPath, InType inType) {
            this.param = param;
            this.fieldPath = fieldPath;
            this.inType = inType;
        }
    }

    static final class InPredicate<V>
    extends YqlPredicate {
        private final YqlPredicateParam<Collection<V>> param;
        private final String fieldPath;
        private final InType inType;

        private InPredicate(@NonNull String fieldPath, @NonNull Collection<V> values, @NonNull InType inType) {
            this(YqlPredicateParam.of(fieldPath, values, false, PredicateStatement.ComplexField.TUPLE, PredicateStatement.CollectionKind.LIST), fieldPath, inType);
            if (fieldPath == null) {
                throw new NullPointerException("fieldPath is marked non-null but is null");
            }
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            if (inType == null) {
                throw new NullPointerException("inType is marked non-null but is null");
            }
        }

        @Override
        public Stream<YqlPredicateParam<?>> paramStream() {
            return this.isEmpty() ? Stream.empty() : Stream.of(this.param);
        }

        @Override
        public List<YqlPredicateParam<?>> paramList() {
            return this.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.param);
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            if (this.isEmpty()) {
                return InPredicate.alwaysFalse().toString();
            }
            Schema.JavaField field = schema.getField(this.fieldPath);
            if (field.isFlat()) {
                return String.format("`%s` %s ?", field.getName(), this.inType.yql);
            }
            return String.format("(%s) %s ?", field.flatten().map(f -> "`" + f.getName() + "`").collect(Collectors.joining(", ")), this.inType.yql);
        }

        @Override
        public YqlPredicate negate() {
            switch (this.inType) {
                case IN: {
                    return new InPredicate<V>(this.param, this.fieldPath, InType.NOT_IN);
                }
                case NOT_IN: {
                    return new InPredicate<V>(this.param, this.fieldPath, InType.IN);
                }
            }
            throw new UnsupportedOperationException("This should never happen");
        }

        private boolean isEmpty() {
            return this.param.getValue().isEmpty();
        }

        public String toString() {
            return String.format("%s %s (%s)", new Object[]{this.fieldPath, this.inType, this.param.getValue()});
        }

        @ConstructorProperties(value={"param", "fieldPath", "inType"})
        @Generated
        private InPredicate(YqlPredicateParam<Collection<V>> param, String fieldPath, InType inType) {
            this.param = param;
            this.fieldPath = fieldPath;
            this.inType = inType;
        }
    }

    @Deprecated(forRemoval=true)
    static final class LegacyRelPredicate<V>
    extends YqlPredicate {
        private final Rel rel;
        private final String fieldPath;
        private final YqlPredicateParam<V> param;

        private LegacyRelPredicate(@NonNull Rel rel, @NonNull String fieldPath, @NonNull V value) {
            this(rel, fieldPath, YqlPredicateParam.of(fieldPath, value));
            if (rel == null) {
                throw new NullPointerException("rel is marked non-null but is null");
            }
            if (fieldPath == null) {
                throw new NullPointerException("fieldPath is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
        }

        private LegacyRelPredicate(Rel rel, String fieldPath, YqlPredicateParam<V> param) {
            this.rel = rel;
            this.fieldPath = fieldPath;
            this.param = param;
        }

        @Override
        public Stream<YqlPredicateParam<?>> paramStream() {
            return Stream.of(this.param);
        }

        @Override
        public List<YqlPredicateParam<?>> paramList() {
            return Collections.singletonList(this.param);
        }

        @Override
        public YqlPredicate negate() {
            return new LegacyRelPredicate<V>(this.rel.negate(), this.fieldPath, this.param);
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            Schema.JavaField field = schema.getField(this.fieldPath);
            return field.flatten().map(this::fieldToYql).reduce(this.rel::combine).orElseThrow(() -> new IllegalStateException("No DB fields found for " + this.fieldPath + " in " + schema.getName()));
        }

        private String fieldToYql(Schema.JavaField field) {
            return String.format("`%s` %s ?", field.getName(), this.rel.yql);
        }

        public String toString() {
            return String.format("%s %s %s", new Object[]{this.fieldPath, this.rel, this.param.getValue()});
        }
    }

    @Deprecated(forRemoval=true)
    static final class RelPredicate<V>
    extends YqlPredicate {
        private final Rel rel;
        private final String fieldPath;
        private final YqlPredicateParam<V> param;

        private RelPredicate(@NonNull Rel rel, @NonNull String fieldPath, @NonNull V value) {
            this(rel, fieldPath, YqlPredicateParam.of(fieldPath, value, false, PredicateStatement.ComplexField.TUPLE, PredicateStatement.CollectionKind.SINGLE));
            if (rel == null) {
                throw new NullPointerException("rel is marked non-null but is null");
            }
            if (fieldPath == null) {
                throw new NullPointerException("fieldPath is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
        }

        private RelPredicate(Rel rel, String fieldPath, YqlPredicateParam<V> param) {
            this.rel = rel;
            this.fieldPath = fieldPath;
            this.param = param;
        }

        @Override
        public Stream<YqlPredicateParam<?>> paramStream() {
            return Stream.of(this.param);
        }

        @Override
        public List<YqlPredicateParam<?>> paramList() {
            return Collections.singletonList(this.param);
        }

        @Override
        public YqlPredicate negate() {
            return new LegacyRelPredicate<V>(this.rel.negate(), this.fieldPath, this.param);
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            Schema.JavaField field = schema.getField(this.fieldPath);
            if (field.isFlat()) {
                return String.format("`%s` %s ?", field.getName(), this.rel.yql);
            }
            return String.format("(%s) %s ?", field.flatten().map(f -> "`" + f.getName() + "`").collect(Collectors.joining(", ")), this.rel.yql);
        }

        public String toString() {
            return String.format("%s %s %s", new Object[]{this.fieldPath, this.rel, this.param.getValue()});
        }
    }

    static final class LikePredicate<V>
    extends YqlPredicate {
        private final Type type;
        private final String fieldPath;
        private final YqlPredicateParam<V> param;
        private final Character escape;

        private LikePredicate(Type type, @NonNull String fieldPath, @NonNull V value, @Nullable Character escape) {
            this(type, fieldPath, YqlPredicateParam.of(fieldPath, value), LikePredicate.validateEscape(escape));
            if (fieldPath == null) {
                throw new NullPointerException("fieldPath is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
        }

        private static Character validateEscape(@Nullable Character escape) {
            Preconditions.checkArgument((escape == null || escape.charValue() != '\\' && escape.charValue() != '%' && escape.charValue() != '_' && escape.charValue() != '?' ? 1 : 0) != 0, (String)"Escape symbol not supported: '%s'", (Object)escape);
            return escape;
        }

        @Override
        public Stream<YqlPredicateParam<?>> paramStream() {
            return Stream.of(this.param);
        }

        @Override
        public List<YqlPredicateParam<?>> paramList() {
            return List.of(this.param);
        }

        @Override
        public YqlPredicate negate() {
            return new LikePredicate<V>(this.type.negate(), this.fieldPath, this.param, this.escape);
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            Schema.JavaField field = schema.getField(this.fieldPath).toFlatField();
            StringBuilder sb = new StringBuilder().append('`').append(field.getName()).append('`').append(' ').append(this.type.toYql()).append(' ').append('?');
            if (this.escape != null) {
                char strBoundaryChar = this.escape.charValue() == '\'' ? (char)'\"' : '\'';
                sb.append(" ESCAPE ").append(strBoundaryChar).append(this.escape).append(strBoundaryChar);
            }
            return sb.toString();
        }

        public String toString() {
            return String.format("%s %s %s%s", new Object[]{this.fieldPath, this.type, this.param.getValue(), this.escape == null ? "" : " ESCAPE " + this.escape});
        }

        @ConstructorProperties(value={"type", "fieldPath", "param", "escape"})
        @Generated
        public LikePredicate(Type type, String fieldPath, YqlPredicateParam<V> param, Character escape) {
            this.type = type;
            this.fieldPath = fieldPath;
            this.param = param;
            this.escape = escape;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Type {
            LIKE{

                @Override
                public String toYql() {
                    return "LIKE";
                }

                @Override
                public Type negate() {
                    return NOT_LIKE;
                }
            }
            ,
            NOT_LIKE{

                @Override
                public String toYql() {
                    return "NOT LIKE";
                }

                @Override
                public Type negate() {
                    return LIKE;
                }
            };


            public abstract String toYql();

            public abstract Type negate();
        }
    }

    private static final class TruePredicate
    extends YqlPredicate {
        private static final YqlPredicate INSTANCE = new TruePredicate();

        private TruePredicate() {
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            return "1 = 1";
        }

        @Override
        public YqlPredicate negate() {
            return TruePredicate.alwaysFalse();
        }

        public String toString() {
            return "alwaysTrue()";
        }
    }

    private static final class FalsePredicate
    extends YqlPredicate {
        private static final YqlPredicate INSTANCE = new FalsePredicate();

        private FalsePredicate() {
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            return "0 = 1";
        }

        @Override
        public YqlPredicate negate() {
            return FalsePredicate.alwaysTrue();
        }

        public String toString() {
            return "alwaysFalse()";
        }
    }

    private static final class NotPredicate
    extends YqlPredicate {
        private final YqlPredicate opposite;

        private NotPredicate(@NonNull YqlPredicate opposite) {
            if (opposite == null) {
                throw new NullPointerException("opposite is marked non-null but is null");
            }
            this.opposite = opposite;
        }

        @Override
        public Stream<YqlPredicateParam<?>> paramStream() {
            return this.opposite.paramStream();
        }

        @Override
        public List<YqlPredicateParam<?>> paramList() {
            return this.opposite.paramList();
        }

        @Override
        public YqlPredicate negate() {
            return this.opposite;
        }

        @Override
        public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            return String.format("NOT (%s)", this.opposite.toYql(schema));
        }

        public String toString() {
            return String.format("!(%s)", this.opposite);
        }
    }
}

