/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.compatibility;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.yoj.databind.DbType;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.ydb.YdbConfig;
import tech.ydb.yoj.repository.ydb.YdbRepository;
import tech.ydb.yoj.repository.ydb.client.YdbPaths;
import tech.ydb.yoj.repository.ydb.client.YdbSchemaOperations;

public final class YdbSchemaCompatibilityChecker {
    private static final Logger log = LoggerFactory.getLogger(YdbSchemaCompatibilityChecker.class);
    private final List<Class<? extends Entity>> entities;
    private final Config config;
    private final YdbRepository repository;
    private final YdbConfig repositoryConfig;
    private final List<String> shouldExecuteMessages = new ArrayList<String>();
    private final List<String> canExecuteMessages = new ArrayList<String>();
    private final List<String> incompatibleMessages = new ArrayList<String>();

    public YdbSchemaCompatibilityChecker(List<Class<? extends Entity>> entities, YdbRepository repository) {
        this(entities, repository, Config.DEFAULT);
    }

    public YdbSchemaCompatibilityChecker(List<Class<? extends Entity>> entities, YdbRepository repository, Config config) {
        this.entities = entities;
        this.config = config;
        this.repository = repository;
        this.repositoryConfig = this.repository.getConfig();
    }

    @VisibleForTesting
    public List<String> getShouldExecuteMessages() {
        return List.copyOf(this.shouldExecuteMessages);
    }

    @VisibleForTesting
    public List<String> getCanExecuteMessages() {
        return List.copyOf(this.canExecuteMessages);
    }

    public void run() {
        Object ddl;
        this.shouldExecuteMessages.clear();
        this.canExecuteMessages.clear();
        Map<String, YdbSchemaOperations.Table> tablesFromSource = this.generateSchemeFromCode();
        Set tableDirectories = tablesFromSource.keySet().stream().map(YdbPaths::tableDirectory).filter(Objects::nonNull).collect(Collectors.toSet());
        List<YdbSchemaOperations.Table> realTables = tableDirectories.stream().flatMap(path -> this.repository.getSchemaOperations().getTables((String)path).stream()).collect(Collectors.toList());
        this.checkCompatibility(tablesFromSource, realTables);
        if (this.canExecuteMessages.isEmpty() && this.shouldExecuteMessages.isEmpty() && this.incompatibleMessages.isEmpty()) {
            log.info("DB schema and code schema have no differences.");
            return;
        }
        if (!this.incompatibleMessages.isEmpty()) {
            log.error("DB schema and code have incompatible differences.\n{}", (Object)String.join((CharSequence)"\n", this.incompatibleMessages));
            throw new IllegalStateException("Code schema is not compatible with DB schema on " + this.getEndpoint());
        }
        if (!this.canExecuteMessages.isEmpty()) {
            Object object = ddl = this.config.useBuilderDDLSyntax ? String.join((CharSequence)",\n", this.canExecuteMessages) : "--!syntax_v1\n" + String.join((CharSequence)"\n", this.canExecuteMessages);
            BiConsumer<String, String> logConsumer = this.config.warnOnMinorDifferences ? (arg_0, arg_1) -> ((Logger)log).warn(arg_0, arg_1) : (arg_0, arg_1) -> ((Logger)log).info(arg_0, arg_1);
            logConsumer.accept("DB schema and code schema have minor differences.\nYou can execute below commands at any time after successful deployment of the code:\n{}", (String)ddl);
        }
        if (!this.shouldExecuteMessages.isEmpty()) {
            ddl = this.config.useBuilderDDLSyntax ? String.join((CharSequence)",\n", this.shouldExecuteMessages) : "--!syntax_v1\n" + String.join((CharSequence)"\n", this.shouldExecuteMessages);
            log.error("DB schema and code schema have major differences.\nYou must execute below commands before deploying the code:\n{}", ddl);
            throw new IllegalStateException("Code schema is not compatible with DB schema on " + this.getEndpoint());
        }
    }

    private String getEndpoint() {
        return Optional.ofNullable(this.repositoryConfig.getDiscoveryEndpoint()).orElse(Objects.toString(this.repositoryConfig.getEndpoints()));
    }

    private Map<String, YdbSchemaOperations.Table> generateSchemeFromCode() {
        return this.entities.stream().map(this::tableForEntity).collect(Collectors.toMap(YdbSchemaOperations.Table::getName, Function.identity()));
    }

    private YdbSchemaOperations.Table tableForEntity(Class<? extends Entity> c) {
        EntitySchema schema = EntitySchema.of(c);
        return this.repository.getSchemaOperations().describeTable(schema.getName(), schema.flattenFields(), schema.flattenId(), schema.getGlobalIndexes());
    }

    private void checkCompatibility(Map<String, YdbSchemaOperations.Table> tablesFromSource, List<YdbSchemaOperations.Table> actualTables) {
        Map actualTableMap = actualTables.stream().collect(Collectors.toMap(YdbSchemaOperations.Table::getName, Function.identity()));
        if (!this.config.onlyExistingTables) {
            actualTables.stream().filter(table -> !tablesFromSource.containsKey(table.getName())).filter(table -> !this.containsPrefix(table.getName(), this.config.skipExistingTablesPrefixes)).map(this::makeDeleteInstruction).forEach(this.canExecuteMessages::add);
            Consumer<String> tablesFromSourceAction = this.config.skipMissingTables ? this.canExecuteMessages::add : this.shouldExecuteMessages::add;
            tablesFromSource.values().stream().filter(table -> !actualTableMap.containsKey(table.getName())).map(this::makeCreateInstruction).forEach(tablesFromSourceAction);
        }
        Map changedTables = tablesFromSource.values().stream().filter(table -> actualTableMap.containsKey(table.getName())).filter(table -> {
            HashSet<YdbSchemaOperations.Column> requiredColumns;
            YdbSchemaOperations.Table actualTable = (YdbSchemaOperations.Table)actualTableMap.get(table.getName());
            HashSet<YdbSchemaOperations.Column> actualColumns = new HashSet<YdbSchemaOperations.Column>(actualTable.getColumns());
            return !actualColumns.equals(requiredColumns = new HashSet<YdbSchemaOperations.Column>(table.getColumns()));
        }).collect(Collectors.toMap(t -> (YdbSchemaOperations.Table)actualTableMap.get(t.getName()), Function.identity()));
        changedTables.forEach(this::makeMigrationTableInstruction);
        Map changedTableIndexes = tablesFromSource.values().stream().filter(table -> actualTableMap.containsKey(table.getName())).filter(table -> {
            HashSet<YdbSchemaOperations.Index> requiredIndexes;
            YdbSchemaOperations.Table actualTable = (YdbSchemaOperations.Table)actualTableMap.get(table.getName());
            HashSet<YdbSchemaOperations.Index> actualIndexes = new HashSet<YdbSchemaOperations.Index>(actualTable.getIndexes());
            return !actualIndexes.equals(requiredIndexes = new HashSet<YdbSchemaOperations.Index>(table.getIndexes()));
        }).collect(Collectors.toMap(t -> (YdbSchemaOperations.Table)actualTableMap.get(t.getName()), Function.identity()));
        changedTableIndexes.forEach(this::makeMigrationTableIndexInstructions);
    }

    private static String javaLiteral(String s) {
        return "\"" + StringEscapeUtils.escapeJava((String)s) + "\"";
    }

    private static String builderDDLTableNameLiteral(YdbSchemaOperations.Table table) {
        String name = table.getName();
        int lastSlashIdx = name.lastIndexOf("/");
        if (lastSlashIdx >= 0) {
            name = name.substring(lastSlashIdx + 1);
        }
        return YdbSchemaCompatibilityChecker.javaLiteral(name);
    }

    private String makeDeleteInstruction(YdbSchemaOperations.Table table) {
        if (this.config.useBuilderDDLSyntax) {
            return "DDLQuery.dropTable(" + YdbSchemaCompatibilityChecker.builderDDLTableNameLiteral(table) + ")";
        }
        return "DROP TABLE `" + table.getName() + "`;";
    }

    private String makeCreateInstruction(YdbSchemaOperations.Table table) {
        if (this.config.useBuilderDDLSyntax) {
            return "DDLQuery.createTable(" + YdbSchemaCompatibilityChecker.builderDDLTableNameLiteral(table) + ")\n\t.table(TableDescription.newBuilder()\n" + YdbSchemaCompatibilityChecker.builderDDLColumns(table) + YdbSchemaCompatibilityChecker.builderDDLPrimaryKey(table) + YdbSchemaCompatibilityChecker.builderDDLIndexes(table) + "\t\t.build())\n\t.build()";
        }
        return "CREATE TABLE `" + table.getName() + "` (\n" + YdbSchemaCompatibilityChecker.columns(table) + ",\n\tPRIMARY KEY(" + YdbSchemaCompatibilityChecker.primaryKey(table) + ")" + YdbSchemaCompatibilityChecker.indexes(table) + ");";
    }

    private String makeDropColumn(YdbSchemaOperations.Table table, YdbSchemaOperations.Column c) {
        if (this.config.useBuilderDDLSyntax) {
            return "DDLQuery.dropColumn(" + YdbSchemaCompatibilityChecker.builderDDLTableNameLiteral(table) + ", " + YdbSchemaCompatibilityChecker.javaLiteral(c.getName()) + ")";
        }
        return String.format("ALTER TABLE `%s` DROP COLUMN `%s`;", table.getName(), c.getName());
    }

    private String makeAddColumn(YdbSchemaOperations.Table table, YdbSchemaOperations.Column c) {
        if (this.config.useBuilderDDLSyntax) {
            return "DDLQuery.addColumn(" + YdbSchemaCompatibilityChecker.builderDDLTableNameLiteral(table) + ", " + YdbSchemaCompatibilityChecker.javaLiteral(c.getName()) + ", " + YdbSchemaCompatibilityChecker.typeToDDL(c.getType()) + ")";
        }
        return String.format("ALTER TABLE `%s` ADD COLUMN `%s` %s;", table.getName(), c.getName(), c.getType());
    }

    private static String builderDDLPrimaryKey(YdbSchemaOperations.Table table) {
        return "\t\t.setPrimaryKeys(" + table.getColumns().stream().filter(YdbSchemaOperations.Column::isPrimary).map(c -> YdbSchemaCompatibilityChecker.javaLiteral(c.getName())).collect(Collectors.joining(", ")) + ")\n";
    }

    private static String builderDDLIndexes(YdbSchemaOperations.Table table) {
        return table.getIndexes().stream().map(idx -> "\t\t.addGlobalIndex(" + YdbSchemaCompatibilityChecker.javaLiteral(idx.getName()) + ", " + idx.getColumns().stream().map(YdbSchemaCompatibilityChecker::javaLiteral).collect(Collectors.joining(", ")) + ")\n").collect(Collectors.joining(""));
    }

    private static String builderDDLColumns(YdbSchemaOperations.Table table) {
        return table.getColumns().stream().map(c -> "\t\t.addNullableColumn(" + YdbSchemaCompatibilityChecker.javaLiteral(c.getName()) + ", " + YdbSchemaCompatibilityChecker.typeToDDL(c.getType()) + ")\n").collect(Collectors.joining(""));
    }

    private static String typeToDDL(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Unknown db type: " + type);
        }
        return switch (DbType.valueOf((String)type)) {
            default -> throw new IncompatibleClassChangeError();
            case DbType.DEFAULT -> throw new IllegalArgumentException("Unknown db type: " + type);
            case DbType.BOOL -> "PrimitiveType.bool()";
            case DbType.UINT8 -> "PrimitiveType.uint8()";
            case DbType.INT32 -> "PrimitiveType.int32()";
            case DbType.UINT32 -> "PrimitiveType.uint32()";
            case DbType.INT64 -> "PrimitiveType.int64()";
            case DbType.UINT64 -> "PrimitiveType.uint64()";
            case DbType.FLOAT -> "PrimitiveType.float32()";
            case DbType.DOUBLE -> "PrimitiveType.float64()";
            case DbType.DATE -> "PrimitiveType.date()";
            case DbType.DATETIME -> "PrimitiveType.datetime()";
            case DbType.TIMESTAMP -> "PrimitiveType.timestamp()";
            case DbType.INTERVAL -> "PrimitiveType.interval()";
            case DbType.STRING -> "PrimitiveType.string()";
            case DbType.UTF8 -> "PrimitiveType.utf8()";
            case DbType.JSON -> "PrimitiveType.json()";
            case DbType.JSON_DOCUMENT -> "PrimitiveType.jsonDocument()";
        };
    }

    private static String columns(YdbSchemaOperations.Table table) {
        return table.getColumns().stream().map(c -> "\t`" + c.getName() + "` " + c.getType()).collect(Collectors.joining(",\n"));
    }

    private static String primaryKey(YdbSchemaOperations.Table table) {
        return table.getColumns().stream().filter(YdbSchemaOperations.Column::isPrimary).map(c -> "`" + c.getName() + "`").collect(Collectors.joining(","));
    }

    private static String indexes(YdbSchemaOperations.Table table) {
        List<YdbSchemaOperations.Index> indexes = table.getIndexes();
        if (indexes.isEmpty()) {
            return "\n";
        }
        return ",\n" + indexes.stream().map(idx -> "\tINDEX `" + idx.getName() + "` GLOBAL ON (" + YdbSchemaCompatibilityChecker.indexColumns(idx.getColumns()) + ")").collect(Collectors.joining(",\n")) + "\n";
    }

    private static String indexColumns(List<String> columns) {
        return columns.stream().map(c -> "`" + c + "`").collect(Collectors.joining(","));
    }

    private void makeMigrationTableInstruction(YdbSchemaOperations.Table from, YdbSchemaOperations.Table to) {
        Map toColumns = to.getColumns().stream().collect(Collectors.toMap(YdbSchemaOperations.Column::getName, Function.identity()));
        Map fromColumns = from.getColumns().stream().collect(Collectors.toMap(YdbSchemaOperations.Column::getName, Function.identity()));
        toColumns.values().stream().filter(s -> !fromColumns.containsKey(s.getName())).filter(YdbSchemaOperations.Column::isPrimary).map(column -> this.cannotBeAlteredMessage(from, (YdbSchemaOperations.Column)column, column.getName() + " is part of a table ID")).forEach(this.incompatibleMessages::add);
        toColumns.values().stream().filter(s -> !fromColumns.containsKey(s.getName())).filter(Predicate.not(YdbSchemaOperations.Column::isPrimary)).map(c -> this.makeAddColumn(from, (YdbSchemaOperations.Column)c)).forEach(this.shouldExecuteMessages::add);
        fromColumns.values().stream().filter(s -> !toColumns.containsKey(s.getName())).filter(YdbSchemaOperations.Column::isPrimary).map(column -> this.cannotBeAlteredMessage(from, (YdbSchemaOperations.Column)column, column.getName() + " is part of a table ID")).forEach(this.incompatibleMessages::add);
        fromColumns.values().stream().filter(s -> !toColumns.containsKey(s.getName())).filter(Predicate.not(YdbSchemaOperations.Column::isPrimary)).map(c -> this.makeDropColumn(from, (YdbSchemaOperations.Column)c)).forEach(this.canExecuteMessages::add);
        fromColumns.values().stream().filter(column -> toColumns.containsKey(column.getName())).filter(column -> !((YdbSchemaOperations.Column)toColumns.get(column.getName())).equals(column)).map(column -> this.cannotBeAlteredMessage(from, (YdbSchemaOperations.Column)column, this.columnDiff((YdbSchemaOperations.Column)column, (YdbSchemaOperations.Column)toColumns.get(column.getName())))).forEach(this.incompatibleMessages::add);
    }

    private String cannotBeAlteredMessage(YdbSchemaOperations.Table table, YdbSchemaOperations.Column column, String reason) {
        return "Altering column `" + table.getName() + "`." + column.getName() + " is impossible: " + reason + ".";
    }

    private void makeMigrationTableIndexInstructions(YdbSchemaOperations.Table from, YdbSchemaOperations.Table to) {
        Map toIndexes = to.getIndexes().stream().collect(Collectors.toMap(YdbSchemaOperations.Index::getName, Function.identity()));
        Map fromIndexes = from.getIndexes().stream().collect(Collectors.toMap(YdbSchemaOperations.Index::getName, Function.identity()));
        Function<YdbSchemaOperations.Index, String> createIndex = i -> String.format("ALTER TABLE `%s` ADD INDEX `%s` GLOBAL ON (%s);", to.getName(), i.getName(), i.getColumns().stream().map(c -> "`" + c + "`").collect(Collectors.joining(",")));
        Function<YdbSchemaOperations.Index, String> dropIndex = i -> String.format("ALTER TABLE `%s` DROP INDEX `%s`;", from.getName(), i.getName());
        toIndexes.values().stream().filter(i -> !fromIndexes.containsKey(i.getName())).map(createIndex).forEach(this.shouldExecuteMessages::add);
        fromIndexes.values().stream().filter(i -> !toIndexes.containsKey(i.getName())).map(dropIndex).forEach(this.canExecuteMessages::add);
        fromIndexes.values().stream().filter(i -> toIndexes.containsKey(i.getName())).filter(i -> !((YdbSchemaOperations.Index)toIndexes.get(i.getName())).equals(i)).map(i -> {
            YdbSchemaOperations.Index newIndex = (YdbSchemaOperations.Index)toIndexes.get(i.getName());
            return String.format("Altering index `%s`.%s is impossible: columns are changed: %s --> %s.%n%s%n%s", from.getName(), i.getName(), i.getColumns(), newIndex.getColumns(), dropIndex.apply((YdbSchemaOperations.Index)i), createIndex.apply(newIndex));
        }).forEach(this.shouldExecuteMessages::add);
    }

    private String columnDiff(YdbSchemaOperations.Column column, YdbSchemaOperations.Column newColumn) {
        if (column.isPrimary() != newColumn.isPrimary()) {
            return "primary_key changed: " + column.isPrimary() + " --> " + newColumn.isPrimary();
        }
        return "type changed: " + column.getType() + " --> " + newColumn.getType();
    }

    private boolean containsPrefix(String globalName, Set<String> prefixes) {
        if (prefixes.isEmpty()) {
            return false;
        }
        String tablespace = this.repository.getTablespace();
        Preconditions.checkState((boolean)globalName.startsWith(tablespace), (Object)"valid global name must start with repository tablespace");
        String realName = globalName.substring(tablespace.length());
        return prefixes.stream().filter(t -> realName.startsWith((String)t)).count() > 0L;
    }

    public static final class Config {
        public static final Config DEFAULT = Config.builder().build();
        private final boolean onlyExistingTables;
        private final boolean skipMissingTables;
        private final Set<String> skipExistingTablesPrefixes;
        private final boolean useBuilderDDLSyntax;
        private final boolean warnOnMinorDifferences;

        @Generated
        private static boolean $default$onlyExistingTables() {
            return false;
        }

        @Generated
        private static boolean $default$skipMissingTables() {
            return false;
        }

        @Generated
        private static Set<String> $default$skipExistingTablesPrefixes() {
            return Set.of();
        }

        @Generated
        private static boolean $default$useBuilderDDLSyntax() {
            return false;
        }

        @Generated
        private static boolean $default$warnOnMinorDifferences() {
            return true;
        }

        @Generated
        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        @Generated
        public boolean isOnlyExistingTables() {
            return this.onlyExistingTables;
        }

        @Generated
        public boolean isSkipMissingTables() {
            return this.skipMissingTables;
        }

        @Generated
        public Set<String> getSkipExistingTablesPrefixes() {
            return this.skipExistingTablesPrefixes;
        }

        @Generated
        public boolean isUseBuilderDDLSyntax() {
            return this.useBuilderDDLSyntax;
        }

        @Generated
        public boolean isWarnOnMinorDifferences() {
            return this.warnOnMinorDifferences;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (this.isOnlyExistingTables() != other.isOnlyExistingTables()) {
                return false;
            }
            if (this.isSkipMissingTables() != other.isSkipMissingTables()) {
                return false;
            }
            if (this.isUseBuilderDDLSyntax() != other.isUseBuilderDDLSyntax()) {
                return false;
            }
            if (this.isWarnOnMinorDifferences() != other.isWarnOnMinorDifferences()) {
                return false;
            }
            Set<String> this$skipExistingTablesPrefixes = this.getSkipExistingTablesPrefixes();
            Set<String> other$skipExistingTablesPrefixes = other.getSkipExistingTablesPrefixes();
            return !(this$skipExistingTablesPrefixes == null ? other$skipExistingTablesPrefixes != null : !((Object)this$skipExistingTablesPrefixes).equals(other$skipExistingTablesPrefixes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOnlyExistingTables() ? 79 : 97);
            result = result * 59 + (this.isSkipMissingTables() ? 79 : 97);
            result = result * 59 + (this.isUseBuilderDDLSyntax() ? 79 : 97);
            result = result * 59 + (this.isWarnOnMinorDifferences() ? 79 : 97);
            Set<String> $skipExistingTablesPrefixes = this.getSkipExistingTablesPrefixes();
            result = result * 59 + ($skipExistingTablesPrefixes == null ? 43 : ((Object)$skipExistingTablesPrefixes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YdbSchemaCompatibilityChecker.Config(onlyExistingTables=" + this.isOnlyExistingTables() + ", skipMissingTables=" + this.isSkipMissingTables() + ", skipExistingTablesPrefixes=" + this.getSkipExistingTablesPrefixes() + ", useBuilderDDLSyntax=" + this.isUseBuilderDDLSyntax() + ", warnOnMinorDifferences=" + this.isWarnOnMinorDifferences() + ")";
        }

        @Generated
        public Config withOnlyExistingTables(boolean onlyExistingTables) {
            return this.onlyExistingTables == onlyExistingTables ? this : new Config(onlyExistingTables, this.skipMissingTables, this.skipExistingTablesPrefixes, this.useBuilderDDLSyntax, this.warnOnMinorDifferences);
        }

        @Generated
        public Config withSkipMissingTables(boolean skipMissingTables) {
            return this.skipMissingTables == skipMissingTables ? this : new Config(this.onlyExistingTables, skipMissingTables, this.skipExistingTablesPrefixes, this.useBuilderDDLSyntax, this.warnOnMinorDifferences);
        }

        @Generated
        public Config withSkipExistingTablesPrefixes(Set<String> skipExistingTablesPrefixes) {
            return this.skipExistingTablesPrefixes == skipExistingTablesPrefixes ? this : new Config(this.onlyExistingTables, this.skipMissingTables, skipExistingTablesPrefixes, this.useBuilderDDLSyntax, this.warnOnMinorDifferences);
        }

        @Generated
        public Config withUseBuilderDDLSyntax(boolean useBuilderDDLSyntax) {
            return this.useBuilderDDLSyntax == useBuilderDDLSyntax ? this : new Config(this.onlyExistingTables, this.skipMissingTables, this.skipExistingTablesPrefixes, useBuilderDDLSyntax, this.warnOnMinorDifferences);
        }

        @Generated
        public Config withWarnOnMinorDifferences(boolean warnOnMinorDifferences) {
            return this.warnOnMinorDifferences == warnOnMinorDifferences ? this : new Config(this.onlyExistingTables, this.skipMissingTables, this.skipExistingTablesPrefixes, this.useBuilderDDLSyntax, warnOnMinorDifferences);
        }

        @ConstructorProperties(value={"onlyExistingTables", "skipMissingTables", "skipExistingTablesPrefixes", "useBuilderDDLSyntax", "warnOnMinorDifferences"})
        @Generated
        private Config(boolean onlyExistingTables, boolean skipMissingTables, Set<String> skipExistingTablesPrefixes, boolean useBuilderDDLSyntax, boolean warnOnMinorDifferences) {
            this.onlyExistingTables = onlyExistingTables;
            this.skipMissingTables = skipMissingTables;
            this.skipExistingTablesPrefixes = skipExistingTablesPrefixes;
            this.useBuilderDDLSyntax = useBuilderDDLSyntax;
            this.warnOnMinorDifferences = warnOnMinorDifferences;
        }

        @Generated
        public static class ConfigBuilder {
            @Generated
            private boolean onlyExistingTables$set;
            @Generated
            private boolean onlyExistingTables$value;
            @Generated
            private boolean skipMissingTables$set;
            @Generated
            private boolean skipMissingTables$value;
            @Generated
            private boolean skipExistingTablesPrefixes$set;
            @Generated
            private Set<String> skipExistingTablesPrefixes$value;
            @Generated
            private boolean useBuilderDDLSyntax$set;
            @Generated
            private boolean useBuilderDDLSyntax$value;
            @Generated
            private boolean warnOnMinorDifferences$set;
            @Generated
            private boolean warnOnMinorDifferences$value;

            @Generated
            ConfigBuilder() {
            }

            @Generated
            public ConfigBuilder onlyExistingTables(boolean onlyExistingTables) {
                this.onlyExistingTables$value = onlyExistingTables;
                this.onlyExistingTables$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder skipMissingTables(boolean skipMissingTables) {
                this.skipMissingTables$value = skipMissingTables;
                this.skipMissingTables$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder skipExistingTablesPrefixes(Set<String> skipExistingTablesPrefixes) {
                this.skipExistingTablesPrefixes$value = skipExistingTablesPrefixes;
                this.skipExistingTablesPrefixes$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder useBuilderDDLSyntax(boolean useBuilderDDLSyntax) {
                this.useBuilderDDLSyntax$value = useBuilderDDLSyntax;
                this.useBuilderDDLSyntax$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder warnOnMinorDifferences(boolean warnOnMinorDifferences) {
                this.warnOnMinorDifferences$value = warnOnMinorDifferences;
                this.warnOnMinorDifferences$set = true;
                return this;
            }

            @Generated
            public Config build() {
                boolean onlyExistingTables$value = this.onlyExistingTables$value;
                if (!this.onlyExistingTables$set) {
                    onlyExistingTables$value = Config.$default$onlyExistingTables();
                }
                boolean skipMissingTables$value = this.skipMissingTables$value;
                if (!this.skipMissingTables$set) {
                    skipMissingTables$value = Config.$default$skipMissingTables();
                }
                Set<String> skipExistingTablesPrefixes$value = this.skipExistingTablesPrefixes$value;
                if (!this.skipExistingTablesPrefixes$set) {
                    skipExistingTablesPrefixes$value = Config.$default$skipExistingTablesPrefixes();
                }
                boolean useBuilderDDLSyntax$value = this.useBuilderDDLSyntax$value;
                if (!this.useBuilderDDLSyntax$set) {
                    useBuilderDDLSyntax$value = Config.$default$useBuilderDDLSyntax();
                }
                boolean warnOnMinorDifferences$value = this.warnOnMinorDifferences$value;
                if (!this.warnOnMinorDifferences$set) {
                    warnOnMinorDifferences$value = Config.$default$warnOnMinorDifferences();
                }
                return new Config(onlyExistingTables$value, skipMissingTables$value, skipExistingTablesPrefixes$value, useBuilderDDLSyntax$value, warnOnMinorDifferences$value);
            }

            @Generated
            public String toString() {
                return "YdbSchemaCompatibilityChecker.Config.ConfigBuilder(onlyExistingTables$value=" + this.onlyExistingTables$value + ", skipMissingTables$value=" + this.skipMissingTables$value + ", skipExistingTablesPrefixes$value=" + this.skipExistingTablesPrefixes$value + ", useBuilderDDLSyntax$value=" + this.useBuilderDDLSyntax$value + ", warnOnMinorDifferences$value=" + this.warnOnMinorDifferences$value + ")";
            }
        }
    }
}

