/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client;

import com.yandex.ydb.core.Issue;
import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.result.ResultSetReader;
import io.grpc.Context;
import java.beans.ConstructorProperties;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.yoj.repository.db.exception.DeadlineExceededException;
import tech.ydb.yoj.repository.db.exception.EntityAlreadyExistsException;
import tech.ydb.yoj.repository.db.exception.OptimisticLockException;
import tech.ydb.yoj.repository.db.exception.QueryCancelledException;
import tech.ydb.yoj.repository.ydb.exception.BadSessionException;
import tech.ydb.yoj.repository.ydb.exception.ResultTruncatedException;
import tech.ydb.yoj.repository.ydb.exception.YdbComponentUnavailableException;
import tech.ydb.yoj.repository.ydb.exception.YdbOverloadedException;
import tech.ydb.yoj.repository.ydb.exception.YdbRepositoryException;
import tech.ydb.yoj.repository.ydb.exception.YdbSchemaException;
import tech.ydb.yoj.repository.ydb.exception.YdbUnauthenticatedException;
import tech.ydb.yoj.repository.ydb.exception.YdbUnauthorizedException;

public final class YdbValidator {
    private static final Logger log = LoggerFactory.getLogger(YdbValidator.class);

    private YdbValidator() {
    }

    public static void validate(String request, StatusCode statusCode, String response) {
        switch (statusCode) {
            case SUCCESS: {
                return;
            }
            case BAD_SESSION: 
            case SESSION_EXPIRED: 
            case NOT_FOUND: {
                throw new BadSessionException(response);
            }
            case ABORTED: {
                throw new OptimisticLockException(response);
            }
            case OVERLOADED: 
            case TIMEOUT: 
            case CANCELLED: 
            case CLIENT_RESOURCE_EXHAUSTED: 
            case CLIENT_DEADLINE_EXPIRED: 
            case CLIENT_DEADLINE_EXCEEDED: {
                YdbValidator.checkGrpcContextStatus(response, null);
                log.warn("Database is overloaded, but we still got a reply from the DB\nRequest: {}\nResponse: {}", (Object)request, (Object)response);
                throw new YdbOverloadedException((Object)request, (Object)response);
            }
            case CLIENT_CANCELLED: 
            case CLIENT_INTERNAL_ERROR: {
                YdbValidator.checkGrpcContextStatus(response, null);
                log.warn("Some database components are not available, but we still got a reply from the DB\nRequest: {}\nResponse: {}", (Object)request, (Object)response);
                throw new YdbComponentUnavailableException((Object)request, (Object)response);
            }
            case UNAVAILABLE: 
            case TRANSPORT_UNAVAILABLE: 
            case CLIENT_DISCOVERY_FAILED: 
            case CLIENT_LIMITS_REACHED: 
            case UNDETERMINED: 
            case SESSION_BUSY: 
            case PRECONDITION_FAILED: {
                log.warn("Some database components are not available, but we still got a reply from the DB\nRequest: {}\nResponse: {}", (Object)request, (Object)response);
                throw new YdbComponentUnavailableException((Object)request, (Object)response);
            }
            case CLIENT_UNAUTHENTICATED: {
                log.warn("Database said we are not authenticated\nRequest: {}\nResponse: {}", (Object)request, (Object)response);
                throw new YdbUnauthenticatedException((Object)request, (Object)response);
            }
            case UNAUTHORIZED: {
                log.warn("Database said we are not authorized\nRequest: {}\nResponse: {}", (Object)request, (Object)response);
                throw new YdbUnauthorizedException((Object)request, (Object)response);
            }
            case SCHEME_ERROR: {
                throw new YdbSchemaException("schema error", (Object)request, (Object)response);
            }
        }
        log.error("Bad response status\nRequest: {}\nResponse: {}", (Object)request, (Object)response);
        throw new YdbRepositoryException((Object)request, (Object)response);
    }

    public static void checkGrpcContextStatus(String errorMessage, @Nullable Throwable cause) {
        if (Context.current().getDeadline() != null && Context.current().getDeadline().isExpired()) {
            throw new DeadlineExceededException("DB query deadline exceeded. Response from DB: " + errorMessage, cause);
        }
        if (Context.current().isCancelled()) {
            throw new QueryCancelledException("DB query cancelled. Response from DB: " + errorMessage);
        }
    }

    private static boolean is(Issue[] issues, Function<Issue, Boolean> function) {
        for (Issue issue : issues) {
            if (!function.apply(issue).booleanValue() && (issue.getIssues().length <= 0 || !YdbValidator.is(issue.getIssues(), function))) continue;
            return true;
        }
        return false;
    }

    public static void validatePkConstraint(Issue[] issues) {
        if (YdbValidator.is(issues, IssueCode.CONSTRAINT_VIOLATION::matches)) {
            StringBuilder error = new StringBuilder();
            YdbValidator.is(issues, m -> {
                if (error.length() > 0) {
                    error.append(":");
                }
                error.append(m.getMessage());
                return false;
            });
            throw new EntityAlreadyExistsException("Entity already exists: " + error.toString());
        }
    }

    public static void validateTruncatedResults(String yql, DataQueryResult queryResult) {
        for (int i = 0; i < queryResult.getResultSetCount(); ++i) {
            YdbValidator.validateTruncatedResults(yql, queryResult.getResultSet(i));
        }
    }

    public static void validateTruncatedResults(String yql, ResultSetReader rs) {
        if (rs.isTruncated()) {
            String message = "Results was truncated to " + rs.getRowCount() + " elements";
            throw new ResultTruncatedException(message, (Object)yql, (Object)rs.getRowCount());
        }
    }

    private static enum IssueCode {
        CONSTRAINT_VIOLATION(2012);

        private final int issueCode;

        public boolean matches(Issue msg) {
            return msg.getCode() == this.issueCode;
        }

        @ConstructorProperties(value={"issueCode"})
        @Generated
        private IssueCode(int issueCode) {
            this.issueCode = issueCode;
        }
    }
}

