/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.query.DataQuery;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.ExplainDataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.result.ReadTableMeta;
import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.settings.AlterTableSettings;
import com.yandex.ydb.table.settings.BeginTxSettings;
import com.yandex.ydb.table.settings.BulkUpsertSettings;
import com.yandex.ydb.table.settings.CloseSessionSettings;
import com.yandex.ydb.table.settings.CommitTxSettings;
import com.yandex.ydb.table.settings.CopyTableSettings;
import com.yandex.ydb.table.settings.CreateTableSettings;
import com.yandex.ydb.table.settings.DescribeTableSettings;
import com.yandex.ydb.table.settings.DropTableSettings;
import com.yandex.ydb.table.settings.ExecuteDataQuerySettings;
import com.yandex.ydb.table.settings.ExecuteScanQuerySettings;
import com.yandex.ydb.table.settings.ExecuteSchemeQuerySettings;
import com.yandex.ydb.table.settings.ExplainDataQuerySettings;
import com.yandex.ydb.table.settings.KeepAliveSessionSettings;
import com.yandex.ydb.table.settings.PrepareDataQuerySettings;
import com.yandex.ydb.table.settings.ReadTableSettings;
import com.yandex.ydb.table.settings.RollbackTxSettings;
import com.yandex.ydb.table.transaction.Transaction;
import com.yandex.ydb.table.transaction.TransactionMode;
import com.yandex.ydb.table.transaction.TxControl;
import com.yandex.ydb.table.values.ListValue;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import tech.ydb.yoj.repository.ydb.client.QueryInterceptor;

public final class QueryInterceptingSession
implements Session {
    private final Session delegate;
    private final QueryInterceptor interceptor;

    private QueryInterceptingSession(Session delegate, QueryInterceptor interceptor) {
        this.delegate = delegate;
        this.interceptor = interceptor;
    }

    public static Function<Session, Session> makeWrapper(QueryInterceptor interceptor) {
        return s -> new QueryInterceptingSession((Session)s, interceptor);
    }

    public String getId() {
        return this.delegate.getId();
    }

    public CompletableFuture<Status> createTable(String path, TableDescription tableDescriptions, CreateTableSettings settings) {
        return this.delegate.createTable(path, tableDescriptions, settings);
    }

    public CompletableFuture<Status> dropTable(String path, DropTableSettings settings) {
        return this.delegate.dropTable(path, settings);
    }

    public CompletableFuture<Status> alterTable(String path, AlterTableSettings settings) {
        return this.delegate.alterTable(path, settings);
    }

    public CompletableFuture<Status> copyTable(String src, String dst, CopyTableSettings settings) {
        return this.delegate.copyTable(src, dst, settings);
    }

    public CompletableFuture<Result<TableDescription>> describeTable(String path, DescribeTableSettings settings) {
        return this.delegate.describeTable(path, settings);
    }

    public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        this.interceptor.beforeExecute(QueryType.DATA_QUERY, this.delegate, query);
        return this.delegate.executeDataQuery(query, txControl, params, settings);
    }

    public CompletableFuture<Result<DataQuery>> prepareDataQuery(String query, PrepareDataQuerySettings settings) {
        return this.delegate.prepareDataQuery(query, settings);
    }

    public CompletableFuture<Status> executeSchemeQuery(String query, ExecuteSchemeQuerySettings settings) {
        return this.delegate.executeSchemeQuery(query, settings);
    }

    public CompletableFuture<Result<ExplainDataQueryResult>> explainDataQuery(String query, ExplainDataQuerySettings settings) {
        return this.delegate.explainDataQuery(query, settings);
    }

    public CompletableFuture<Result<Transaction>> beginTransaction(TransactionMode transactionMode, BeginTxSettings settings) {
        return this.delegate.beginTransaction(transactionMode, settings);
    }

    public CompletableFuture<Status> commitTransaction(String txId, CommitTxSettings settings) {
        return this.delegate.commitTransaction(txId, settings);
    }

    public CompletableFuture<Status> rollbackTransaction(String txId, RollbackTxSettings settings) {
        return this.delegate.rollbackTransaction(txId, settings);
    }

    public CompletableFuture<Status> readTable(String tablePath, ReadTableSettings settings, BiConsumer<ResultSetReader, ReadTableMeta> fn) {
        return this.delegate.readTable(tablePath, settings, fn);
    }

    public CompletableFuture<Status> executeScanQuery(String query, Params params, ExecuteScanQuerySettings settings, Consumer<ResultSetReader> fn) {
        this.interceptor.beforeExecute(QueryType.SCAN_QUERY, this.delegate, query);
        return this.delegate.executeScanQuery(query, params, settings, fn);
    }

    public CompletableFuture<Result<SessionStatus>> keepAlive(KeepAliveSessionSettings settings) {
        return this.delegate.keepAlive(settings);
    }

    public CompletableFuture<Status> executeBulkUpsert(String tablePath, ListValue rows, BulkUpsertSettings settings) {
        return this.delegate.executeBulkUpsert(tablePath, rows, settings);
    }

    public void invalidateQueryCache() {
        this.delegate.invalidateQueryCache();
    }

    public boolean release() {
        return this.delegate.release();
    }

    public CompletableFuture<Status> close(CloseSessionSettings settings) {
        return this.delegate.close(settings);
    }

    public static enum QueryType {
        DATA_QUERY,
        SCAN_QUERY;

    }
}

