/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Range;

public final class InMemoryTxLockWatcher {
    public static final InMemoryTxLockWatcher NO_LOCKS = new InMemoryTxLockWatcher(Map.of(), Map.of());
    private final Map<Class<?>, Set<Entity.Id<?>>> readRows;
    private final Map<Class<?>, List<Range<?>>> readRanges;

    public InMemoryTxLockWatcher() {
        this(new HashMap(), new HashMap());
    }

    public <T extends Entity<T>> void markRowRead(Class<T> type, Entity.Id<T> id) {
        this.readRows.computeIfAbsent(type, __ -> new HashSet()).add(id);
    }

    public <T extends Entity<T>, ID extends Entity.Id<T>> void markRangeRead(Class<T> type, Range<ID> range) {
        this.readRanges.computeIfAbsent(type, __ -> new ArrayList()).add(range);
    }

    public <T extends Entity<T>, ID extends Entity.Id<T>> void markRangeRead(Class<T> type, Map<String, Object> map) {
        Range range = Range.create((EntityIdSchema)EntitySchema.of(type).getIdSchema(), map);
        this.markRangeRead(type, range);
    }

    public <T extends Entity<T>, ID extends Entity.Id<T>> void markTableRead(Class<T> type) {
        Range range = Range.create((EntityIdSchema)EntitySchema.of(type).getIdSchema(), Map.of());
        this.markRangeRead(type, range);
    }

    public <T extends Entity<T>> Set<Entity.Id<T>> getReadRows(Class<T> type) {
        Set<Entity.Id<T>> lockedRows = this.readRows.getOrDefault(type, Set.of());
        return lockedRows;
    }

    public <T extends Entity<T>> List<Range<Entity.Id<T>>> getReadRanges(Class<T> type) {
        List<Range<Entity.Id<T>>> lockedRanges = this.readRanges.getOrDefault(type, List.of());
        return lockedRanges;
    }

    @ConstructorProperties(value={"readRows", "readRanges"})
    @Generated
    private InMemoryTxLockWatcher(Map<Class<?>, Set<Entity.Id<?>>> readRows, Map<Class<?>, List<Range<?>>> readRanges) {
        this.readRows = readRows;
        this.readRanges = readRanges;
    }
}

