/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.test.inmemory.InMemoryDataShard;
import tech.ydb.yoj.repository.test.inmemory.InMemoryRepositoryException;
import tech.ydb.yoj.repository.test.inmemory.InMemoryTxLockWatcher;
import tech.ydb.yoj.repository.test.inmemory.ReadOnlyTxDataShard;
import tech.ydb.yoj.repository.test.inmemory.TxDataShardImpl;
import tech.ydb.yoj.repository.test.inmemory.WriteTxDataShard;

final class InMemoryStorage {
    private final Map<Class<?>, InMemoryDataShard<?>> shards;
    private final Map<Long, Set<Class<?>>> uncommited = new HashMap();
    private long currentVersion;

    public InMemoryStorage() {
        this(0L, new HashMap());
    }

    private InMemoryStorage(long version, Map<Class<?>, InMemoryDataShard<?>> shards) {
        this.shards = shards;
        this.currentVersion = version;
    }

    public synchronized long getCurrentVersion() {
        return this.currentVersion;
    }

    public synchronized InMemoryStorage createSnapshot() {
        HashMap snapshotDb = new HashMap();
        for (Map.Entry<Class<?>, InMemoryDataShard<?>> entry : this.shards.entrySet()) {
            snapshotDb.put(entry.getKey(), entry.getValue().createSnapshot());
        }
        return new InMemoryStorage(this.currentVersion, snapshotDb);
    }

    public synchronized void commit(long txId, long version, InMemoryTxLockWatcher watcher) {
        if (!this.uncommited.containsKey(txId)) {
            return;
        }
        for (InMemoryDataShard<?> shard : this.shards.values()) {
            shard.checkLocks(version, watcher);
        }
        ++this.currentVersion;
        Set<Class<?>> uncommitedTables = this.uncommited.remove(txId);
        for (Class<?> type : uncommitedTables) {
            this.shards.get(type).commit(txId, this.currentVersion);
        }
    }

    public synchronized void rollback(long txId) {
        Set<Class<?>> uncommitedTables = this.uncommited.remove(txId);
        if (uncommitedTables == null) {
            return;
        }
        for (Class<?> type : uncommitedTables) {
            this.shards.get(type).rollback(txId);
        }
    }

    public synchronized <T extends Entity<T>> WriteTxDataShard<T> getWriteTxDataShard(Class<T> type, long txId, long version) {
        this.uncommited.computeIfAbsent(txId, __ -> new HashSet()).add(type);
        return this.getTxDataShard(type, txId, version, InMemoryTxLockWatcher.NO_LOCKS);
    }

    public synchronized <T extends Entity<T>> ReadOnlyTxDataShard<T> getReadOnlyTxDataShard(Class<T> type, long txId, long version, InMemoryTxLockWatcher watcher) {
        return this.getTxDataShard(type, txId, version, watcher);
    }

    private <T extends Entity<T>> TxDataShardImpl<T> getTxDataShard(Class<T> type, long txId, long version, InMemoryTxLockWatcher watcher) {
        InMemoryDataShard<?> shard = this.shards.get(type);
        if (shard == null) {
            throw new InMemoryRepositoryException("Table is not created: " + type.getSimpleName());
        }
        return new TxDataShardImpl(shard, txId, version, watcher);
    }

    public synchronized void dropDb() {
        this.shards.clear();
    }

    public synchronized Set<Class<? extends Entity<?>>> tables() {
        return this.shards.keySet();
    }

    public synchronized boolean containsTable(Class<?> type) {
        return this.shards.containsKey(type);
    }

    public synchronized <T extends Entity<T>> void createTable(Class<T> type) {
        if (this.containsTable(type)) {
            return;
        }
        this.shards.put(type, new InMemoryDataShard<T>(type));
    }

    public synchronized boolean dropTable(Class<?> type) {
        if (!this.containsTable(type)) {
            return false;
        }
        this.shards.remove(type);
        return true;
    }
}

