/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import tech.ydb.yoj.repository.test.inmemory.Columns;

final class InMemoryEntityLine {
    private final List<Versioned> versions;
    private final Map<Long, Columns> uncommited = new HashMap<Long, Columns>();

    private InMemoryEntityLine(List<Versioned> versions) {
        this.versions = versions;
    }

    public InMemoryEntityLine() {
        this(new ArrayList<Versioned>());
    }

    public InMemoryEntityLine createSnapshot() {
        return new InMemoryEntityLine(new ArrayList<Versioned>(this.versions));
    }

    public void commit(long txId, long version) {
        Columns uncommitedColumns = this.uncommited.remove(txId);
        if (uncommitedColumns == null) {
            return;
        }
        this.versions.add(new Versioned(version, uncommitedColumns));
    }

    public void rollback(long txId) {
        this.uncommited.remove(txId);
    }

    @Nullable
    public Columns get(long txId, long version) {
        Columns columns = this.getColumns(txId, version);
        return columns != Columns.EMPTY ? columns : null;
    }

    public void put(long txId, Columns columns) {
        this.uncommited.put(txId, columns);
    }

    public void remove(long txId) {
        this.uncommited.put(txId, Columns.EMPTY);
    }

    private Columns getColumns(long txId, long version) {
        Columns uncommitedColumns = this.uncommited.get(txId);
        if (uncommitedColumns != null) {
            return uncommitedColumns;
        }
        for (int i = this.versions.size() - 1; i >= 0; --i) {
            Versioned versioned = this.versions.get(i);
            if (versioned.version() > version) continue;
            return versioned.columns();
        }
        return Columns.EMPTY;
    }

    public boolean hasYounger(long version) {
        if (this.versions.isEmpty()) {
            return false;
        }
        return version < this.versions.get(this.versions.size() - 1).version();
    }

    private record Versioned(long version, Columns columns) {
    }
}

