/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory.legacy;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.factory.Maps;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.db.ViewSchema;
import tech.ydb.yoj.repository.db.exception.EntityAlreadyExistsException;
import tech.ydb.yoj.repository.db.exception.OptimisticLockException;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyColumns;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyInMemoryRepositoryException;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyInMemoryTxLockWatcher;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyReadOnlyTxDataShard;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyTxDataShardImpl;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyWriteTxDataShard;

final class LegacyInMemoryStorage {
    private volatile ImmutableMap<Class<?>, ImmutableMap<Object, LegacyColumns>> db;

    public LegacyInMemoryStorage() {
        this(Maps.immutable.empty());
    }

    private LegacyInMemoryStorage(ImmutableMap<Class<?>, ImmutableMap<Object, LegacyColumns>> db) {
        this.db = db;
    }

    private <R, T extends Entity<T>> R get(LegacyInMemoryTxLockWatcher watcher, Class<T> type, java.util.function.Function<ImmutableMap<Object, LegacyColumns>, R> func) {
        this.checkImpl(watcher);
        return func.apply(this.map(type));
    }

    public synchronized void safeRun(Runnable runnable) {
        ImmutableMap<Class<?>, ImmutableMap<Object, LegacyColumns>> before = this.db;
        try {
            runnable.run();
        }
        catch (Throwable t) {
            this.db = before;
            throw t;
        }
    }

    public synchronized void dropDb() {
        this.db = Maps.immutable.empty();
    }

    public synchronized Set<Class<? extends Entity<?>>> tables() {
        return this.db.keysView().toSet();
    }

    public synchronized boolean containsTable(Class<?> type) {
        return this.db.containsKey(type);
    }

    public synchronized void createTable(Class<?> type) {
        if (this.containsTable(type)) {
            return;
        }
        this.db = this.db.newWithKeyValue(type, (Object)Maps.immutable.empty());
    }

    public synchronized boolean dropTable(Class<?> type) {
        if (!this.containsTable(type)) {
            return false;
        }
        this.db = this.db.newWithoutKey(type);
        return true;
    }

    public synchronized <T extends Entity<T>> T find(LegacyInMemoryTxLockWatcher watcher, Class<T> type, Entity.Id<T> id) {
        return (T)this.get(watcher, type, map -> {
            LegacyColumns columns = (LegacyColumns)map.get((Object)id);
            return columns != null ? (Entity)columns.toSchema(EntitySchema.of((Class)type)) : null;
        });
    }

    public synchronized <T extends Entity<T>, V extends Table.View> V findView(LegacyInMemoryTxLockWatcher watcher, Class<T> type, Entity.Id<T> id, Class<V> viewType) {
        return (V)this.get(watcher, type, map -> {
            LegacyColumns columns = (LegacyColumns)map.get((Object)id);
            return columns != null ? (Table.View)columns.toSchema(ViewSchema.of((Class)viewType)) : null;
        });
    }

    public synchronized <T extends Entity<T>> List<T> findAll(LegacyInMemoryTxLockWatcher watcher, Class<T> type) {
        return (List)this.get(watcher, type, map -> map.valuesView().toList().collect((Function & Serializable)columns -> (Entity)columns.toSchema(EntitySchema.of((Class)type))).sortThis(EntityIdSchema.SORT_ENTITY_BY_ID));
    }

    public synchronized <T extends Entity<T>> void insert(Class<T> type, T entity) {
        this.set(type, map -> {
            if (map.containsKey((Object)entity.getId())) {
                throw new EntityAlreadyExistsException("Entity " + entity.getId() + " already exists");
            }
            return map.newWithKeyValue((Object)entity.getId(), (Object)LegacyColumns.fromEntity(EntitySchema.of((Class)type), entity));
        });
    }

    public synchronized <T extends Entity<T>> void save(Class<T> type, T entity) {
        this.set(type, map -> map.newWithKeyValue((Object)entity.getId(), (Object)LegacyColumns.fromEntity(EntitySchema.of((Class)type), entity)));
    }

    public synchronized <T extends Entity<T>> void delete(Class<T> type, Entity.Id<T> id) {
        this.set(type, map -> map.newWithoutKey((Object)id));
    }

    public synchronized <T extends Entity<T>> void deleteAll(Class<T> type) {
        this.set(type, map -> Maps.immutable.empty());
    }

    private synchronized <T extends Entity<T>> void set(Class<T> type, UnaryOperator<ImmutableMap<Object, LegacyColumns>> modify) {
        this.db = this.db.newWithKeyValue(type, (Object)((ImmutableMap)modify.apply(this.map(type))));
    }

    private synchronized <T extends Entity<T>> ImmutableMap<Object, LegacyColumns> map(Class<T> type) {
        ImmutableMap map = (ImmutableMap)this.db.get(type);
        if (map == null) {
            throw new LegacyInMemoryRepositoryException("Table is not created: " + type.getSimpleName());
        }
        return map;
    }

    public synchronized <T extends Entity<T>> LegacyWriteTxDataShard<T> getWriteTxDataShard(Class<T> type, LegacyInMemoryTxLockWatcher watcher) {
        return this.getTxDataShard(type, watcher);
    }

    public synchronized <T extends Entity<T>> LegacyReadOnlyTxDataShard<T> getReadOnlyTxDataShard(Class<T> type, LegacyInMemoryTxLockWatcher watcher) {
        return this.getTxDataShard(type, watcher);
    }

    private <T extends Entity<T>> LegacyTxDataShardImpl<T> getTxDataShard(Class<T> type, LegacyInMemoryTxLockWatcher watcher) {
        ImmutableMap shard = (ImmutableMap)this.db.get(type);
        if (shard == null) {
            throw new LegacyInMemoryRepositoryException("Table is not created: " + type.getSimpleName());
        }
        return new LegacyTxDataShardImpl<T>(this, type, watcher);
    }

    public synchronized void checkImpl(LegacyInMemoryTxLockWatcher watcher) {
        if (watcher.getStarted() == null) {
            watcher.setStarted(new LegacyInMemoryStorage(this.db));
            return;
        }
        ImmutableMap<Class<?>, ImmutableMap<Object, LegacyColumns>> started = watcher.getStarted().db;
        watcher.getReadRows().forEach((c, rows) -> rows.forEach(id -> {
            if (!Objects.equals(((ImmutableMap)started.get(c)).get(id), ((ImmutableMap)this.db.get(c)).get(id))) {
                throw new OptimisticLockException("Row lock failed " + id);
            }
        }));
        watcher.getReadRanges().forEach((c, ranges) -> ranges.forEach(range -> {
            Procedure & Serializable checkIdIsNotLocked = (Procedure & Serializable)id -> {
                if (!Objects.equals(((ImmutableMap)started.get(c)).get(id), ((ImmutableMap)this.db.get(c)).get(id)) && range.contains((Entity.Id)id)) {
                    throw new OptimisticLockException("Range lock failed " + id + " in range " + range);
                }
            };
            ((ImmutableMap)started.get(c)).keysView().forEach((Procedure)checkIdIsNotLocked);
            ((ImmutableMap)this.db.get(c)).keysView().forEach((Procedure)checkIdIsNotLocked);
        }));
    }

    public synchronized LegacyInMemoryStorage createSnapshot() {
        return new LegacyInMemoryStorage(this.db);
    }
}

