/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory.legacy;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import tech.ydb.yoj.repository.BaseDb;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.RepositoryTransaction;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.db.TxOptions;
import tech.ydb.yoj.repository.db.cache.TransactionLocal;
import tech.ydb.yoj.repository.db.exception.IllegalTransactionIsolationLevelException;
import tech.ydb.yoj.repository.db.exception.IllegalTransactionScanException;
import tech.ydb.yoj.repository.test.inmemory.InMemoryTable;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyInMemoryRepository;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyInMemoryStorage;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyInMemoryTxLockWatcher;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyReadOnlyTxDataShard;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyWriteTxDataShard;
import tech.ydb.yoj.repository.test.inmemory.legacy.NormalExecutionWatcher;

public class LegacyInMemoryRepositoryTransaction
implements BaseDb,
RepositoryTransaction,
TransactionLocal.Holder {
    private final Stopwatch txStopwatch = Stopwatch.createStarted();
    private final NormalExecutionWatcher normalExecutionWatcher = new NormalExecutionWatcher();
    private final List<Runnable> pendingWrites = new ArrayList<Runnable>();
    private final TransactionLocal transactionLocal;
    private final TxOptions options;
    private final LegacyInMemoryTxLockWatcher watcher;
    private final LegacyInMemoryStorage storage;
    private String closeAction = null;

    public LegacyInMemoryRepositoryTransaction(TxOptions options, LegacyInMemoryRepository repository) {
        this.storage = repository.getStorage();
        this.options = options;
        this.transactionLocal = new TransactionLocal(options);
        this.watcher = new LegacyInMemoryTxLockWatcher();
        Preconditions.checkState((!options.isImmediateWrites() ? 1 : 0) != 0);
    }

    public <T extends Entity<T>> Table<T> table(Class<T> c) {
        return new InMemoryTable<T>(this.getMemory(c));
    }

    public <T extends Entity<T>> InMemoryTable.DbMemory<T> getMemory(Class<T> c) {
        throw new UnsupportedOperationException();
    }

    public void commit() {
        this.endTransaction("commit()", this::commitImpl);
    }

    private void commitImpl() {
        if (this.normalExecutionWatcher.hasLastStatementCompletedExceptionally()) {
            throw new IllegalStateException("Transaction should not be committed if the last statement finished exceptionally");
        }
        this.storage.safeRun(() -> {
            this.transactionLocal.projectionCache().applyProjectionChanges((RepositoryTransaction)this);
            this.normalExecutionWatcher.execute(() -> this.storage.checkImpl(this.watcher));
            this.pendingWrites.forEach(Runnable::run);
        });
    }

    public void rollback() {
        this.endTransaction("rollback()", this::rollbackImpl);
    }

    private void rollbackImpl() {
        if (!this.normalExecutionWatcher.hasLastStatementCompletedExceptionally()) {
            this.normalExecutionWatcher.execute(() -> this.storage.checkImpl(this.watcher));
        }
    }

    private void endTransaction(String action, Runnable runnable) {
        try {
            if (this.isFinalActionNeeded(action)) {
                this.logTransaction(action, runnable);
            }
            this.closeAction = action;
        }
        catch (Throwable throwable) {
            this.closeAction = action;
            this.transactionLocal.log().info("[[%s]] TOTAL (since tx start)", new Object[]{this.txStopwatch});
            throw throwable;
        }
        this.transactionLocal.log().info("[[%s]] TOTAL (since tx start)", new Object[]{this.txStopwatch});
    }

    private boolean isFinalActionNeeded(String action) {
        if (this.options.isScan()) {
            this.transactionLocal.log().info("No-op %s: scan tx", new Object[]{action});
            return false;
        }
        if (this.options.isReadOnly()) {
            this.transactionLocal.log().info("No-op %s: read-only tx @%s", new Object[]{action, this.options.getIsolationLevel()});
            return false;
        }
        return true;
    }

    public <T extends Entity<T>> void doInWriteTransaction(String log, Class<T> type, Consumer<LegacyWriteTxDataShard<T>> consumer) {
        if (this.options.isScan()) {
            throw new IllegalTransactionScanException("Mutable operations");
        }
        if (this.options.isReadOnly()) {
            throw new IllegalTransactionIsolationLevelException("Mutable operations", this.options.getIsolationLevel());
        }
        this.pendingWrites.add(() -> this.normalExecutionWatcher.execute(() -> this.logTransaction(log, () -> {
            LegacyWriteTxDataShard shard = this.storage.getWriteTxDataShard(type, this.watcher);
            consumer.accept(shard);
        })));
    }

    public <T extends Entity<T>, R> R doInTransaction(String action, Class<T> type, Function<LegacyReadOnlyTxDataShard<T>, R> func) {
        return (R)this.normalExecutionWatcher.execute(() -> this.logTransaction(action, () -> {
            LegacyReadOnlyTxDataShard shard = this.storage.getReadOnlyTxDataShard(type, this.watcher);
            return func.apply(shard);
        }));
    }

    private void logTransaction(String action, Runnable runnable) {
        this.logTransaction(action, () -> {
            runnable.run();
            return null;
        });
    }

    private <R> R logTransaction(String action, Supplier<R> supplier) {
        if (this.closeAction != null) {
            throw new IllegalStateException("Transaction already closed by " + this.closeAction);
        }
        Stopwatch sw = Stopwatch.createStarted();
        try {
            R result = supplier.get();
            this.transactionLocal.log().debug("[ %s ] %s -> %s", new Object[]{sw, action, this.printResult(result)});
            return result;
        }
        catch (Throwable t) {
            this.transactionLocal.log().debug("[ %s ] %s => %s", new Object[]{sw, action, t});
            throw t;
        }
    }

    private String printResult(Object result) {
        if (result instanceof Iterable) {
            long size = Iterables.size((Iterable)((Iterable)result));
            return size == 1L ? String.valueOf(Iterables.getOnlyElement((Iterable)((Iterable)result))) : "[" + size + "]";
        }
        return String.valueOf(result);
    }

    @Generated
    public TransactionLocal getTransactionLocal() {
        return this.transactionLocal;
    }

    @Generated
    public TxOptions getOptions() {
        return this.options;
    }

    @Generated
    public LegacyInMemoryTxLockWatcher getWatcher() {
        return this.watcher;
    }
}

