/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory.legacy;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.Repository;
import tech.ydb.yoj.repository.db.RepositoryTransaction;
import tech.ydb.yoj.repository.db.SchemaOperations;
import tech.ydb.yoj.repository.db.TxOptions;
import tech.ydb.yoj.repository.db.exception.DropTableException;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyInMemoryRepositoryTransaction;
import tech.ydb.yoj.repository.test.inmemory.legacy.LegacyInMemoryStorage;

public class LegacyInMemoryRepository
implements Repository {
    private final Map<String, LegacyInMemoryStorage> snapshots = new ConcurrentHashMap<String, LegacyInMemoryStorage>();
    private volatile LegacyInMemoryStorage storage = new LegacyInMemoryStorage();

    public void dropDb() {
        this.storage.dropDb();
    }

    public String makeSnapshot() {
        String snapshotId = UUID.randomUUID().toString();
        this.snapshots.put(snapshotId, this.storage.createSnapshot());
        return snapshotId;
    }

    public void loadSnapshot(String id) {
        this.storage = this.snapshots.get(id).createSnapshot();
    }

    public Set<Class<? extends Entity<?>>> tables() {
        return this.storage.tables();
    }

    public RepositoryTransaction startTransaction(TxOptions options) {
        return new LegacyInMemoryRepositoryTransaction(options, this);
    }

    public <T extends Entity<T>> SchemaOperations<T> schema(final Class<T> c) {
        return new SchemaOperations<T>(){

            public void create() {
                LegacyInMemoryRepository.this.storage.createTable(c);
            }

            public void drop() {
                if (!LegacyInMemoryRepository.this.storage.dropTable(c)) {
                    throw new DropTableException(String.format("Can't drop table %s: table doesn't exist", c.getSimpleName()));
                }
            }

            public boolean exists() {
                return LegacyInMemoryRepository.this.storage.containsTable(c);
            }
        };
    }

    @Generated
    LegacyInMemoryStorage getStorage() {
        return this.storage;
    }
}

