/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Range;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.db.ViewSchema;
import tech.ydb.yoj.repository.db.exception.EntityAlreadyExistsException;
import tech.ydb.yoj.repository.db.exception.OptimisticLockException;
import tech.ydb.yoj.repository.test.inmemory.Columns;
import tech.ydb.yoj.repository.test.inmemory.InMemoryEntityLine;
import tech.ydb.yoj.repository.test.inmemory.InMemoryTxLockWatcher;

final class InMemoryDataShard<T extends Entity<T>> {
    private final Class<T> type;
    private final EntitySchema<T> schema;
    private final TreeMap<Entity.Id<T>, InMemoryEntityLine> entityLines;
    private final Map<Long, Set<Entity.Id<T>>> uncommited = new HashMap<Long, Set<Entity.Id<T>>>();

    private InMemoryDataShard(Class<T> type, EntitySchema<T> schema, TreeMap<Entity.Id<T>, InMemoryEntityLine> entityLines) {
        this.type = type;
        this.schema = schema;
        this.entityLines = entityLines;
    }

    public InMemoryDataShard(Class<T> type) {
        this(type, EntitySchema.of(type), InMemoryDataShard.createEmptyLines(type));
    }

    private static <T extends Entity<T>> TreeMap<Entity.Id<T>, InMemoryEntityLine> createEmptyLines(Class<T> type) {
        return new TreeMap<Entity.Id<T>, InMemoryEntityLine>(EntityIdSchema.getIdComparator(type));
    }

    public synchronized InMemoryDataShard<T> createSnapshot() {
        TreeMap<Entity.Id<T>, InMemoryEntityLine> snapshotLines = InMemoryDataShard.createEmptyLines(this.type);
        for (Map.Entry<Entity.Id<T>, InMemoryEntityLine> entry : this.entityLines.entrySet()) {
            snapshotLines.put(entry.getKey(), entry.getValue().createSnapshot());
        }
        return new InMemoryDataShard<T>(this.type, this.schema, snapshotLines);
    }

    public synchronized void commit(long txId, long version) {
        Set<Entity.Id<T>> uncommitedIds = this.uncommited.remove(txId);
        if (uncommitedIds == null) {
            return;
        }
        for (Entity.Id<T> id : uncommitedIds) {
            this.entityLines.get(id).commit(txId, version);
        }
    }

    public synchronized void checkLocks(long version, InMemoryTxLockWatcher watcher) {
        for (Entity.Id<T> lockedId : watcher.getReadRows(this.type)) {
            InMemoryEntityLine entityLine = this.entityLines.get(lockedId);
            if (entityLine == null || !entityLine.hasYounger(version)) continue;
            throw new OptimisticLockException("Row lock failed " + lockedId);
        }
        List<Range<Entity.Id<T>>> lockedRanges = watcher.getReadRanges(this.type);
        if (lockedRanges.isEmpty()) {
            return;
        }
        for (Map.Entry<Entity.Id<T>, InMemoryEntityLine> entry : this.entityLines.entrySet()) {
            if (!entry.getValue().hasYounger(version)) continue;
            for (Range<Entity.Id<T>> lockedRange : lockedRanges) {
                if (!lockedRange.contains(entry.getKey())) continue;
                throw new OptimisticLockException("Table lock failed " + this.type.getSimpleName());
            }
        }
    }

    public synchronized void rollback(long txId) {
        Set<Entity.Id<T>> uncommitedIds = this.uncommited.remove(txId);
        if (uncommitedIds == null) {
            return;
        }
        for (Entity.Id<T> id : uncommitedIds) {
            this.entityLines.get(id).rollback(txId);
        }
    }

    @Nullable
    public synchronized T find(long txId, long version, Entity.Id<T> id, InMemoryTxLockWatcher watcher) {
        this.checkLocks(version, watcher);
        InMemoryEntityLine entityLine = this.entityLines.get(id);
        if (entityLine == null) {
            return null;
        }
        Columns columns = entityLine.get(txId, version);
        return (T)(columns != null ? (Entity)columns.toSchema(this.schema) : null);
    }

    @Nullable
    public synchronized <V extends Table.View> V find(long txId, long version, Entity.Id<T> id, Class<V> viewType, InMemoryTxLockWatcher watcher) {
        this.checkLocks(version, watcher);
        InMemoryEntityLine entityLine = this.entityLines.get(id);
        if (entityLine == null) {
            return null;
        }
        Columns columns = entityLine.get(txId, version);
        return (V)(columns != null ? (Table.View)columns.toSchema(ViewSchema.of(viewType)) : null);
    }

    public synchronized List<T> findAll(long txId, long version, InMemoryTxLockWatcher watcher) {
        this.checkLocks(version, watcher);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (InMemoryEntityLine entityLine : this.entityLines.values()) {
            Columns columns = entityLine.get(txId, version);
            if (columns == null) continue;
            entities.add((Entity)columns.toSchema(this.schema));
        }
        return entities;
    }

    public synchronized void insert(long txId, long version, T entity) {
        InMemoryEntityLine entityLine = this.entityLines.computeIfAbsent(entity.getId(), __ -> new InMemoryEntityLine());
        Columns savedColumns = entityLine.get(txId, version);
        if (savedColumns != null) {
            throw new EntityAlreadyExistsException("Entity " + entity.getId() + " already exists");
        }
        this.save(txId, entity);
    }

    public synchronized void save(long txId, T entity) {
        InMemoryEntityLine entityLine = this.entityLines.computeIfAbsent(entity.getId(), __ -> new InMemoryEntityLine());
        this.uncommited.computeIfAbsent(txId, __ -> new HashSet()).add(entity.getId());
        entityLine.put(txId, Columns.fromEntity(this.schema, entity));
    }

    public synchronized void delete(long txId, Entity.Id<T> id) {
        InMemoryEntityLine entityLine = this.entityLines.get(id);
        if (entityLine == null) {
            return;
        }
        this.uncommited.computeIfAbsent(txId, __ -> new HashSet()).add(id);
        entityLine.remove(txId);
    }

    public synchronized void deleteAll(long txId) {
        for (Entity.Id<T> entityId : this.entityLines.keySet()) {
            this.delete(txId, entityId);
        }
    }
}

