/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.tuple.Tuples;
import tech.ydb.yoj.databind.FieldValueType;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.common.CommonConverters;
import tech.ydb.yoj.repository.db.exception.ConversionException;

final class Columns {
    public static final Columns EMPTY = new Columns((ImmutableMap<String, Object>)Maps.immutable.empty());
    private final ImmutableMap<String, Object> map;

    public static <T extends Entity<T>> Columns fromEntity(EntitySchema<T> schema, T entity) {
        Map cells = schema.flatten(entity);
        ArrayList<Pair> newValues = new ArrayList<Pair>();
        for (Schema.JavaField field : schema.flattenFields()) {
            String column = field.getName();
            Object value = Columns.serialize(field, cells.get(column));
            newValues.add(Tuples.pair((Object)column, (Object)value));
        }
        return new Columns((ImmutableMap<String, Object>)Maps.immutable.empty().newWithAllKeyValues(newValues));
    }

    public <T> T toSchema(Schema<T> schema) {
        try {
            return this.toSchemaUnchecked(schema);
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (Exception e) {
            String message = String.format("Could not convert %s: %s", schema.getName(), e.getMessage());
            throw new ConversionException(message, (Throwable)e);
        }
    }

    private <T> T toSchemaUnchecked(Schema<T> schema) {
        LinkedHashMap<String, Object> cells = new LinkedHashMap<String, Object>();
        for (Schema.JavaField field : schema.flattenFields()) {
            String column = field.getName();
            Object value = Columns.deserialize(field, this.map.get((Object)column));
            cells.put(column, value);
        }
        return (T)schema.newInstance(Collections.unmodifiableMap(cells));
    }

    private static Object serialize(Schema.JavaField field, Object value) {
        if (value == null) {
            return null;
        }
        Type type = field.getType();
        String qualifier = field.getDbTypeQualifier();
        try {
            Preconditions.checkState((boolean)field.isSimple(), (String)"Trying to serialize a non-simple field: %s", (Object)field);
            return switch (field.getValueType()) {
                case FieldValueType.STRING -> CommonConverters.serializeStringValue((Type)type, (Object)value);
                case FieldValueType.ENUM -> {
                    if ("toString".equals(qualifier)) {
                        yield CommonConverters.serializeEnumToStringValue((Type)type, (Object)value);
                    }
                    yield CommonConverters.serializeEnumValue((Type)type, (Object)value);
                }
                case FieldValueType.OBJECT -> CommonConverters.serializeOpaqueObjectValue((Type)type, (Object)value);
                case FieldValueType.BINARY -> (byte[])((byte[])value).clone();
                case FieldValueType.BOOLEAN, FieldValueType.INTEGER, FieldValueType.REAL -> value;
                case FieldValueType.INTERVAL, FieldValueType.TIMESTAMP -> value;
                default -> throw new IllegalStateException("Don't know how to serialize field: " + field);
            };
        }
        catch (Exception e) {
            throw new ConversionException("Could not serialize value of type <" + type + ">", (Throwable)e);
        }
    }

    private static Object deserialize(Schema.JavaField field, Object value) {
        if (value == null) {
            return null;
        }
        Type type = field.getType();
        String qualifier = field.getDbTypeQualifier();
        try {
            Preconditions.checkState((boolean)field.isSimple(), (String)"Trying to deserialize a non-simple field: %s", (Object)field);
            return switch (field.getValueType()) {
                case FieldValueType.STRING -> CommonConverters.deserializeStringValue((Type)type, (Object)value);
                case FieldValueType.ENUM -> {
                    if ("toString".equals(qualifier)) {
                        yield CommonConverters.deserializeEnumToStringValue((Type)type, (Object)value);
                    }
                    yield CommonConverters.deserializeEnumValue((Type)type, (Object)value);
                }
                case FieldValueType.OBJECT -> CommonConverters.deserializeOpaqueObjectValue((Type)type, (Object)value);
                case FieldValueType.BINARY -> (byte[])((byte[])value).clone();
                case FieldValueType.BOOLEAN, FieldValueType.INTEGER, FieldValueType.REAL -> value;
                case FieldValueType.INTERVAL, FieldValueType.TIMESTAMP -> value;
                default -> throw new IllegalStateException("Don't know how to deserialize field: " + field);
            };
        }
        catch (Exception e) {
            throw new ConversionException("Could not deserialize value of type <" + type + ">", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Columns columns = (Columns)o;
        return this.map.equals(columns.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    @ConstructorProperties(value={"map"})
    @Generated
    private Columns(ImmutableMap<String, Object> map) {
        this.map = map;
    }
}

