/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.generator;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Types;

record FieldInfo(String name, String type) {
    public static List<FieldInfo> extractAllFields(Element classElement, Types typeUtils) {
        return classElement.getEnclosedElements().stream().filter(FieldInfo::isFieldRelevant).map(element -> FieldInfo.extractField(element, typeUtils)).toList();
    }

    private static FieldInfo extractField(Element fieldElementName, Types typeUtils) {
        return new FieldInfo(fieldElementName.getSimpleName().toString(), FieldInfo.calcType(fieldElementName, typeUtils));
    }

    private static String calcType(Element element, Types typeUtils) {
        Element nonPrimitiveType = typeUtils.asElement(element.asType());
        if (nonPrimitiveType != null && (nonPrimitiveType.getKind() == ElementKind.CLASS || nonPrimitiveType.getKind() == ElementKind.RECORD)) {
            return ((TypeElement)nonPrimitiveType).getQualifiedName().toString();
        }
        return "-primitive-";
    }

    private static boolean isFieldRelevant(Element e) {
        if (e.getKind() != ElementKind.FIELD) {
            return false;
        }
        VariableElement variableElement = (VariableElement)e;
        return !variableElement.getModifiers().contains((Object)Modifier.STATIC) && !variableElement.getModifiers().contains((Object)Modifier.TRANSIENT);
    }
}

