/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.generator;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.yoj.databind.schema.Table;
import tech.ydb.yoj.generator.SourceClassStructure;
import tech.ydb.yoj.generator.StringConstantsRenderer;
import tech.ydb.yoj.generator.TargetClassStructure;
import tech.ydb.yoj.generator.Utils;

@SupportedAnnotationTypes(value={"tech.ydb.yoj.databind.schema.Table"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class FieldGeneratorAnnotationProcessor
extends AbstractProcessor {
    private static final Logger log = LoggerFactory.getLogger(FieldGeneratorAnnotationProcessor.class);
    private static final String TARGET_PACKAGE = "generated";
    private static final String TARGET_CLASS_NAME_SUFFIX = "Fields";

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<? extends Element> elementsAnnotatedWith = roundEnvironment.getElementsAnnotatedWith(Table.class);
        log.info("Found {} classes to process ", (Object)elementsAnnotatedWith.size());
        for (Element element : elementsAnnotatedWith) {
            log.debug("Processing {}", (Object)element.getSimpleName());
            SourceClassStructure sourceClassStructure = SourceClassStructure.analyse(element, this.processingEnv.getTypeUtils());
            TargetClassStructure targetClassStructure = TargetClassStructure.build(sourceClassStructure, element.getSimpleName() + TARGET_CLASS_NAME_SUFFIX);
            String packageName = Utils.concatFieldNameChain(this.calcPackage(element), TARGET_PACKAGE);
            String generatedSource = StringConstantsRenderer.render(targetClassStructure, packageName);
            log.debug("Generated:\n {}", (Object)generatedSource);
            this.saveFile(generatedSource, Utils.concatFieldNameChain(packageName, targetClassStructure.className()));
        }
        return false;
    }

    private String calcPackage(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        PackageElement packageElement = (PackageElement)element;
        return packageElement.getQualifiedName().toString();
    }

    private void saveFile(String classContent, String fullClassName) {
        try {
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(fullClassName, new Element[0]);
            try (Writer writer = file.openWriter();){
                writer.write(classContent);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Can not save file %s. Content:\n%s".formatted(fullClassName, classContent), ex);
        }
    }
}

