/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.settings;

import io.grpc.ExperimentalApi;
import java.util.concurrent.TimeUnit;
import tech.ydb.common.transaction.YdbTransaction;

public class ReceiveSettings {
    private Long timeout;
    private TimeUnit timeoutTimeUnit;
    private final YdbTransaction transaction;

    private ReceiveSettings(Builder builder) {
        this.timeout = builder.timeout;
        this.timeoutTimeUnit = builder.timeoutTimeUnit;
        this.transaction = builder.transaction;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public YdbTransaction getTransaction() {
        return this.transaction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Long timeout;
        private TimeUnit timeoutTimeUnit;
        private YdbTransaction transaction;

        public Builder setTimeout(long timeout, TimeUnit unit) {
            this.timeout = timeout;
            this.timeoutTimeUnit = unit;
            return this;
        }

        @ExperimentalApi(value="New transaction interfaces are experimental and may change without notice")
        public Builder setTransaction(YdbTransaction transaction) {
            if (!transaction.isActive()) {
                throw new IllegalArgumentException("Transaction is not active. Can only write topic messages in already running transactions from other services");
            }
            this.transaction = transaction;
            return this;
        }

        public ReceiveSettings build() {
            return new ReceiveSettings(this);
        }
    }
}

