/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.settings;

import java.util.concurrent.Executor;
import tech.ydb.topic.read.events.ReadEventHandler;

public class ReadEventHandlersSettings {
    private final Executor executor;
    private final ReadEventHandler eventHandler;

    private ReadEventHandlersSettings(Builder builder) {
        this.executor = builder.executor;
        this.eventHandler = builder.eventHandler;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ReadEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Executor executor;
        private ReadEventHandler eventHandler;

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setEventHandler(ReadEventHandler eventHandler) {
            this.eventHandler = eventHandler;
            return this;
        }

        public ReadEventHandlersSettings build() {
            return new ReadEventHandlersSettings(this);
        }
    }
}

