/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.settings;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ydb.core.settings.OperationSettings;
import tech.ydb.topic.description.Consumer;
import tech.ydb.topic.description.MeteringMode;
import tech.ydb.topic.description.SupportedCodecs;
import tech.ydb.topic.settings.AlterConsumerSettings;
import tech.ydb.topic.settings.AlterPartitioningSettings;

public class AlterTopicSettings
extends OperationSettings {
    @Nullable
    private final AlterPartitioningSettings alterPartitioningSettings;
    @Nullable
    private final Duration retentionPeriod;
    @Nullable
    private final Long retentionStorageMb;
    @Nullable
    private final SupportedCodecs supportedCodecs;
    @Nullable
    private final Long partitionWriteSpeedBytesPerSecond;
    @Nullable
    private final Long partitionWriteBurstBytes;
    private final Map<String, String> alterAttributes;
    private final List<Consumer> addConsumers;
    private final List<String> dropConsumers;
    private final List<AlterConsumerSettings> alterConsumers;
    @Nullable
    private final MeteringMode meteringMode;

    private AlterTopicSettings(Builder builder) {
        super((OperationSettings.OperationBuilder)builder);
        this.alterPartitioningSettings = builder.alterPartitioningSettings;
        this.retentionPeriod = builder.retentionPeriod;
        this.retentionStorageMb = builder.retentionStorageMb;
        this.supportedCodecs = builder.supportedCodecs;
        this.partitionWriteSpeedBytesPerSecond = builder.partitionWriteSpeedBytesPerSecond;
        this.partitionWriteBurstBytes = builder.partitionWriteBurstBytes;
        this.alterAttributes = ImmutableMap.copyOf((Map)builder.alterAttributes);
        this.addConsumers = ImmutableList.copyOf((Collection)builder.addConsumers);
        this.dropConsumers = ImmutableList.copyOf((Collection)builder.dropConsumers);
        this.alterConsumers = ImmutableList.copyOf((Collection)builder.alterConsumers);
        this.meteringMode = builder.meteringMode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    public AlterPartitioningSettings getAlterPartitioningSettings() {
        return this.alterPartitioningSettings;
    }

    @Nullable
    public Duration getRetentionPeriod() {
        return this.retentionPeriod;
    }

    @Nullable
    public Long getRetentionStorageMb() {
        return this.retentionStorageMb;
    }

    @Nullable
    public SupportedCodecs getSupportedCodecs() {
        return this.supportedCodecs;
    }

    @Nullable
    public Long getPartitionWriteSpeedBytesPerSecond() {
        return this.partitionWriteSpeedBytesPerSecond;
    }

    @Nullable
    public Long getPartitionWriteBurstBytes() {
        return this.partitionWriteBurstBytes;
    }

    public Map<String, String> getAlterAttributes() {
        return this.alterAttributes;
    }

    public List<Consumer> getAddConsumers() {
        return this.addConsumers;
    }

    public List<String> getDropConsumers() {
        return this.dropConsumers;
    }

    public List<AlterConsumerSettings> getAlterConsumers() {
        return this.alterConsumers;
    }

    @Nullable
    public MeteringMode getMeteringMode() {
        return this.meteringMode;
    }

    public static class Builder
    extends OperationSettings.OperationBuilder<Builder> {
        private AlterPartitioningSettings alterPartitioningSettings = null;
        private Duration retentionPeriod = null;
        private Long retentionStorageMb = null;
        private SupportedCodecs supportedCodecs = null;
        private Long partitionWriteSpeedBytesPerSecond = null;
        private Long partitionWriteBurstBytes = null;
        private Map<String, String> alterAttributes = new HashMap<String, String>();
        private List<Consumer> addConsumers = new ArrayList<Consumer>();
        private List<String> dropConsumers = new ArrayList<String>();
        private List<AlterConsumerSettings> alterConsumers = new ArrayList<AlterConsumerSettings>();
        private MeteringMode meteringMode = null;

        public Builder setAlterPartitioningSettings(AlterPartitioningSettings alterPartitioningSettings) {
            this.alterPartitioningSettings = alterPartitioningSettings;
            return this;
        }

        public Builder setRetentionPeriod(Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public Builder setRetentionStorageMb(long retentionStorageMb) {
            this.retentionStorageMb = retentionStorageMb;
            return this;
        }

        public Builder setSupportedCodecs(SupportedCodecs supportedCodecs) {
            this.supportedCodecs = supportedCodecs;
            return this;
        }

        public Builder setPartitionWriteSpeedBytesPerSecond(long partitionWriteSpeedBytesPerSecond) {
            this.partitionWriteSpeedBytesPerSecond = partitionWriteSpeedBytesPerSecond;
            return this;
        }

        public Builder setPartitionWriteBurstBytes(long partitionWriteBurstBytes) {
            this.partitionWriteBurstBytes = partitionWriteBurstBytes;
            return this;
        }

        public Builder addAlterAttribute(@Nonnull String name, @Nullable String value) {
            this.alterAttributes.put(name, value);
            return this;
        }

        public Builder setAlterAttributes(Map<String, String> attributes) {
            this.alterAttributes = attributes;
            return this;
        }

        public Builder addAddConsumer(Consumer consumer) {
            this.addConsumers.add(consumer);
            return this;
        }

        public Builder setAddConsumers(List<Consumer> consumers) {
            this.addConsumers = consumers;
            return this;
        }

        public Builder addDropConsumer(@Nonnull String consumerName) {
            this.dropConsumers.add(consumerName);
            return this;
        }

        public Builder setDropConsumers(List<String> consumerNames) {
            this.dropConsumers = consumerNames;
            return this;
        }

        public Builder addAlterConsumer(AlterConsumerSettings consumer) {
            this.alterConsumers.add(consumer);
            return this;
        }

        public Builder setAlterConsumers(List<AlterConsumerSettings> consumers) {
            this.alterConsumers = consumers;
            return this;
        }

        public Builder setMeteringMode(MeteringMode meteringMode) {
            this.meteringMode = meteringMode;
            return this;
        }

        public AlterTopicSettings build() {
            return new AlterTopicSettings(this);
        }
    }
}

