/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.read.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Status;
import tech.ydb.proto.topic.YdbTopic;
import tech.ydb.topic.TopicRpc;
import tech.ydb.topic.read.Message;
import tech.ydb.topic.read.PartitionSession;
import tech.ydb.topic.read.SyncReader;
import tech.ydb.topic.read.events.DataReceivedEvent;
import tech.ydb.topic.read.impl.ReaderImpl;
import tech.ydb.topic.settings.ReaderSettings;
import tech.ydb.topic.settings.ReceiveSettings;
import tech.ydb.topic.settings.StartPartitionSessionSettings;
import tech.ydb.topic.settings.UpdateOffsetsInTransactionSettings;

public class SyncReaderImpl
extends ReaderImpl
implements SyncReader {
    private static final Logger logger = LoggerFactory.getLogger(SyncReaderImpl.class);
    private static final int POLL_INTERVAL_SECONDS = 5;
    private final Queue<MessageBatchWrapper> batchesInQueue = new LinkedList<MessageBatchWrapper>();
    private final ReentrantLock queueLock = new ReentrantLock();
    private final Condition queueIsNotEmptyCondition = this.queueLock.newCondition();
    private int currentMessageIndex = 0;

    public SyncReaderImpl(TopicRpc topicRpc, ReaderSettings settings) {
        super(topicRpc, settings);
    }

    @Override
    public void init() {
        this.initImpl();
    }

    @Override
    public void initAndWait() {
        this.initImpl().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Message receiveInternal(ReceiveSettings receiveSettings, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isStopped.get()) {
            throw new RuntimeException("Reader was stopped");
        }
        this.queueLock.lock();
        try {
            Status updateStatus;
            if (this.batchesInQueue.isEmpty()) {
                long millisToWait = TimeUnit.MILLISECONDS.convert(timeout, unit);
                Instant deadline = Instant.now().plusMillis(millisToWait);
                while (this.batchesInQueue.isEmpty() && (millisToWait = Duration.between(Instant.now(), deadline).toMillis()) > 0L) {
                    logger.trace("No messages in queue. Waiting for {} ms...", (Object)millisToWait);
                    this.queueIsNotEmptyCondition.await(millisToWait, TimeUnit.MILLISECONDS);
                }
                if (this.batchesInQueue.isEmpty()) {
                    logger.trace("Still no messages in queue. Returning null");
                    Message message = null;
                    return message;
                }
            }
            logger.trace("Taking a message with index {} from batch", (Object)this.currentMessageIndex);
            MessageBatchWrapper currentBatch = this.batchesInQueue.element();
            Message result = (Message)currentBatch.messages.get(this.currentMessageIndex);
            ++this.currentMessageIndex;
            if (this.currentMessageIndex >= currentBatch.messages.size()) {
                logger.debug("Batch is read. signalling core reader impl");
                this.batchesInQueue.remove();
                this.currentMessageIndex = 0;
                currentBatch.future.complete(null);
            }
            if (receiveSettings.getTransaction() != null && !(updateStatus = this.sendUpdateOffsetsInTransaction(receiveSettings.getTransaction(), Collections.singletonMap(result.getPartitionSession().getPath(), Collections.singletonList(result.getPartitionOffsets())), UpdateOffsetsInTransactionSettings.newBuilder().build()).join()).isSuccess()) {
                throw new RuntimeException("Couldn't add message offset " + result.getOffset() + " to transaction " + receiveSettings.getTransaction().getId() + ": " + updateStatus);
            }
            Message message = result;
            return message;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Override
    public Message receive(ReceiveSettings receiveSettings) throws InterruptedException {
        Message result;
        if (receiveSettings.getTimeout() != null) {
            return this.receiveInternal(receiveSettings, receiveSettings.getTimeout(), receiveSettings.getTimeoutTimeUnit());
        }
        while ((result = this.receiveInternal(receiveSettings, 5L, TimeUnit.SECONDS)) == null) {
        }
        return result;
    }

    @Override
    protected CompletableFuture<Void> handleDataReceivedEvent(DataReceivedEvent event) {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        if (this.isStopped.get()) {
            resultFuture.completeExceptionally(new RuntimeException("Reader was stopped"));
            return resultFuture;
        }
        if (event.getMessages().isEmpty()) {
            resultFuture.completeExceptionally(new RuntimeException("Batch has no messages"));
            return resultFuture;
        }
        this.queueLock.lock();
        try {
            logger.debug("Putting a message batch into queue and notifying in case receive method is waiting");
            this.batchesInQueue.add(new MessageBatchWrapper(event.getMessages(), resultFuture));
            this.queueIsNotEmptyCondition.signal();
        }
        finally {
            this.queueLock.unlock();
        }
        return resultFuture;
    }

    @Override
    protected void handleCommitResponse(long committedOffset, PartitionSession partitionSession) {
        if (logger.isDebugEnabled()) {
            logger.debug("CommitResponse received for partition session {} (partition {}) with committedOffset {}", new Object[]{partitionSession.getId(), partitionSession.getPartitionId(), committedOffset});
        }
    }

    @Override
    protected void handleStartPartitionSessionRequest(YdbTopic.StreamReadMessage.StartPartitionSessionRequest request, PartitionSession partitionSession, Consumer<StartPartitionSessionSettings> confirmCallback) {
        confirmCallback.accept(null);
    }

    @Override
    protected void handleStopPartitionSession(YdbTopic.StreamReadMessage.StopPartitionSessionRequest request, PartitionSession partitionSession, Runnable confirmCallback) {
        confirmCallback.run();
    }

    @Override
    protected void handleClosePartitionSession(PartitionSession partitionSession) {
        logger.debug("ClosePartitionSession event received. Ignoring.");
    }

    @Override
    public void shutdown() {
        this.shutdownImpl().join();
    }

    private static class MessageBatchWrapper {
        private final List<Message> messages;
        private final CompletableFuture<Void> future;

        private MessageBatchWrapper(List<Message> messages, CompletableFuture<Void> future) {
            this.messages = messages;
            this.future = future;
        }
    }
}

