/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.topic.impl.Session;

public abstract class SessionBase<R, W>
implements Session {
    protected final GrpcReadWriteStream<R, W> streamConnection;
    protected final AtomicBoolean isWorking = new AtomicBoolean(true);
    private final ReentrantLock lock = new ReentrantLock();
    private String token;

    public SessionBase(GrpcReadWriteStream<R, W> streamConnection) {
        this.streamConnection = streamConnection;
        this.token = streamConnection.authToken();
    }

    protected abstract Logger getLogger();

    protected abstract void sendUpdateTokenRequest(String var1);

    protected abstract void onStop();

    protected CompletableFuture<Status> start(GrpcReadStream.Observer<R> streamObserver) {
        this.lock.lock();
        try {
            this.getLogger().info("Session start");
            CompletableFuture completableFuture = this.streamConnection.start(message -> {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("Message received:\n{}", message);
                } else {
                    this.getLogger().debug("Message received");
                }
                if (this.isWorking.get()) {
                    streamObserver.onNext(message);
                }
            });
            return completableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void send(W request) {
        this.lock.lock();
        try {
            if (!this.isWorking.get()) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("Session is already closed. This message is NOT sent:\n{}", request);
                }
                return;
            }
            String currentToken = this.streamConnection.authToken();
            if (!Objects.equals(this.token, currentToken)) {
                this.token = currentToken;
                this.getLogger().info("Sending new token");
                this.sendUpdateTokenRequest(this.token);
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Sending request:\n{}", request);
            } else {
                this.getLogger().debug("Sending request");
            }
            this.streamConnection.sendNext(request);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean stop() {
        this.getLogger().info("Session stop");
        return this.isWorking.compareAndSet(true, false);
    }

    @Override
    public boolean shutdown() {
        this.lock.lock();
        try {
            this.getLogger().info("Session shutdown");
            if (this.stop()) {
                this.onStop();
                this.streamConnection.close();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

