/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.description;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import javax.annotation.Nullable;
import tech.ydb.core.utils.ProtobufUtils;
import tech.ydb.proto.topic.YdbTopic;
import tech.ydb.topic.description.MultipleWindowsStat;

public class ConsumerStats {
    private final Instant minPartitionsLastReadTime;
    @Nullable
    private final java.time.Duration maxReadTimeLag;
    @Nullable
    private final java.time.Duration maxWriteTimeLag;
    private final MultipleWindowsStat bytesRead;

    @Deprecated
    private ConsumerStats(Builder builder) {
        this.minPartitionsLastReadTime = builder.minPartitionsLastReadTime;
        this.maxReadTimeLag = builder.maxReadTimeLag;
        this.maxWriteTimeLag = builder.maxWriteTimeLag;
        this.bytesRead = builder.bytesRead;
    }

    public ConsumerStats(YdbTopic.Consumer.ConsumerStats stats) {
        this.minPartitionsLastReadTime = ProtobufUtils.protoToInstant((Timestamp)stats.getMinPartitionsLastReadTime());
        this.maxReadTimeLag = ProtobufUtils.protoToDuration((Duration)stats.getMaxReadTimeLag());
        this.maxWriteTimeLag = ProtobufUtils.protoToDuration((Duration)stats.getMaxWriteTimeLag());
        this.bytesRead = new MultipleWindowsStat(stats.getBytesRead().getPerMinute(), stats.getBytesRead().getPerHour(), stats.getBytesRead().getPerDay());
    }

    @Deprecated
    public static Builder newBuilder() {
        return new Builder();
    }

    public Instant getMinPartitionsLastReadTime() {
        return this.minPartitionsLastReadTime;
    }

    @Nullable
    public java.time.Duration getMaxReadTimeLag() {
        return this.maxReadTimeLag;
    }

    @Nullable
    public java.time.Duration getMaxWriteTimeLag() {
        return this.maxWriteTimeLag;
    }

    public MultipleWindowsStat getBytesRead() {
        return this.bytesRead;
    }

    @Deprecated
    public static class Builder {
        private Instant minPartitionsLastReadTime = Instant.EPOCH;
        private java.time.Duration maxReadTimeLag = null;
        private java.time.Duration maxWriteTimeLag = null;
        private MultipleWindowsStat bytesRead;

        public Builder setMinPartitionsLastReadTime(Instant minPartitionsLastReadTime) {
            this.minPartitionsLastReadTime = minPartitionsLastReadTime;
            return this;
        }

        public Builder setMaxReadTimeLag(java.time.Duration maxReadTimeLag) {
            this.maxReadTimeLag = maxReadTimeLag;
            return this;
        }

        public Builder setMaxWriteTimeLag(java.time.Duration maxWriteTimeLag) {
            this.maxWriteTimeLag = maxWriteTimeLag;
            return this;
        }

        public Builder setBytesRead(MultipleWindowsStat bytesRead) {
            this.bytesRead = bytesRead;
            return this;
        }

        public ConsumerStats build() {
            return new ConsumerStats(this);
        }
    }
}

