/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.description;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.List;
import tech.ydb.core.utils.ProtobufUtils;
import tech.ydb.proto.topic.YdbTopic;
import tech.ydb.topic.description.MultipleWindowsStat;
import tech.ydb.topic.description.PartitionLocation;
import tech.ydb.topic.description.PartitionStats;

public class ConsumerPartitionInfo {
    private final long partitionId;
    private final boolean active;
    private final List<Long> childPartitionIds;
    private final List<Long> parentPartitionIds;
    private final PartitionStats partitionStats;
    private final ConsumerStats consumerStats;
    private final PartitionLocation location;

    public ConsumerPartitionInfo(YdbTopic.DescribeConsumerResult.PartitionInfo result) {
        this.partitionId = result.getPartitionId();
        this.active = result.getActive();
        this.childPartitionIds = result.getChildPartitionIdsList();
        this.parentPartitionIds = result.getParentPartitionIdsList();
        this.partitionStats = new PartitionStats(result.getPartitionStats());
        this.consumerStats = new ConsumerStats(result.getPartitionConsumerStats());
        this.location = new PartitionLocation(result.getPartitionLocation());
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public boolean isActive() {
        return this.active;
    }

    public List<Long> getChildPartitionIds() {
        return this.childPartitionIds;
    }

    public List<Long> getParentPartitionIds() {
        return this.parentPartitionIds;
    }

    public PartitionStats getPartitionStats() {
        return this.partitionStats;
    }

    public ConsumerStats getConsumerStats() {
        return this.consumerStats;
    }

    public PartitionLocation getPartitionLocation() {
        return this.location;
    }

    public static class ConsumerStats {
        private final long lastReadOffset;
        private final long committedOffset;
        private final String readSessionId;
        private final Instant partitionReadSessionCreateTime;
        private final Instant lastReadTime;
        private final java.time.Duration maxReadTimeLag;
        private final java.time.Duration maxWriteTimeLag;
        private final MultipleWindowsStat bytesRead;
        private final String readerName;
        private final int connectionNodeId;

        public ConsumerStats(YdbTopic.DescribeConsumerResult.PartitionConsumerStats stats) {
            this.lastReadOffset = stats.getLastReadOffset();
            this.committedOffset = stats.getCommittedOffset();
            this.readSessionId = stats.getReadSessionId();
            this.partitionReadSessionCreateTime = ProtobufUtils.protoToInstant((Timestamp)stats.getPartitionReadSessionCreateTime());
            this.lastReadTime = ProtobufUtils.protoToInstant((Timestamp)stats.getLastReadTime());
            this.maxReadTimeLag = ProtobufUtils.protoToDuration((Duration)stats.getMaxReadTimeLag());
            this.maxWriteTimeLag = ProtobufUtils.protoToDuration((Duration)stats.getMaxWriteTimeLag());
            this.bytesRead = new MultipleWindowsStat(stats.getBytesRead());
            this.readerName = stats.getReaderName();
            this.connectionNodeId = stats.getConnectionNodeId();
        }

        public long getLastReadOffset() {
            return this.lastReadOffset;
        }

        public long getCommittedOffset() {
            return this.committedOffset;
        }

        public String getReadSessionId() {
            return this.readSessionId;
        }

        public Instant getPartitionReadSessionCreateTime() {
            return this.partitionReadSessionCreateTime;
        }

        public Instant getLastReadTime() {
            return this.lastReadTime;
        }

        public java.time.Duration getMaxReadTimeLag() {
            return this.maxReadTimeLag;
        }

        public java.time.Duration getMaxWriteTimeLag() {
            return this.maxWriteTimeLag;
        }

        public MultipleWindowsStat getBytesRead() {
            return this.bytesRead;
        }

        public String getReaderName() {
            return this.readerName;
        }

        public int getConnectionNodeId() {
            return this.connectionNodeId;
        }
    }
}

