/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.utils;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoCompressor;
import org.anarres.lzo.LzoLibrary;
import org.anarres.lzo.LzoOutputStream;
import org.anarres.lzo.LzopInputStream;
import tech.ydb.topic.description.Codec;

public class Encoder {
    private Encoder() {
    }

    public static byte[] encode(Codec codec, byte[] input) {
        if (codec == Codec.RAW) {
            return input;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream os;
            switch (codec) {
                case GZIP: {
                    os = new GZIPOutputStream(byteArrayOutputStream);
                    break;
                }
                case ZSTD: {
                    os = new ZstdOutputStream((OutputStream)byteArrayOutputStream);
                    break;
                }
                case LZOP: {
                    LzoCompressor lzoCompressor = LzoLibrary.getInstance().newCompressor(LzoAlgorithm.LZO1X, null);
                    os = new LzoOutputStream((OutputStream)byteArrayOutputStream, lzoCompressor);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported codec: " + (Object)((Object)codec));
                }
            }
            ((OutputStream)os).write(input);
            ((OutputStream)os).close();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decode(Codec codec, byte[] input) throws IOException {
        int length;
        GZIPInputStream is;
        if (codec == Codec.RAW) {
            return input;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(input);
        switch (codec) {
            case GZIP: {
                is = new GZIPInputStream(byteArrayInputStream);
                break;
            }
            case ZSTD: {
                is = new ZstdInputStream((InputStream)byteArrayInputStream);
                break;
            }
            case LZOP: {
                is = new LzopInputStream((InputStream)byteArrayInputStream);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported codec: " + (Object)((Object)codec));
            }
        }
        byte[] buffer = new byte[1024];
        while ((length = ((InputStream)is).read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, length);
        }
        ((InputStream)is).close();
        return byteArrayOutputStream.toByteArray();
    }
}

