/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.settings;

import io.grpc.ExperimentalApi;
import tech.ydb.common.transaction.YdbTransaction;

public class SendSettings {
    private final YdbTransaction transaction;

    private SendSettings(Builder builder) {
        this.transaction = builder.transaction;
    }

    public YdbTransaction getTransaction() {
        return this.transaction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private YdbTransaction transaction;

        @ExperimentalApi(value="New transaction interfaces are experimental and may change without notice")
        public Builder setTransaction(YdbTransaction transaction) {
            if (!transaction.isActive()) {
                throw new IllegalArgumentException("Transaction is not active. Can only write topic messages in already running transactions from other services");
            }
            this.transaction = transaction;
            return this;
        }

        public SendSettings build() {
            return new SendSettings(this);
        }
    }
}

